/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.peek.utils;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7924;

public class ItemNameCache {
    private static Map<String, class_1792> translatedItemNamesCache = new HashMap<String, class_1792>();
    private static Map<String, class_1792> translatedItemIdNamesCache = new HashMap<String, class_1792>();

    public static void loadTranslatedNames(class_638 clientLevel) {
        translatedItemNamesCache.clear();
        class_2378 itemRegistry = clientLevel.method_30349().method_30530(class_7924.field_41197);
        for (class_1792 item : itemRegistry) {
            class_5250 name = class_2561.method_43471((String)item.method_7876());
            translatedItemNamesCache.put(name.getString().toLowerCase(), item);
        }
    }

    public static void loadIdNames(class_638 clientLevel) {
        translatedItemIdNamesCache.clear();
        class_2378 itemRegistry = clientLevel.method_30349().method_30530(class_7924.field_41197);
        for (Map.Entry item : itemRegistry.method_29722()) {
            class_2960 location = ((class_5321)item.getKey()).method_29177();
            if (location.method_12836().equals("minecraft")) {
                translatedItemIdNamesCache.put(ItemNameCache.getResourceLocationName(location.method_12832()), (class_1792)item.getValue());
                continue;
            }
            translatedItemIdNamesCache.put("%s %s".formatted(ItemNameCache.getResourceLocationName(location.method_12836()), ItemNameCache.getResourceLocationName(location.method_12832())), (class_1792)item.getValue());
        }
    }

    private static String getResourceLocationName(String str) {
        return str.replace("_", " ").replace("/", " ").toLowerCase().trim();
    }

    @Nullable
    public static class_1792 byName(String translatedName) {
        return translatedItemNamesCache.get(translatedName.toLowerCase().trim());
    }

    @Nullable
    public static class_1792 byIdName(String translatedName) {
        return translatedItemIdNamesCache.get(translatedName.toLowerCase().trim());
    }
}

