/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.rainbegoneritual_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import java.util.ArrayList;
import java.util.Date;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RitualEvent {
    private static Pair<Date, BlockPos> lastritual = null;

    public static boolean onClick(Level level, Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitVec) {
        if (level.isClientSide) {
            return true;
        }
        if (!level.isRaining()) {
            return true;
        }
        if (!WorldFunctions.isOverworld((Level)level)) {
            return true;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem().equals(Items.FLINT_AND_STEEL)) {
            Block clickblock = level.getBlockState(pos).getBlock();
            if (!(clickblock instanceof RotatedPillarBlock)) {
                return true;
            }
            BlockPos firepos = pos.above();
            Block prefireblock = level.getBlockState(firepos).getBlock();
            if (prefireblock.equals(Blocks.AIR)) {
                ArrayList<BlockPos> cauldronposses = new ArrayList<BlockPos>();
                for (Object np : BlockPos.betweenClosed((int)(pos.getX() - 1), (int)pos.getY(), (int)(pos.getZ() - 1), (int)(pos.getX() + 1), (int)pos.getY(), (int)(pos.getZ() + 1))) {
                    if (!(level.getBlockState((BlockPos)np).getBlock() instanceof AbstractCauldronBlock)) continue;
                    cauldronposses.add(np.immutable());
                }
                if (cauldronposses.size() < 4) {
                    return true;
                }
                Vec3 firevec = new Vec3((double)firepos.getX(), (double)firepos.getY(), (double)firepos.getZ());
                lastritual = new Pair((Object)new Date(), (Object)firepos.immutable());
                level.explode(null, level.damageSources().explosion((Explosion)null), null, firevec.x, firevec.y, firevec.z, 3.0f, false, Level.ExplosionInteraction.NONE);
                for (BlockPos cauldronpos : cauldronposses) {
                    level.setBlock(cauldronpos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)), 3);
                }
                level.setBlockAndUpdate(firepos, Blocks.AIR.defaultBlockState());
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                LevelData info = level.getLevelData();
                info.setRaining(false);
            }
        }
        return true;
    }

    public static float onExplosionDamage(Level level, Entity entity, DamageSource source, float damageAmount) {
        if (level.isClientSide) {
            return damageAmount;
        }
        if (!(entity instanceof Player)) {
            return damageAmount;
        }
        if (lastritual == null) {
            return damageAmount;
        }
        if (source.is(DamageTypes.EXPLOSION)) {
            Player player = (Player)entity;
            BlockPos ppos = player.blockPosition();
            Date now = new Date();
            Date lastdate = (Date)lastritual.getFirst();
            long ms = now.getTime() - lastdate.getTime();
            if (ms > 1000L) {
                lastritual = null;
                return damageAmount;
            }
            BlockPos ritualpos = (BlockPos)lastritual.getSecond();
            if (ppos.closerThan((Vec3i)ritualpos, 10.0)) {
                return 0.0f;
            }
        }
        return damageAmount;
    }
}

