/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.util;

import java.text.DecimalFormat;

public class StringUtil {
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    private static final double TB = 1.099511627776E12;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;

    private StringUtil() {
    }

    public static String formatBytes(long l) {
        if ((double)l >= 5.49755813888E11) {
            return String.format("%s TB", StringUtil.formatToTwoDecimals((double)l / 1.099511627776E12));
        }
        if ((double)l >= 5.36870912E8) {
            return String.format("%s GB", StringUtil.formatToTwoDecimals((double)l / 1.073741824E9));
        }
        if ((double)l >= 524288.0) {
            return String.format("%s MB", StringUtil.formatToTwoDecimals((double)l / 1048576.0));
        }
        if ((double)l >= 512.0) {
            return String.format("%s KB", StringUtil.formatToTwoDecimals((double)l / 1024.0));
        }
        return l + " B";
    }

    public static String formatDuration(long l) {
        if (l >= 3600000L) {
            long l2 = l / 3600000L;
            long l3 = l % 3600000L / 60000L;
            return String.format("%sh, %sm", l2, l3);
        }
        if (l >= 60000L) {
            long l4 = l / 60000L;
            long l5 = l % 60000L / 1000L;
            return String.format("%sm, %ss", l4, l5);
        }
        if (l >= 1000L) {
            return String.format("%ss", StringUtil.formatToTwoDecimals((double)l / 1000.0));
        }
        return l + "ms";
    }

    public static String formatToTwoDecimals(double d) {
        return new DecimalFormat("0.##").format(d);
    }
}

