/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.roundaround.custompaintings.util.InvalidIdException;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record CustomId(String pack, String resource) implements Comparable<CustomId>
{
    public static final Codec<CustomId> CODEC = Codec.STRING.comapFlatMap(CustomId::validate, CustomId::toString);
    public static final class_9139<ByteBuf, CustomId> PACKET_CODEC = class_9135.field_48554.method_56432(CustomId::parse, CustomId::toString);
    private static final Predicate<String> IS_VALID_PART = Pattern.compile("^[^\\s:'\"]+$").asMatchPredicate();
    private static final Predicate<String> IS_VALID_ID = Pattern.compile("^(?:[^\\s:'\"]+:)?[^\\s:'\"]+$").asMatchPredicate();
    private static final Predicate<String> IS_VALID_SHAPE = Pattern.compile("^(?:[^:]+:)?[^:]+$").asMatchPredicate();

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CustomId)) {
            return false;
        }
        CustomId customId = (CustomId)object;
        return Objects.equals(this.pack, customId.pack) && Objects.equals(this.resource, customId.resource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pack, this.resource);
    }

    @Override
    public int compareTo(@NotNull CustomId customId) {
        int n = this.resource.compareTo(customId.resource);
        if (n == 0) {
            n = this.pack.compareTo(customId.pack);
        }
        return n;
    }

    @Override
    public String toString() {
        return String.format("%s:%s", this.pack(), this.resource());
    }

    public class_2960 toIdentifier() {
        return class_2960.method_60655((String)this.pack(), (String)this.resource());
    }

    public String toTranslationKey() {
        return String.format("%s.%s", this.pack(), this.resource());
    }

    public String toTranslationKey(String string) {
        return string + "." + this.toTranslationKey();
    }

    public String toTranslationKey(String string, String string2) {
        return string + "." + this.toTranslationKey() + "." + string2;
    }

    public void write(class_2540 class_25402) {
        PACKET_CODEC.encode((Object)class_25402, (Object)this);
    }

    public static class_2960 toIdentifier(CustomId customId) {
        if (customId == null) {
            return null;
        }
        return customId.toIdentifier();
    }

    public static CustomId read(class_2540 class_25402) {
        return (CustomId)PACKET_CODEC.decode((Object)class_25402);
    }

    public static CustomId from(class_2960 class_29602) {
        return new CustomId(class_29602.method_12836(), class_29602.method_12832());
    }

    public static CustomId parse(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return new CustomId("minecraft", string);
        }
        return new CustomId(string.substring(0, n), string.substring(n + 1));
    }

    public static boolean isPartValid(String string) {
        return IS_VALID_PART.test(string);
    }

    public static boolean isValid(String string) {
        return IS_VALID_ID.test(string);
    }

    private static void validatePartOrThrow(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Must be at least 1 character");
        }
        if (!IS_VALID_PART.test(string)) {
            throw new IllegalArgumentException("Cannot contain any of [:'\"]");
        }
    }

    public static void validatePart(String string) throws InvalidIdException {
        try {
            CustomId.validatePartOrThrow(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidIdException(string, illegalArgumentException);
        }
    }

    public static void validatePart(String string, String string2) throws InvalidIdException {
        try {
            CustomId.validatePartOrThrow(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidIdException(string, string2, illegalArgumentException);
        }
    }

    private static void validateOrThrow(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        if (!IS_VALID_SHAPE.test(string)) {
            throw new IllegalArgumentException("Must either be a single ID (no ':') or a full ID in \"first:second\" format");
        }
        if (!string.contains(":") && !IS_VALID_PART.test(string) || !IS_VALID_ID.test(string)) {
            throw new IllegalArgumentException("Cannot contain single or double quotes ('\")");
        }
    }

    public static void validate(String string, String string2) throws InvalidIdException {
        try {
            CustomId.validateOrThrow(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidIdException(string, string2, illegalArgumentException);
        }
    }

    public static DataResult<CustomId> validate(String string) {
        try {
            CustomId.validateOrThrow(string);
            return DataResult.success((Object)CustomId.parse(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DataResult.error(() -> "Invalid CustomId: " + illegalArgumentException.getMessage());
        }
    }
}

