/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.server.registry;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.registry.CustomPaintingRegistry;
import me.roundaround.custompaintings.resource.HashResult;
import me.roundaround.custompaintings.resource.Image;
import me.roundaround.custompaintings.resource.PackFileUid;
import me.roundaround.custompaintings.resource.PackIcons;
import me.roundaround.custompaintings.resource.PackMetadata;
import me.roundaround.custompaintings.resource.PackResource;
import me.roundaround.custompaintings.resource.ResourceUtil;
import me.roundaround.custompaintings.roundalib.util.PathAccessor;
import me.roundaround.custompaintings.server.ServerInfo;
import me.roundaround.custompaintings.server.network.ImagePacketQueue;
import me.roundaround.custompaintings.server.network.ServerNetworking;
import me.roundaround.custompaintings.util.CustomId;
import me.roundaround.custompaintings.util.InvalidIdException;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_156;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;

public class ServerPaintingRegistry
extends CustomPaintingRegistry {
    private static final String META_FILENAME = "custompaintings.json";
    private static final String PACK_PNG = "pack.png";
    private static final String ICON_PNG = "icon.png";
    private static final String LOG_FAIL_ALL = "Skipping loading packs due to an error";
    private static final String LOG_FAIL_GENERIC = "Skipping potential pack \"%s\" to to an error while loading";
    private static final String LOG_FAIL_IMAGES = "Skipping loading images for pack \"%s\" to to an error while loading";
    private static final String LOG_NO_META = "Skipping potential pack \"{}\" with no {} file";
    private static final String LOG_META_PARSE_FAIL = "Skipping potential pack \"%s\" after failing to parse %s";
    private static final String LOG_ID_VALIDATION_FAIL = "Skipping potential pack \"%s\" due to a validation error in %s";
    private static final String LOG_NO_PAINTINGS = "Skipping potential pack \"{}\" because it contained no paintings";
    private static final String LOG_NO_ICON = "Missing icon.png file for pack \"{}\"";
    private static final String LOG_LEGACY_ICON = "Deprecated/legacy pack.png file found for pack \"{}\". Rename to icon.png";
    private static final String LOG_ICON_READ_FAIL = "Failed to read icon.png file for %s";
    private static final String LOG_MISSING_PAINTING = "Missing custom painting image file for {}";
    private static final String LOG_LARGE_IMAGE = "Image file for {} is too large, skipping";
    private static final String LOG_PAINTING_READ_FAIL = "Failed to read image file for %s";
    private static final int MAX_SIZE = 0x1000000;
    private static ServerPaintingRegistry instance = null;
    private final HashMap<CustomId, Boolean> finishedMigrations = new HashMap();
    private MinecraftServer server;
    private boolean safeMode = false;
    private int loadErrorOrSkipCount = 0;

    private ServerPaintingRegistry() {
        ServerLifecycleEvents.SERVER_STOPPED.register(minecraftServer -> {
            if (minecraftServer == this.server) {
                this.clear();
            }
        });
    }

    public static void init(MinecraftServer minecraftServer) {
        ServerPaintingRegistry serverPaintingRegistry = ServerPaintingRegistry.getInstance();
        if (minecraftServer == null || !minecraftServer.method_3806()) {
            return;
        }
        serverPaintingRegistry.setServer(minecraftServer);
    }

    public static ServerPaintingRegistry getInstance() {
        if (instance == null) {
            instance = new ServerPaintingRegistry();
        }
        return instance;
    }

    @Override
    protected class_5455 getRegistryManager() {
        return this.server == null ? null : this.server.method_30611();
    }

    @Override
    public void clear() {
        super.clear();
        this.finishedMigrations.clear();
        this.server = null;
    }

    public void setServer(MinecraftServer minecraftServer) {
        if (this.server != null && this.server != minecraftServer) {
            this.clear();
        }
        this.server = minecraftServer;
        this.sendSummaryToAll();
    }

    public void firstLoadPaintingPacks(boolean bl) {
        this.safeMode = bl;
        LoadResult loadResult = this.safeMode ? LoadResult.empty(0) : this.loadPaintingPacks();
        this.loadErrorOrSkipCount = loadResult.erroredOrSkipped();
        this.setPacks(loadResult.packs());
        this.setImages(loadResult.images());
    }

    public void reloadPaintingPacks(Consumer<MinecraftServer> consumer) {
        if (this.server == null || !this.server.method_3806()) {
            return;
        }
        this.safeMode = false;
        CompletableFuture.supplyAsync(this::loadPaintingPacks, (Executor)class_156.method_27958()).thenAcceptAsync(loadResult -> {
            this.loadErrorOrSkipCount = loadResult.erroredOrSkipped();
            this.setPacks(loadResult.packs());
            this.setImages(loadResult.images());
            this.sendSummaryToAll();
            consumer.accept(this.server);
        }, (Executor)this.server);
    }

    public void setImages(HashMap<CustomId, Image> hashMap) {
        HashResult hashResult = ResourceUtil.hashImages(hashMap);
        this.images.setAll(hashMap, hashResult.imageHashes());
        this.combinedImageHash = hashResult.combinedImageHash();
    }

    public void sendSummaryToAll() {
        ServerNetworking.sendSummaryPacketToAll(this.server, this.packsList, this.combinedImageHash, this.finishedMigrations, this.safeMode, this.loadErrorOrSkipCount);
    }

    public void sendSummaryToPlayer(class_3222 class_32222) {
        ServerNetworking.sendSummaryPacket(class_32222, this.packsList, this.combinedImageHash, this.finishedMigrations, this.safeMode, this.loadErrorOrSkipCount);
    }

    public void checkPlayerHashes(class_3222 class_32222, Map<CustomId, String> map) {
        HashMap<CustomId, Image> hashMap = new HashMap<CustomId, Image>();
        this.images.forEach((customId, image, string) -> {
            if (string.equals(map.get(customId))) {
                return;
            }
            hashMap.put((CustomId)customId, (Image)image);
        });
        if (hashMap.isEmpty()) {
            CustomPaintingsMod.LOGGER.info("{} has incorrect combined hash, but all correct images. This is likely due to paintings being removed server-side.", (Object)class_32222.method_5477().getString());
            ServerNetworking.sendDownloadSummaryPacket(class_32222, new HashSet<CustomId>(0), 0, 0);
            return;
        }
        CustomPaintingsMod.LOGGER.info("{} needs to download {} image(s). Sending to client.", (Object)class_32222.method_5477().getString(), (Object)hashMap.size());
        ImagePacketQueue.getInstance().add(class_32222, hashMap);
    }

    public void markMigrationFinished(CustomId customId, boolean bl) {
        this.finishedMigrations.put(customId, bl);
    }

    private LoadResult loadPaintingPacks() {
        LoadResult loadResult;
        block9: {
            CustomPaintingsMod.LOGGER.info("Loading painting packs");
            Path path2 = PathAccessor.getInstance().getPerWorldModDir("custompaintings");
            if (path2 == null || Files.notExists(path2, new LinkOption[0])) {
                CustomPaintingsMod.LOGGER.info("Unable to locate packs directory, skipping");
                return LoadResult.empty(0);
            }
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2);
            try {
                Set<String> set = ServerInfo.getInstance().getDisabledPacks();
                HashMap<String, PackData> hashMap = new HashMap<String, PackData>();
                HashMap hashMap2 = new HashMap();
                HashMap<CustomId, Image> hashMap3 = new HashMap<CustomId, Image>();
                var var7_10 = new Object(this){
                    int value = 0;
                };
                directoryStream.forEach(path -> {
                    PackMetadata<PackResource> packMetadata = ServerPaintingRegistry.readPackMetadata(path);
                    if (packMetadata == null) {
                        ++var0.value;
                        return;
                    }
                    PackResource packResource = packMetadata.pack();
                    String string = packResource.id();
                    String string2 = path.getFileName().toString();
                    String string3 = (String)hashMap2.get(string);
                    if (string3 != null) {
                        CustomPaintingsMod.LOGGER.warn("Multiple packs with id \"{}\" detected. Only the first will be kept. Please make sure packs have unique IDs!\nKeeping \"{}\" and discarding \"{}\"", (Object)string, (Object)string3, (Object)string2);
                        ++var0.value;
                        return;
                    }
                    hashMap2.put(string, string2);
                    PackFileUid packFileUid = packMetadata.packFileUid();
                    boolean bl = set.contains(packFileUid.stringValue());
                    hashMap.put(string, packResource.toData(packFileUid, bl));
                    if (packMetadata.icon() != null) {
                        hashMap3.put(PackIcons.customId(string), packMetadata.icon());
                    }
                    if (!bl) {
                        hashMap3.putAll(ServerPaintingRegistry.readPaintingImages(path, packMetadata.pack()));
                    }
                });
                CustomPaintingsMod.LOGGER.info("Loaded {} pack(s) with {} painting(s)", (Object)hashMap.size(), (Object)hashMap.values().stream().mapToInt(packData -> packData.paintings().size()).sum());
                loadResult = new LoadResult(hashMap, hashMap3, var7_10.value);
                if (directoryStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    CustomPaintingsMod.LOGGER.warn(LOG_FAIL_ALL, (Throwable)iOException);
                    return LoadResult.empty(1);
                }
            }
            directoryStream.close();
        }
        return loadResult;
    }

    private static PackMetadata<PackResource> readPackMetadata(Path path) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (basicFileAttributes.isDirectory()) {
                return ServerPaintingRegistry.readPackMetadataFromDirectory(path);
            }
            if (basicFileAttributes.isRegularFile()) {
                return ServerPaintingRegistry.readPackMetadataFromZip(path);
            }
        }
        catch (Exception exception) {
            CustomPaintingsMod.LOGGER.warn(String.format(LOG_FAIL_GENERIC, path.getFileName()), (Throwable)exception);
        }
        return null;
    }

    private static PackMetadata<PackResource> readPackMetadataFromDirectory(Path path) {
        PackResource packResource;
        String string = path.getFileName().toString();
        if (!Files.isRegularFile(path.resolve(META_FILENAME), LinkOption.NOFOLLOW_LINKS)) {
            CustomPaintingsMod.LOGGER.warn(LOG_NO_META, (Object)string, (Object)META_FILENAME);
            return null;
        }
        try {
            packResource = (PackResource)CustomPaintingsMod.GSON.fromJson((Reader)Files.newBufferedReader(path.resolve(META_FILENAME)), PackResource.class);
        }
        catch (Exception exception) {
            CustomPaintingsMod.LOGGER.warn(String.format(LOG_META_PARSE_FAIL, string, META_FILENAME), (Throwable)exception);
            return null;
        }
        try {
            packResource.validateIds();
        }
        catch (InvalidIdException invalidIdException) {
            CustomPaintingsMod.LOGGER.warn(String.format(LOG_ID_VALIDATION_FAIL, string, META_FILENAME), (Throwable)invalidIdException);
            return null;
        }
        if (packResource.paintings().isEmpty()) {
            CustomPaintingsMod.LOGGER.warn(LOG_NO_PAINTINGS, (Object)string);
            return null;
        }
        long l = ResourceUtil.lastModified(path);
        long l2 = ResourceUtil.fileSize(path);
        PackFileUid packFileUid = new PackFileUid(false, string, l, l2);
        Path path2 = ServerPaintingRegistry.getIconPath(path, string);
        Image image = null;
        if (path2 != null) {
            try {
                BufferedImage bufferedImage = ImageIO.read(Files.newInputStream(path2, LinkOption.NOFOLLOW_LINKS));
                if (bufferedImage == null) {
                    throw new IOException("BufferedImage is null");
                }
                image = Image.read(bufferedImage);
            }
            catch (IOException iOException) {
                CustomPaintingsMod.LOGGER.warn(String.format(LOG_ICON_READ_FAIL, packResource.id()), (Throwable)iOException);
            }
        }
        return new PackMetadata<PackResource>(packFileUid, packResource, image);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PackMetadata<PackResource> readPackMetadataFromZip(Path path) {
        String string = path.getFileName().toString();
        if (!string.endsWith(".zip")) {
            CustomPaintingsMod.LOGGER.warn("Found non-zip Custom Paintings file \"{}\", skipping...", (Object)string);
            return null;
        }
        if (path.getFileSystem() != FileSystems.getDefault()) {
            CustomPaintingsMod.LOGGER.warn("Found zip Custom Paintings file \"{}\" outside the system's default file system, skipping...", (Object)string);
            return null;
        }
        try (ZipFile zipFile = new ZipFile(path.toFile());){
            Object object;
            PackResource packResource;
            InputStream inputStream;
            ZipEntry zipEntry;
            String string2 = ResourceUtil.getFolderPrefix(zipFile);
            if (!string2.isBlank()) {
                CustomPaintingsMod.LOGGER.info("Folder-in-zip detected in \"{}\", adjusting paths", (Object)string);
            }
            if ((zipEntry = zipFile.getEntry(string2 + META_FILENAME)) == null) {
                CustomPaintingsMod.LOGGER.warn(LOG_NO_META, (Object)string, (Object)META_FILENAME);
                PackMetadata<PackResource> packMetadata = null;
                return packMetadata;
            }
            try {
                inputStream = zipFile.getInputStream(zipEntry);
                try {
                    packResource = (PackResource)CustomPaintingsMod.GSON.fromJson((Reader)new InputStreamReader(inputStream), PackResource.class);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Exception exception) {
                CustomPaintingsMod.LOGGER.warn(String.format(LOG_META_PARSE_FAIL, string, META_FILENAME), (Throwable)exception);
                PackMetadata<PackResource> packMetadata = null;
                zipFile.close();
                return packMetadata;
            }
            try {
                packResource.validateIds();
            }
            catch (InvalidIdException invalidIdException) {
                CustomPaintingsMod.LOGGER.warn(String.format(LOG_ID_VALIDATION_FAIL, string, META_FILENAME), (Throwable)invalidIdException);
                PackMetadata<PackResource> packMetadata = null;
                zipFile.close();
                return packMetadata;
            }
            if (packResource.paintings().isEmpty()) {
                CustomPaintingsMod.LOGGER.warn(LOG_NO_PAINTINGS, (Object)string);
                inputStream = null;
                return inputStream;
            }
            long l = ResourceUtil.lastModified(path);
            long l2 = ResourceUtil.fileSize(path);
            PackFileUid packFileUid = new PackFileUid(true, string, l, l2);
            Image image = null;
            ZipEntry zipEntry2 = ServerPaintingRegistry.getIconZipEntry(zipFile, string2, string);
            if (zipEntry2 != null) {
                try {
                    object = zipFile.getInputStream(zipEntry2);
                    try {
                        BufferedImage bufferedImage = ImageIO.read((InputStream)object);
                        if (bufferedImage == null) {
                            throw new IOException("BufferedImage is null");
                        }
                        image = Image.read(bufferedImage);
                    }
                    finally {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    CustomPaintingsMod.LOGGER.warn(String.format(LOG_ICON_READ_FAIL, packResource.id()), (Throwable)iOException);
                }
            }
            object = new PackMetadata<PackResource>(packFileUid, packResource, image);
            return object;
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn(String.format(LOG_FAIL_GENERIC, string), (Throwable)iOException);
            return null;
        }
    }

    private static ZipEntry getIconZipEntry(ZipFile zipFile, String string, String string2) {
        ZipEntry zipEntry = ResourceUtil.getImageZipEntry(zipFile, string, ICON_PNG);
        if (zipEntry == null) {
            zipEntry = ResourceUtil.getImageZipEntry(zipFile, string, PACK_PNG);
            if (zipEntry == null) {
                CustomPaintingsMod.LOGGER.warn(LOG_NO_ICON, (Object)string2);
            } else {
                CustomPaintingsMod.LOGGER.warn(LOG_LEGACY_ICON, (Object)string2);
            }
        }
        return zipEntry;
    }

    private static HashMap<CustomId, Image> readPaintingImages(Path path, PackResource packResource) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (basicFileAttributes.isDirectory()) {
                return ServerPaintingRegistry.readPaintingImagesFromDirectory(path, packResource);
            }
            if (basicFileAttributes.isRegularFile()) {
                return ServerPaintingRegistry.readPaintingImagesFromZip(path, packResource);
            }
        }
        catch (Exception exception) {
            CustomPaintingsMod.LOGGER.warn(String.format(LOG_FAIL_IMAGES, path.getFileName()), (Throwable)exception);
        }
        return new HashMap<CustomId, Image>();
    }

    private static HashMap<CustomId, Image> readPaintingImagesFromDirectory(Path path, PackResource packResource) {
        HashMap<CustomId, Image> hashMap = new HashMap<CustomId, Image>();
        if (Files.notExists(path, new LinkOption[0])) {
            return hashMap;
        }
        packResource.paintings().forEach(paintingResource -> {
            CustomId customId = new CustomId(packResource.id(), paintingResource.id());
            Path path2 = path.resolve("images").resolve(paintingResource.id() + ".png");
            if (!Files.exists(path2, new LinkOption[0])) {
                CustomPaintingsMod.LOGGER.warn(LOG_MISSING_PAINTING, (Object)customId);
                return;
            }
            try {
                BufferedImage bufferedImage = ImageIO.read(Files.newInputStream(path2, LinkOption.NOFOLLOW_LINKS));
                if (bufferedImage == null) {
                    throw new IOException("BufferedImage is null");
                }
                long l = (long)bufferedImage.getWidth() * (long)bufferedImage.getHeight();
                if (l > 0x1000000L) {
                    CustomPaintingsMod.LOGGER.warn(LOG_LARGE_IMAGE, (Object)customId);
                    return;
                }
                hashMap.put(customId, Image.read(bufferedImage));
            }
            catch (IOException iOException) {
                CustomPaintingsMod.LOGGER.warn(String.format(LOG_PAINTING_READ_FAIL, customId), (Throwable)iOException);
            }
        });
        return hashMap;
    }

    private static HashMap<CustomId, Image> readPaintingImagesFromZip(Path path, PackResource packResource) {
        HashMap<CustomId, Image> hashMap = new HashMap<CustomId, Image>();
        String string = path.getFileName().toString();
        if (!string.endsWith(".zip")) {
            return hashMap;
        }
        if (path.getFileSystem() != FileSystems.getDefault()) {
            return hashMap;
        }
        try (ZipFile zipFile = new ZipFile(path.toFile());){
            String string2 = ResourceUtil.getFolderPrefix(zipFile);
            packResource.paintings().forEach(paintingResource -> {
                CustomId customId = new CustomId(packResource.id(), paintingResource.id());
                ZipEntry zipEntry = ResourceUtil.getImageZipEntry(zipFile, string2, "images", paintingResource.id() + ".png");
                if (zipEntry == null) {
                    CustomPaintingsMod.LOGGER.warn(LOG_MISSING_PAINTING, (Object)customId);
                    return;
                }
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    if (bufferedImage == null) {
                        throw new IOException("BufferedImage is null");
                    }
                    long l = (long)bufferedImage.getWidth() * (long)bufferedImage.getHeight();
                    if (l > 0x1000000L) {
                        CustomPaintingsMod.LOGGER.warn(LOG_LARGE_IMAGE, (Object)customId);
                        return;
                    }
                    hashMap.put(customId, Image.read(bufferedImage));
                }
                catch (IOException iOException) {
                    CustomPaintingsMod.LOGGER.warn(String.format(LOG_PAINTING_READ_FAIL, customId), (Throwable)iOException);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hashMap;
    }

    private static Path getIconPath(Path path, String string) {
        Path path2 = path.resolve(ICON_PNG);
        if (!Files.exists(path2, new LinkOption[0])) {
            path2 = path.resolve(PACK_PNG);
            if (!Files.exists(path2, new LinkOption[0])) {
                CustomPaintingsMod.LOGGER.warn(LOG_NO_ICON, (Object)string);
                return null;
            }
            CustomPaintingsMod.LOGGER.warn(LOG_LEGACY_ICON, (Object)string);
        }
        return path2;
    }

    private record LoadResult(HashMap<String, PackData> packs, HashMap<CustomId, Image> images, int erroredOrSkipped) {
        public static LoadResult empty(int n) {
            return new LoadResult(new HashMap<String, PackData>(0), new HashMap<CustomId, Image>(0), n);
        }
    }
}

