/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.server.network;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.roundaround.custompaintings.config.CustomPaintingsPerWorldConfig;
import me.roundaround.custompaintings.network.Networking;
import me.roundaround.custompaintings.resource.Image;
import me.roundaround.custompaintings.server.network.ServerNetworking;
import me.roundaround.custompaintings.util.CustomId;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class ImagePacketQueue {
    private static ImagePacketQueue instance = null;
    private final ArrayDeque<Entry> queue = new ArrayDeque();
    private final ArrayDeque<Long> sentTimestamps = new ArrayDeque();
    private final HashMap<UUID, ArrayDeque<Long>> perPlayerSentTimestamps = new HashMap();

    public static ImagePacketQueue getInstance() {
        if (instance == null) {
            instance = new ImagePacketQueue();
        }
        return instance;
    }

    private ImagePacketQueue() {
    }

    public void add(class_3222 class_32222, HashMap<CustomId, Image> hashMap) {
        ArrayDeque arrayDeque = new ArrayDeque();
        Summary summary = hashMap.entrySet().stream().map(entry -> this.add(arrayDeque, class_32222, (CustomId)entry.getKey(), (Image)entry.getValue())).reduce(Summary.empty(), Summary::merge);
        ServerNetworking.sendDownloadSummaryPacket(class_32222, hashMap.keySet(), summary.imageCount, summary.byteCount);
        while (!arrayDeque.isEmpty()) {
            Entry entry2 = (Entry)arrayDeque.poll();
            if (ImagePacketQueue.isThrottled()) {
                this.queue.push(entry2);
                continue;
            }
            ServerPlayNetworking.send((class_3222)entry2.player, (class_8710)entry2.payload);
        }
    }

    private Summary add(ArrayDeque<Entry> arrayDeque, class_3222 class_32222, CustomId customId, Image image) {
        int n = (Integer)CustomPaintingsPerWorldConfig.getInstance().maxImagePacketSize.getValue() * 1024;
        if (!ImagePacketQueue.isThrottled() || n == 0 || image.getSize() <= n) {
            arrayDeque.add(new Entry(class_32222, new Networking.ImageS2C(customId, image)));
            return Summary.singlePacketImage(image);
        }
        byte[] byArray = image.getBytes();
        int n2 = byArray.length;
        ArrayDeque<Networking.ImageChunkS2C> arrayDeque2 = new ArrayDeque<Networking.ImageChunkS2C>();
        Summary summary = Summary.multiPacketImage();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = Math.min(n3 + n, n2);
            byte[] byArray2 = new byte[n5 - n3];
            System.arraycopy(byArray, n3, byArray2, 0, n5 - n3);
            arrayDeque2.add(new Networking.ImageChunkS2C(customId, n4, byArray2));
            summary.add(byArray2.length);
            n3 += n;
            ++n4;
        }
        arrayDeque.add(new Entry(class_32222, new Networking.ImageHeaderS2C(customId, image.width(), image.height(), arrayDeque2.size())));
        while (!arrayDeque2.isEmpty()) {
            arrayDeque.add(new Entry(class_32222, (class_8710)arrayDeque2.pop()));
        }
        return summary;
    }

    public void tick() {
        ArrayDeque<Long> arrayDeque;
        if (this.queue.isEmpty()) {
            return;
        }
        if (!ImagePacketQueue.isThrottled()) {
            while (!this.queue.isEmpty()) {
                Entry entry = this.queue.poll();
                ServerPlayNetworking.send((class_3222)entry.player, (class_8710)entry.payload);
            }
        }
        long l = class_156.method_658();
        while (!this.sentTimestamps.isEmpty() && l - this.sentTimestamps.peekFirst() > 1000L) {
            this.sentTimestamps.pollFirst();
        }
        for (Map.Entry<UUID, ArrayDeque<Long>> entry : this.perPlayerSentTimestamps.entrySet()) {
            arrayDeque = entry.getValue();
            while (!arrayDeque.isEmpty() && l - arrayDeque.peekFirst() > 1000L) {
                arrayDeque.pollFirst();
            }
        }
        int n = (Integer)CustomPaintingsPerWorldConfig.getInstance().maxImagePacketsPerSecond.getValue();
        int n2 = (Integer)CustomPaintingsPerWorldConfig.getInstance().maxPerClientImagePacketsPerSecond.getValue();
        arrayDeque = new ArrayDeque();
        while (!this.queue.isEmpty() && this.sentTimestamps.size() <= n) {
            Entry entry = this.queue.poll();
            ArrayDeque arrayDeque2 = this.perPlayerSentTimestamps.computeIfAbsent(entry.player().method_5667(), uUID -> new ArrayDeque());
            if (arrayDeque2.size() >= n2) {
                arrayDeque.push((Long)((Object)entry));
                continue;
            }
            arrayDeque2.push(l);
            this.sentTimestamps.push(l);
            ServerPlayNetworking.send((class_3222)entry.player, (class_8710)entry.payload);
        }
        this.queue.addAll(arrayDeque);
    }

    private static boolean isThrottled() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER) {
            return false;
        }
        return (Boolean)CustomPaintingsPerWorldConfig.getInstance().throttleImageDownloads.getValue();
    }

    public static class Summary {
        public int imageCount;
        public int byteCount;

        private Summary(int n, int n2) {
            this.imageCount = n;
            this.byteCount = n2;
        }

        public static Summary empty() {
            return new Summary(0, 0);
        }

        public static Summary singlePacketImage(Image image) {
            return new Summary(1, image.getSize());
        }

        public static Summary multiPacketImage() {
            return new Summary(1, 0);
        }

        public void add(int n) {
            this.byteCount += n;
        }

        public static Summary merge(Summary summary, Summary summary2) {
            summary.imageCount += summary2.imageCount;
            summary.byteCount += summary2.byteCount;
            return summary;
        }
    }

    private record Entry(class_3222 player, class_8710 payload) {
    }
}

