/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.server;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.roundaround.custompaintings.CustomPaintingsMod;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_32;
import net.minecraft.class_4844;

public class ServerInfo {
    private static ServerInfo instance = null;
    private final Path savePath;
    private final UUID serverId;
    private final HashSet<String> disabledPacks = new HashSet();
    private boolean dirty;

    private ServerInfo(Path path) {
        this(path, UUID.randomUUID(), Set.of(), true);
    }

    private ServerInfo(Path path, UUID uUID, Set<String> set) {
        this(path, uUID, set, false);
    }

    private ServerInfo(Path path, UUID uUID, Set<String> set, boolean bl3) {
        this.savePath = path;
        this.serverId = uUID;
        this.disabledPacks.addAll(set);
        this.dirty = bl3;
        ServerLifecycleEvents.BEFORE_SAVE.register((minecraftServer, bl, bl2) -> {
            try {
                this.save();
            }
            catch (Exception exception) {
                CustomPaintingsMod.LOGGER.warn((Object)exception);
                CustomPaintingsMod.LOGGER.warn("Failed to save Custom Paintings mod server info:", (Throwable)exception);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(minecraftServer -> this.clear());
    }

    public static void init(class_32.class_5143 class_51432) {
        Path path = class_51432.method_27424(class_1937.field_25179).resolve("data").resolve("custompaintings_server.dat");
        try {
            ServerInfo.load(path).ifSuccess(storedData -> {
                instance = new ServerInfo(path, storedData.serverId(), storedData.disabledPacks());
            }).ifError(error -> {
                CustomPaintingsMod.LOGGER.warn("Failed to load Custom Paintings mod server info; setting defaults: {}", error);
                instance = new ServerInfo(path);
            });
        }
        catch (Exception exception) {
            CustomPaintingsMod.LOGGER.warn("Failed to load Custom Paintings mod server info; setting defaults:", (Throwable)exception);
            instance = new ServerInfo(path);
        }
    }

    public static ServerInfo getInstance() {
        assert (instance != null);
        return instance;
    }

    public UUID getServerId() {
        return this.serverId;
    }

    public Set<String> getDisabledPacks() {
        return Set.copyOf(this.disabledPacks);
    }

    public boolean markPackDisabled(String string) {
        if (this.disabledPacks.add(string)) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public boolean markPackEnabled(String string) {
        if (this.disabledPacks.remove(string)) {
            this.markDirty();
            return true;
        }
        return false;
    }

    private void markDirty() {
        this.dirty = true;
    }

    private void clear() {
        instance = null;
    }

    private void save() throws IOException {
        if (!this.dirty) {
            return;
        }
        class_2487 class_24872 = (class_2487)StoredData.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)new StoredData(this.serverId, this.disabledPacks)).getOrThrow();
        class_2507.method_30614((class_2487)class_24872, (Path)this.savePath);
        this.dirty = false;
    }

    private static DataResult<StoredData> load(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            return DataResult.error(() -> "No file to load");
        }
        return StoredData.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898()));
    }

    private record StoredData(UUID serverId, Set<String> disabledPacks) {
        public static final Codec<StoredData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("ServerId").forGetter(StoredData::serverId), (App)Codec.list((Codec)Codec.STRING).xmap(Set::copyOf, List::copyOf).fieldOf("DisabledPacks").forGetter(StoredData::disabledPacks)).apply((Applicative)instance, StoredData::new));
    }
}

