/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.util;

import java.nio.file.Path;
import me.roundaround.custompaintings.roundalib.event.ResourceManagerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_32;
import net.minecraft.server.MinecraftServer;

public class PathAccessor {
    private static PathAccessor instance = null;
    private Path gameDirectory = null;
    private Path configDirectory = null;
    private Path worldDirectory = null;

    private PathAccessor() {
        ResourceManagerEvents.CREATING.register(this::beforeResourceManagerCreated);
        ServerLifecycleEvents.SERVER_STOPPED.register(this::serverStopped);
    }

    public static void init() {
        PathAccessor.getInstance();
    }

    public static PathAccessor getInstance() {
        if (instance == null) {
            instance = new PathAccessor();
        }
        return instance;
    }

    public Path getGameDir() {
        if (this.gameDirectory == null) {
            this.gameDirectory = FabricLoader.getInstance().getGameDir();
        }
        return this.gameDirectory;
    }

    public Path getModDir(String string) {
        return this.getGameDir().resolve(string);
    }

    public Path getConfigDir() {
        if (this.configDirectory == null) {
            this.configDirectory = FabricLoader.getInstance().getConfigDir();
        }
        return this.configDirectory;
    }

    public Path getModConfigFile(String string, ConfigFormat configFormat) {
        return this.getModConfigFile(string, configFormat, false);
    }

    public Path getModConfigFile(String string, ConfigFormat configFormat, boolean bl) {
        Path path = this.getConfigDir();
        if (bl) {
            path = path.resolve(string);
        }
        return this.getConfigFile(path, string, configFormat);
    }

    public Path getModConfigDir(String string) {
        Path path = this.getConfigDir();
        if (path == null) {
            return null;
        }
        return path.resolve(string);
    }

    public boolean isWorldDirAccessible() {
        return this.worldDirectory != null;
    }

    public Path getWorldDir() {
        return this.worldDirectory;
    }

    public Path getPerWorldModDir(String string) {
        Path path = this.getWorldDir();
        if (path == null) {
            return null;
        }
        return path.resolve(string);
    }

    public Path getPerWorldConfigDir() {
        Path path = this.getWorldDir();
        if (path == null) {
            return null;
        }
        return path.resolve("config");
    }

    public Path getPerWorldModConfigFile(String string, ConfigFormat configFormat) {
        return this.getPerWorldModConfigFile(string, configFormat, false);
    }

    public Path getPerWorldModConfigFile(String string, ConfigFormat configFormat, boolean bl) {
        Path path = this.getPerWorldConfigDir();
        if (path == null) {
            return null;
        }
        if (bl) {
            path = path.resolve(string);
        }
        return this.getConfigFile(path, string, configFormat);
    }

    public Path getPerWorldModConfigDir(String string) {
        Path path = this.getPerWorldConfigDir();
        if (path == null) {
            return null;
        }
        return path.resolve(string);
    }

    public Path getConfigFile(Path path, String string, ConfigFormat configFormat) {
        if (path == null) {
            return null;
        }
        return path.resolve(string + configFormat.getFileExtension());
    }

    private void beforeResourceManagerCreated(class_32.class_5143 class_51432) {
        this.worldDirectory = class_51432.method_54543().comp_732();
    }

    private void serverStopped(MinecraftServer minecraftServer) {
        this.worldDirectory = null;
    }

    public static enum ConfigFormat {
        TOML,
        JSON,
        YAML,
        PROPERTIES,
        INI;


        public String getFileExtension() {
            return "." + this.name().toLowerCase();
        }
    }
}

