/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.nightconfig.core.serde;

import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Supplier;
import me.roundaround.custompaintings.roundalib.nightconfig.core.Config;
import me.roundaround.custompaintings.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.AnnotationProcessor;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.ObjectSerializerBuilder;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.SerdeException;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.SerializerContext;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.Util;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.ValueSerializer;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.ValueSerializerProvider;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.annotations.SerdeDefault;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.annotations.SerdePhase;

public final class ObjectSerializer {
    private final IdentityHashMap<Class<?>, ValueSerializer<?, ?>> classBasedSerializers;
    private final List<ValueSerializerProvider<?, ?>> generalProviders;
    private final ValueSerializerProvider<?, ?> defaultProvider;
    final boolean applyTransientModifier;

    public static ObjectSerializerBuilder builder() {
        return new ObjectSerializerBuilder(true);
    }

    public static ObjectSerializerBuilder blankBuilder() {
        return new ObjectSerializerBuilder(false);
    }

    public static ObjectSerializer standard() {
        return ObjectSerializer.builder().build();
    }

    ObjectSerializer(ObjectSerializerBuilder objectSerializerBuilder) {
        this.classBasedSerializers = objectSerializerBuilder.classBasedSerializers;
        this.generalProviders = objectSerializerBuilder.generalProviders;
        this.defaultProvider = objectSerializerBuilder.defaultProvider;
        this.applyTransientModifier = objectSerializerBuilder.applyTransientModifier;
        assert (this.classBasedSerializers != null && this.generalProviders != null && this.defaultProvider != null);
    }

    public Object serialize(Object object, Supplier<? extends Config> supplier) {
        SerializerContext serializerContext = new SerializerContext(this, () -> ((Config)supplier.get()).configFormat(), supplier);
        return serializerContext.serializeValue(object);
    }

    public <C extends Config> C serializeFields(Object object, Supplier<C> supplier) {
        Config config = (Config)supplier.get();
        this.serializeFields(object, config);
        return (C)config;
    }

    public void serializeFields(Object object, Config config) {
        SerializerContext serializerContext = new SerializerContext(this, () -> config.configFormat(), () -> config.createSubConfig());
        serializerContext.serializeFields(object, config);
    }

    <T, R> ValueSerializer<T, R> findValueSerializer(Object object, SerializerContext serializerContext) {
        Class<?> clazz = object == null ? null : object.getClass();
        ValueSerializer<?, ?> valueSerializer = null;
        for (ValueSerializerProvider<?, ?> valueSerializerProvider : this.generalProviders) {
            valueSerializer = valueSerializerProvider.provide(clazz, serializerContext);
            if (valueSerializer == null) continue;
            return valueSerializer;
        }
        valueSerializer = this.classBasedSerializers.get(clazz);
        if (valueSerializer != null) {
            return valueSerializer;
        }
        valueSerializer = this.defaultProvider.provide(clazz, serializerContext);
        if (valueSerializer != null) {
            return valueSerializer;
        }
        throw ObjectSerializer.noSerializerFound(object, clazz, serializerContext);
    }

    Supplier<?> findDefaultValueSupplier(Object object, Field field, Object object2) {
        EnumMap<SerdeDefault.WhenValue, SerdeDefault> enumMap = AnnotationProcessor.getConfigDefaultAnnotations(field).get((Object)SerdePhase.SERIALIZING);
        if (enumMap == null) {
            return null;
        }
        SerdeDefault serdeDefault = null;
        if (object == null) {
            serdeDefault = enumMap.get((Object)SerdeDefault.WhenValue.IS_NULL);
        } else {
            SerdeDefault serdeDefault2 = enumMap.get((Object)SerdeDefault.WhenValue.IS_EMPTY);
            if (serdeDefault2 != null && Util.isEmpty(object)) {
                serdeDefault = serdeDefault2;
            }
        }
        if (serdeDefault == null) {
            return null;
        }
        return AnnotationProcessor.resolveConfigDefaultProvider(serdeDefault, object2);
    }

    static SerdeException noSerializerFound(Object object, Class<?> clazz, SerializerContext serializerContext) {
        ConfigFormat<?> configFormat = serializerContext.configFormat();
        String string = configFormat == null ? "The current SerializerContext has no ConfigFormat. Is there a bug in the implementation of the chosen Config type?" : (configFormat.supportsType(clazz) ? "The value's type is supported by the ConfigFormat of the current SerializerContext." : "The value's type is NOT supported by the ConfigFormat of the current SerializerContext.");
        String string2 = clazz == null ? "" : " of type " + String.valueOf(clazz);
        return new SerdeException("No suitable serializer found for value" + string2 + ": " + String.valueOf(object) + ". " + string);
    }
}

