/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.nightconfig.core.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.roundaround.custompaintings.roundalib.nightconfig.core.Config;
import me.roundaround.custompaintings.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.custompaintings.roundalib.nightconfig.core.file.FileNotFoundAction;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.ParsingMode;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.WritingException;
import me.roundaround.custompaintings.roundalib.nightconfig.core.utils.FastStringReader;

public interface ConfigParser<C extends Config> {
    public ConfigFormat<C> getFormat();

    public C parse(Reader var1);

    public void parse(Reader var1, Config var2, ParsingMode var3);

    default public C parse(String string) {
        return this.parse(new FastStringReader(string));
    }

    default public void parse(String string, Config config, ParsingMode parsingMode) {
        this.parse(new StringReader(string), config, parsingMode);
    }

    default public C parse(InputStream inputStream) {
        return this.parse(inputStream, StandardCharsets.UTF_8);
    }

    default public C parse(InputStream inputStream, Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        return this.parse(new BufferedReader(new InputStreamReader(inputStream, charsetDecoder)));
    }

    default public void parse(InputStream inputStream, Config config, ParsingMode parsingMode) {
        this.parse(inputStream, config, parsingMode, StandardCharsets.UTF_8);
    }

    default public void parse(InputStream inputStream, Config config, ParsingMode parsingMode, Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charsetDecoder));
        this.parse(bufferedReader, config, parsingMode);
    }

    default public C parse(File file, FileNotFoundAction fileNotFoundAction) {
        return this.parse(file, fileNotFoundAction, StandardCharsets.UTF_8);
    }

    default public C parse(File file, FileNotFoundAction fileNotFoundAction, Charset charset) {
        return this.parse(file.toPath(), fileNotFoundAction, charset);
    }

    default public void parse(File file, Config config, ParsingMode parsingMode, FileNotFoundAction fileNotFoundAction) {
        this.parse(file, config, parsingMode, fileNotFoundAction, StandardCharsets.UTF_8);
    }

    default public void parse(File file, Config config, ParsingMode parsingMode, FileNotFoundAction fileNotFoundAction, Charset charset) {
        this.parse(file.toPath(), config, parsingMode, fileNotFoundAction, charset);
    }

    default public C parse(Path path, FileNotFoundAction fileNotFoundAction) {
        return this.parse(path, fileNotFoundAction, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public C parse(Path path, FileNotFoundAction fileNotFoundAction, Charset charset) {
        try {
            if (Files.notExists(path, new LinkOption[0]) && !fileNotFoundAction.run(path, this.getFormat())) {
                return this.getFormat().createConfig();
            }
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                C c = this.parse(inputStream, charset);
                return c;
            }
        }
        catch (IOException iOException) {
            throw new WritingException("An I/O error occured", iOException);
        }
    }

    default public void parse(Path path, Config config, ParsingMode parsingMode, FileNotFoundAction fileNotFoundAction) {
        this.parse(path, config, parsingMode, fileNotFoundAction, StandardCharsets.UTF_8);
    }

    default public void parse(Path path, Config config, ParsingMode parsingMode, FileNotFoundAction fileNotFoundAction, Charset charset) {
        try {
            if (Files.notExists(path, new LinkOption[0]) && !fileNotFoundAction.run(path, this.getFormat())) {
                return;
            }
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                this.parse(inputStream, config, parsingMode, charset);
            }
        }
        catch (IOException iOException) {
            throw new WritingException("An I/O error occured", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public C parse(URL uRL) {
        URLConnection uRLConnection;
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new WritingException("Unable to connect to the URL", iOException);
        }
        String string = uRLConnection.getContentEncoding();
        Charset charset = string == null ? StandardCharsets.UTF_8 : Charset.forName(string);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), charset));){
            C c = this.parse(bufferedReader);
            return c;
        }
        catch (IOException iOException) {
            throw new WritingException("An I/O error occured", iOException);
        }
    }

    default public void parse(URL uRL, Config config, ParsingMode parsingMode) {
        URLConnection uRLConnection;
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new WritingException("Unable to connect to the URL", iOException);
        }
        String string = uRLConnection.getContentEncoding();
        Charset charset = string == null ? StandardCharsets.UTF_8 : Charset.forName(string);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), charset));){
            this.parse(bufferedReader, config, parsingMode);
        }
        catch (IOException iOException) {
            throw new WritingException("An I/O error occured", iOException);
        }
    }
}

