/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.nightconfig.core.io;

import me.roundaround.custompaintings.roundalib.nightconfig.core.io.CharacterInput;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.CharsWrapper;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.ParsingException;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.Utils;
import me.roundaround.custompaintings.roundalib.nightconfig.core.utils.IntDeque;

public abstract class AbstractInput
implements CharacterInput {
    protected final IntDeque deque = new IntDeque();

    protected abstract int directRead();

    protected abstract char directReadChar();

    @Override
    public int read() {
        if (!this.deque.isEmpty()) {
            return this.deque.removeFirst();
        }
        return this.directRead();
    }

    @Override
    public char readChar() {
        if (!this.deque.isEmpty()) {
            int n = this.deque.removeFirst();
            if (n == -1) {
                throw ParsingException.notEnoughData();
            }
            return (char)n;
        }
        return this.directReadChar();
    }

    @Override
    public int peek() {
        if (this.deque.isEmpty()) {
            int n = this.directRead();
            this.deque.addLast(n);
            return n;
        }
        return this.deque.getFirst();
    }

    @Override
    public int peek(int n) {
        int n2 = n - this.deque.size();
        if (n2 >= 0) {
            for (int i = 0; i <= n2; ++i) {
                int n3 = this.directRead();
                this.deque.addLast(n3);
                if (n3 != -1) continue;
                return -1;
            }
        }
        return this.deque.get(n);
    }

    @Override
    public char peekChar() {
        int n = this.peek();
        if (n == -1) {
            throw ParsingException.notEnoughData();
        }
        return (char)n;
    }

    @Override
    public char peekChar(int n) {
        int n2 = this.peek(n);
        if (n2 == -1) {
            throw ParsingException.notEnoughData();
        }
        return (char)n2;
    }

    @Override
    public void skipPeeks() {
        this.deque.clear();
    }

    @Override
    public void pushBack(char c) {
        this.deque.addFirst(c);
    }

    @Override
    public CharsWrapper readUntil(char[] cArray) {
        CharsWrapper.Builder builder = new CharsWrapper.Builder(10);
        int n = this.read();
        while (n != -1 && !Utils.arrayContains(cArray, (char)n)) {
            builder.append((char)n);
            n = this.read();
        }
        this.deque.addFirst(n);
        return builder.build();
    }

    @Override
    public CharsWrapper readCharsUntil(char[] cArray) {
        CharsWrapper.Builder builder = new CharsWrapper.Builder(10);
        char c = this.readChar();
        while (!Utils.arrayContains(cArray, c)) {
            builder.append(c);
            c = this.readChar();
        }
        this.deque.addFirst(c);
        return builder.build();
    }

    protected CharsWrapper consumeDeque(char[] cArray, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            int n2 = this.deque.removeFirst();
            if (n2 == -1) {
                if (bl) {
                    throw ParsingException.notEnoughData();
                }
                return new CharsWrapper(cArray, 0, i);
            }
            cArray[i] = (char)n2;
        }
        return null;
    }
}

