/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.nightconfig.core.file;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.Function;
import me.roundaround.custompaintings.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.custompaintings.roundalib.nightconfig.core.Config;
import me.roundaround.custompaintings.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.custompaintings.roundalib.nightconfig.core.file.CheckedCommentedFileConfig;
import me.roundaround.custompaintings.roundalib.nightconfig.core.file.CommentedFileConfigBuilder;
import me.roundaround.custompaintings.roundalib.nightconfig.core.file.FileConfig;
import me.roundaround.custompaintings.roundalib.nightconfig.core.file.FormatDetector;
import me.roundaround.custompaintings.roundalib.nightconfig.core.file.NoFormatFoundException;

public interface CommentedFileConfig
extends CommentedConfig,
FileConfig {
    @Override
    default public CommentedFileConfig checked() {
        return new CheckedCommentedFileConfig(this);
    }

    public <R> R bulkCommentedUpdate(Function<? super CommentedConfig, R> var1);

    default public void bulkCommentedUpdate(Consumer<? super CommentedConfig> consumer) {
        this.bulkCommentedUpdate((? super CommentedConfig commentedConfig) -> {
            consumer.accept((CommentedConfig)commentedConfig);
            return null;
        });
    }

    @Override
    default public <R> R bulkUpdate(Function<? super Config, R> function) {
        return this.bulkCommentedUpdate(function);
    }

    public static CommentedFileConfig of(File file) {
        return CommentedFileConfig.of(file.toPath());
    }

    public static CommentedFileConfig of(File file, ConfigFormat<? extends CommentedConfig> configFormat) {
        return CommentedFileConfig.of(file.toPath(), configFormat);
    }

    public static CommentedFileConfig of(Path path) {
        ConfigFormat<?> configFormat = FormatDetector.detect(path);
        if (configFormat == null || !configFormat.supportsComments()) {
            throw new NoFormatFoundException("No suitable format for " + String.valueOf(path.getFileName()));
        }
        return CommentedFileConfig.of(path, configFormat);
    }

    public static CommentedFileConfig of(Path path, ConfigFormat<? extends CommentedConfig> configFormat) {
        return (CommentedFileConfig)CommentedFileConfig.builder(path, configFormat).build();
    }

    public static CommentedFileConfig of(String string) {
        return CommentedFileConfig.of(Paths.get(string, new String[0]));
    }

    public static CommentedFileConfig of(String string, ConfigFormat<? extends CommentedConfig> configFormat) {
        return CommentedFileConfig.of(Paths.get(string, new String[0]), configFormat);
    }

    @Deprecated
    public static CommentedFileConfig ofConcurrent(File file) {
        return CommentedFileConfig.ofConcurrent(file.toPath());
    }

    @Deprecated
    public static CommentedFileConfig ofConcurrent(File file, ConfigFormat<? extends CommentedConfig> configFormat) {
        return CommentedFileConfig.ofConcurrent(file.toPath(), configFormat);
    }

    @Deprecated
    public static CommentedFileConfig ofConcurrent(Path path) {
        return (CommentedFileConfig)CommentedFileConfig.builder(path).concurrent().build();
    }

    @Deprecated
    public static CommentedFileConfig ofConcurrent(Path path, ConfigFormat<? extends CommentedConfig> configFormat) {
        return (CommentedFileConfig)CommentedFileConfig.builder(path, configFormat).concurrent().build();
    }

    @Deprecated
    public static CommentedFileConfig ofConcurrent(String string, ConfigFormat<? extends CommentedConfig> configFormat) {
        return CommentedFileConfig.ofConcurrent(Paths.get(string, new String[0]), configFormat);
    }

    @Deprecated
    public static CommentedFileConfig ofConcurrent(String string) {
        return CommentedFileConfig.ofConcurrent(Paths.get(string, new String[0]));
    }

    public static CommentedFileConfigBuilder builder(File file, ConfigFormat<? extends CommentedConfig> configFormat) {
        return CommentedFileConfig.builder(file.toPath(), configFormat);
    }

    public static CommentedFileConfigBuilder builder(File file) {
        return CommentedFileConfig.builder(file.toPath());
    }

    public static CommentedFileConfigBuilder builder(Path path, ConfigFormat<? extends CommentedConfig> configFormat) {
        return new CommentedFileConfigBuilder(path, configFormat);
    }

    public static CommentedFileConfigBuilder builder(Path path) {
        ConfigFormat<?> configFormat = FormatDetector.detect(path);
        if (configFormat == null) {
            throw new NoFormatFoundException("No suitable format for " + String.valueOf(path.getFileName()));
        }
        if (!configFormat.supportsComments()) {
            throw new NoFormatFoundException("The available format doesn't support comments for " + String.valueOf(path.getFileName()));
        }
        return CommentedFileConfig.builder(path, configFormat);
    }

    public static CommentedFileConfigBuilder builder(String string) {
        return CommentedFileConfig.builder(Paths.get(string, new String[0]));
    }

    public static CommentedFileConfigBuilder builder(String string, ConfigFormat<? extends CommentedConfig> configFormat) {
        return CommentedFileConfig.builder(Paths.get(string, new String[0]), configFormat);
    }
}

