/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.nightconfig.core.file;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.roundaround.custompaintings.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.custompaintings.roundalib.nightconfig.core.Config;
import me.roundaround.custompaintings.roundalib.nightconfig.core.UnmodifiableCommentedConfig;
import me.roundaround.custompaintings.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.custompaintings.roundalib.nightconfig.core.file.CommentedFileConfig;
import me.roundaround.custompaintings.roundalib.nightconfig.core.utils.CommentedConfigWrapper;
import me.roundaround.custompaintings.roundalib.nightconfig.core.utils.ObservedMap;

final class AutosaveCommentedFileConfig
extends CommentedConfigWrapper<CommentedFileConfig>
implements CommentedFileConfig {
    private final Runnable autoSaveListener;

    AutosaveCommentedFileConfig(CommentedFileConfig commentedFileConfig, Runnable runnable) {
        super(commentedFileConfig);
        this.autoSaveListener = runnable;
    }

    private void autoSave() {
        this.save();
        this.autoSaveListener.run();
    }

    @Override
    public void save() {
        ((CommentedFileConfig)this.config).save();
    }

    @Override
    public <T> T set(List<String> list, Object object) {
        Object t = super.set(list, object);
        this.autoSave();
        return t;
    }

    @Override
    public boolean add(List<String> list, Object object) {
        boolean bl = super.add(list, object);
        this.autoSave();
        return bl;
    }

    @Override
    public <T> T remove(List<String> list) {
        Object t = super.remove(list);
        this.autoSave();
        return t;
    }

    @Override
    public String setComment(List<String> list, String string) {
        String string2 = super.setComment(list, string);
        this.autoSave();
        return string2;
    }

    @Override
    public String removeComment(List<String> list) {
        String string = super.removeComment(list);
        this.autoSave();
        return string;
    }

    @Override
    public void removeAll(UnmodifiableConfig unmodifiableConfig) {
        super.removeAll(unmodifiableConfig);
        this.autoSave();
    }

    @Override
    public void putAll(UnmodifiableConfig unmodifiableConfig) {
        super.putAll(unmodifiableConfig);
        this.autoSave();
    }

    @Override
    public void clear() {
        super.clear();
        this.autoSave();
    }

    @Override
    public void clearComments() {
        super.clearComments();
        this.autoSave();
    }

    @Override
    public void putAllComments(UnmodifiableCommentedConfig unmodifiableCommentedConfig) {
        super.putAllComments(unmodifiableCommentedConfig);
        this.autoSave();
    }

    @Override
    public void putAllComments(Map<String, UnmodifiableCommentedConfig.CommentNode> map) {
        super.putAllComments(map);
        this.autoSave();
    }

    @Override
    public Map<String, Object> valueMap() {
        return new ObservedMap<String, Object>(super.valueMap(), this::autoSave);
    }

    @Override
    public Map<String, String> commentMap() {
        return new ObservedMap<String, String>(super.commentMap(), this::autoSave);
    }

    @Override
    public File getFile() {
        return ((CommentedFileConfig)this.config).getFile();
    }

    @Override
    public Path getNioPath() {
        return ((CommentedFileConfig)this.config).getNioPath();
    }

    @Override
    public void load() {
        ((CommentedFileConfig)this.config).load();
    }

    @Override
    public void close() {
        ((CommentedFileConfig)this.config).close();
    }

    @Override
    public <R> R bulkCommentedUpdate(Function<? super CommentedConfig, R> function) {
        R r = ((CommentedFileConfig)this.config).bulkCommentedUpdate(function);
        this.autoSave();
        return r;
    }

    @Override
    public <R> R bulkUpdate(Function<? super Config, R> function) {
        R r = CommentedFileConfig.super.bulkUpdate(function);
        this.autoSave();
        return r;
    }
}

