/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.nightconfig.core;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Supplier;
import me.roundaround.custompaintings.roundalib.nightconfig.core.Config;
import me.roundaround.custompaintings.roundalib.nightconfig.core.InMemoryFormat;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.ConfigParser;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.ConfigWriter;
import me.roundaround.custompaintings.roundalib.nightconfig.core.utils.WriterSupplier;

public interface ConfigFormat<C extends Config> {
    public ConfigWriter createWriter();

    public ConfigParser<C> createParser();

    default public C createConfig() {
        return this.createConfig(Config.getDefaultMapCreator(false));
    }

    default public C createConcurrentConfig() {
        return this.createConfig(Config.getDefaultMapCreator(true));
    }

    public C createConfig(Supplier<Map<String, Object>> var1);

    public boolean supportsComments();

    default public boolean supportsType(Class<?> clazz) {
        return InMemoryFormat.DEFAULT_PREDICATE.test(clazz);
    }

    default public boolean isInMemory() {
        return false;
    }

    default public void initEmptyFile(Path path) throws IOException {
        this.initEmptyFile(() -> Files.newBufferedWriter(path, new OpenOption[0]));
    }

    default public void initEmptyFile(File file) throws IOException {
        this.initEmptyFile(file.toPath());
    }

    default public void initEmptyFile(WriterSupplier writerSupplier) throws IOException {
        this.initEmptyFile(writerSupplier.get());
    }

    default public void initEmptyFile(Writer writer) throws IOException {
    }
}

