/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.nightconfig.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import me.roundaround.custompaintings.roundalib.nightconfig.core.Config;
import me.roundaround.custompaintings.roundalib.nightconfig.core.IncompatibleIntermediaryLevelException;
import me.roundaround.custompaintings.roundalib.nightconfig.core.NullObject;
import me.roundaround.custompaintings.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.custompaintings.roundalib.nightconfig.core.utils.TransformingSet;

public abstract class AbstractConfig
implements Config,
Cloneable {
    protected final Supplier<Map<String, Object>> mapCreator;
    protected final Map<String, Object> map;

    public AbstractConfig(boolean bl) {
        this(AbstractConfig.getDefaultMapCreator(bl));
    }

    public AbstractConfig(Supplier<Map<String, Object>> supplier) {
        this.mapCreator = supplier;
        this.map = supplier.get();
    }

    public AbstractConfig(Map<String, Object> map) {
        this.map = map;
        this.mapCreator = AbstractConfig.getDefaultMapCreator(map instanceof ConcurrentMap);
    }

    public AbstractConfig(UnmodifiableConfig unmodifiableConfig, boolean bl) {
        this(unmodifiableConfig, AbstractConfig.getDefaultMapCreator(bl));
    }

    public AbstractConfig(UnmodifiableConfig unmodifiableConfig, Supplier<Map<String, Object>> supplier) {
        this.map = supplier.get();
        this.map.putAll(unmodifiableConfig.valueMap());
        this.mapCreator = supplier;
    }

    protected static <T> Supplier<Map<String, T>> getDefaultMapCreator(boolean bl) {
        return Config.getDefaultMapCreator(bl);
    }

    protected static <T> Supplier<Map<String, T>> getWildcardMapCreator(Supplier<Map<String, Object>> supplier) {
        return () -> {
            Map map = (Map)supplier.get();
            map.clear();
            return map;
        };
    }

    @Override
    public <T> T getRaw(List<String> list) {
        int n = list.size() - 1;
        Map<String, Object> map = this.getMap(list.subList(0, n));
        if (map == null) {
            return null;
        }
        String string = list.get(n);
        return (T)map.get(string);
    }

    @Override
    public <T> T set(List<String> list, Object object) {
        int n = list.size() - 1;
        Map<String, Object> map = this.getOrCreateMap(list.subList(0, n));
        String string = list.get(n);
        Object object2 = object == null ? NullObject.NULL_OBJECT : object;
        return (T)map.put(string, object2);
    }

    @Override
    public boolean add(List<String> list, Object object) {
        int n = list.size() - 1;
        Map<String, Object> map = this.getOrCreateMap(list.subList(0, n));
        String string = list.get(n);
        Object object2 = object == null ? NullObject.NULL_OBJECT : object;
        return map.putIfAbsent(string, object2) == null;
    }

    @Override
    public <T> T remove(List<String> list) {
        int n = list.size() - 1;
        Map<String, Object> map = this.getMap(list.subList(0, n));
        if (map == null) {
            return null;
        }
        String string = list.get(n);
        return (T)map.remove(string);
    }

    @Override
    public boolean contains(List<String> list) {
        int n = list.size() - 1;
        Map<String, Object> map = this.getMap(list.subList(0, n));
        if (map == null) {
            return false;
        }
        String string = list.get(n);
        return map.containsKey(string);
    }

    @Override
    public boolean isNull(List<String> list) {
        int n = list.size() - 1;
        Map<String, Object> map = this.getMap(list.subList(0, n));
        if (map == null) {
            return false;
        }
        String string = list.get(n);
        Object object = map.get(string);
        return object == NullObject.NULL_OBJECT;
    }

    private Map<String, Object> getOrCreateMap(List<String> list) {
        Map<String, Object> map = this.map;
        for (String string : list) {
            Config config;
            Object object = map.get(string);
            if (object == null) {
                config = this.createSubConfig();
                map.put(string, config);
            } else {
                if (!(object instanceof Config)) {
                    throw new IncompatibleIntermediaryLevelException("Cannot add an element to an intermediary value of type: " + String.valueOf(object.getClass()));
                }
                config = (Config)object;
            }
            map = config.valueMap();
        }
        return map;
    }

    private Map<String, Object> getMap(List<String> list) {
        Map<String, Object> map = this.map;
        for (String string : list) {
            Object object = map.get(string);
            if (!(object instanceof Config)) {
                return null;
            }
            map = ((Config)object).valueMap();
        }
        return map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Map<String, Object> valueMap() {
        return this.map;
    }

    @Override
    public Set<? extends Config.Entry> entrySet() {
        return new TransformingSet<Map.Entry, EntryWrapper>(this.map.entrySet(), EntryWrapper::new, entryWrapper -> null, object -> object);
    }

    public abstract AbstractConfig clone();

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractConfig) {
            return this.map.equals(((AbstractConfig)object).map);
        }
        if (object instanceof UnmodifiableConfig) {
            UnmodifiableConfig unmodifiableConfig = (UnmodifiableConfig)object;
            if (unmodifiableConfig.size() != this.size()) {
                return false;
            }
            for (UnmodifiableConfig.Entry entry : this.entrySet()) {
                Object t = entry.getValue();
                Object t2 = unmodifiableConfig.get(Collections.singletonList(entry.getKey()));
                if (!(t == null ? t2 != null : !t.equals(t2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + String.valueOf(this.valueMap());
    }

    protected static class EntryWrapper
    implements Config.Entry {
        protected final Map.Entry<String, Object> mapEntry;

        public EntryWrapper(Map.Entry<String, Object> entry) {
            this.mapEntry = entry;
        }

        @Override
        public String getKey() {
            return this.mapEntry.getKey();
        }

        @Override
        public <T> T getRawValue() {
            return (T)this.mapEntry.getValue();
        }

        @Override
        public <T> T setValue(Object object) {
            return (T)this.mapEntry.setValue(object);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof EntryWrapper) {
                EntryWrapper entryWrapper = (EntryWrapper)object;
                return Objects.equals(this.getKey(), entryWrapper.getKey()) && Objects.equals(this.getValue(), entryWrapper.getValue());
            }
            return false;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + Objects.hashCode(this.getKey());
            n = 31 * n + Objects.hashCode(this.getValue());
            return n;
        }
    }
}

