/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.network.request;

import java.util.HashMap;
import java.util.List;
import me.roundaround.custompaintings.roundalib.network.request.ServerRequest;
import net.minecraft.class_8710;

public class RequestTracker {
    private final HashMap<Integer, ServerRequest<?>> pendingRequests = new HashMap();

    public <T extends class_8710> ServerRequest<T> create(Class<T> clazz) throws IllegalStateException {
        return this.create(clazz, ServerRequest.NOOP);
    }

    public <T extends class_8710> ServerRequest<T> create(Class<T> clazz, Runnable runnable) {
        int n = this.getUniqueReqId();
        ServerRequest<T> serverRequest = new ServerRequest<T>(n, clazz, RequestTracker.join(runnable, () -> this.pendingRequests.remove(n)));
        this.pendingRequests.put(n, serverRequest);
        return serverRequest;
    }

    public boolean resolve(ServerRequest<?> serverRequest, class_8710 class_87102) {
        return this.resolve(serverRequest.getReqId(), class_87102);
    }

    public boolean resolve(int n, class_8710 class_87102) {
        ServerRequest<?> serverRequest = this.pendingRequests.remove(n);
        if (serverRequest == null || serverRequest.getFuture().isDone()) {
            return false;
        }
        return serverRequest.resolve(n, class_87102);
    }

    public boolean cancel(ServerRequest<?> serverRequest) {
        return this.cancel(serverRequest.getReqId());
    }

    public boolean cancel(int n) {
        ServerRequest<?> serverRequest = this.pendingRequests.remove(n);
        if (serverRequest == null) {
            return false;
        }
        return serverRequest.cancel();
    }

    public void clear() {
        List<ServerRequest<?>> list = List.copyOf(this.pendingRequests.values());
        for (ServerRequest<?> serverRequest : list) {
            serverRequest.cancel();
        }
        this.pendingRequests.clear();
    }

    private int getUniqueReqId() {
        for (int i = Integer.MIN_VALUE; i < Integer.MAX_VALUE; ++i) {
            if (this.pendingRequests.containsKey(i)) continue;
            return i;
        }
        throw new IllegalStateException("Failed to find an available request ID.");
    }

    private static Runnable join(Runnable runnable, Runnable runnable2) {
        return () -> {
            runnable.run();
            runnable2.run();
        };
    }
}

