/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.config.panic;

import java.io.PrintStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.roundaround.custompaintings.roundalib.RoundaLib;
import me.roundaround.custompaintings.roundalib.util.LoggerOutputStream;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Panic
extends Throwable {
    private static final long serialVersionUID = 1406840684941742372L;

    public Panic() {
    }

    public Panic(String string) {
        super(string);
    }

    public Panic(String string, Throwable throwable) {
        super(string, throwable);
    }

    public Panic(Throwable throwable) {
        super(throwable);
    }

    public static void panic(Panic panic) {
        Panic.panic(panic, Panic.grabModIdFromPackage());
    }

    public static void panic(Panic panic, String string) {
        Panic.panic(panic, string, RoundaLib.LOGGER);
    }

    public static void panic(Panic panic, String string, Logger logger) {
        Optional optional = FabricLoader.getInstance().getModContainer(string);
        String string2 = optional.map(modContainer -> modContainer.getMetadata().getName()).orElse(null);
        String string3 = optional.flatMap(modContainer -> modContainer.getMetadata().getContact().get("issues")).orElse(null);
        logger.error("The mod \"{}\" has encountered an unrecoverable error in its config setup due to a misuse of the RoundaLib library. Please report this as a bug to the mod's developer.", (Object)(string2 == null ? string : string2));
        if (string3 != null) {
            logger.error("Issue tracker: {}", (Object)string3);
        }
        try {
            throw panic;
        }
        catch (Panic panic2) {
            panic2.printStackTrace(new PrintStream(new LoggerOutputStream(logger, Level.FATAL)));
            System.exit(1);
            return;
        }
    }

    private static String grabModIdFromPackage() {
        String string = Panic.class.getPackage().getName();
        Pattern pattern = Pattern.compile("([^.]+)\\.roundalib\\.config\\.panic");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

