/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.config.option;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import me.roundaround.custompaintings.roundalib.config.ConfigPath;
import me.roundaround.custompaintings.roundalib.config.panic.IllegalArgumentPanic;
import me.roundaround.custompaintings.roundalib.config.panic.Panic;
import me.roundaround.custompaintings.roundalib.observable.Computed;
import me.roundaround.custompaintings.roundalib.observable.Observable;
import me.roundaround.custompaintings.roundalib.observable.Subject;
import net.minecraft.class_2561;

public abstract class ConfigOption<D> {
    private final ConfigPath path;
    private final class_2561 label;
    private final D defaultValue;
    private final boolean noGui;
    private final Function<D, String> toStringFunction;
    private final List<String> comment;
    private final List<Validator<D>> validators;
    private final Consumer<ConfigOption<D>> onUpdate;
    private final DisabledValueBehavior disabledValueBehavior;
    private final Function<ConfigOption<D>, D> disabledValueSupplier;
    public final Subject<D> pendingValue;
    public final Subject<D> savedValue;
    public final Subject<Boolean> isDisabled;
    public final Subject<Boolean> isDirty;
    public final Observable<Boolean> isPendingDefault;
    public final Observable<Boolean> isDefault;
    private String modId;

    protected <C extends ConfigOption<D>, B extends AbstractBuilder<D, C, B>> ConfigOption(AbstractBuilder<D, C, B> abstractBuilder) {
        this(abstractBuilder.path, abstractBuilder.label, abstractBuilder.defaultValue, abstractBuilder.noGui, abstractBuilder.toStringFunction, abstractBuilder.comment, abstractBuilder.validators, abstractBuilder.onUpdate, abstractBuilder.disabledValueBehavior, abstractBuilder.disabledValueSupplier);
    }

    protected <C extends ConfigOption<D>> ConfigOption(ConfigPath configPath, class_2561 class_25612, D d, boolean bl, Function<D, String> function, List<String> list, List<Validator<D>> list2, Consumer<ConfigOption<D>> consumer, DisabledValueBehavior disabledValueBehavior, Function<ConfigOption<D>, D> function2) {
        this.path = configPath;
        this.label = class_25612;
        this.defaultValue = d;
        this.noGui = bl;
        this.toStringFunction = function;
        this.comment = list;
        this.validators = list2;
        this.onUpdate = consumer;
        this.disabledValueBehavior = disabledValueBehavior;
        this.disabledValueSupplier = function2;
        this.pendingValue = Subject.of(this.defaultValue).distinct(this::areValuesEqual).cold();
        this.savedValue = Subject.of(this.defaultValue).distinct(this::areValuesEqual);
        this.isDisabled = Subject.of(false);
        this.isDirty = Computed.writable(this.pendingValue, this.savedValue, (object, object2) -> !this.areValuesEqual(object, object2));
        this.isPendingDefault = Computed.of(this.pendingValue, object -> this.areValuesEqual(object, this.defaultValue));
        this.isDefault = Computed.of(this.savedValue, object -> this.areValuesEqual(object, this.defaultValue));
    }

    public void setModId(String string) {
        this.modId = string;
    }

    public String getModId() {
        return this.modId;
    }

    public String getGroup() {
        return this.getPath().getGroup();
    }

    public String getId() {
        return this.getPath().getId();
    }

    public ConfigPath getPath() {
        return this.path;
    }

    public class_2561 getLabel() {
        if (this.label == null) {
            return this.getDefaultLabel();
        }
        return this.label;
    }

    public List<String> getComment() {
        return this.comment;
    }

    public boolean hasGuiControl() {
        return !this.noGui;
    }

    public boolean isDisabled() {
        return (Boolean)this.isDisabled.get();
    }

    public D getValue() {
        return (D)this.savedValue.get();
    }

    public D getPendingValue() {
        if (this.isDisabled()) {
            return switch (this.disabledValueBehavior.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.getDefaultValue();
                case 1 -> this.getValue();
                case 2 -> this.disabledValueSupplier.apply(this);
            };
        }
        return (D)this.pendingValue.get();
    }

    public final String getPendingValueAsString() {
        return this.getValueAsString(this.getPendingValue());
    }

    public String getValueAsString(D d) {
        return this.toStringFunction.apply(d);
    }

    public D getDefaultValue() {
        return this.defaultValue;
    }

    public void setDisabled(boolean bl) {
        this.isDisabled.set(bl);
    }

    public void markDirty() {
        this.isDirty.set(true);
    }

    public boolean isDirty() {
        return (Boolean)this.isDirty.get();
    }

    public boolean isPendingDefault() {
        return this.isPendingDefault.get();
    }

    public boolean isDefault() {
        return this.isDefault.get();
    }

    protected boolean areValuesEqual(D d, D d2) {
        return Objects.equals(d, d2);
    }

    protected class_2561 getDefaultLabel() {
        return class_2561.method_43471((String)(this.modId + "." + this.path.toString(".") + ".label"));
    }

    public void setValue(D d) {
        if (this.isDisabled()) {
            return;
        }
        this.pendingValue.set(d);
    }

    public void commit() {
        this.savedValue.set(this.getPendingValue());
    }

    public void setDefault() {
        this.setValue(this.getDefaultValue());
    }

    public void revert() {
        if (!this.isDirty()) {
            return;
        }
        this.setValue(this.getValue());
    }

    public boolean validate(D d) {
        if (this.validators.isEmpty()) {
            return true;
        }
        return this.validators.stream().allMatch(validator -> validator.validate(d, this));
    }

    public void deserialize(Object object) {
        this.setValue(object);
    }

    public Object serialize() {
        return this.getPendingValue();
    }

    public void update() {
        this.onUpdate.accept(this);
    }

    public static abstract class AbstractBuilder<D, C extends ConfigOption<D>, B extends AbstractBuilder<D, C, B>> {
        protected final ConfigPath path;
        protected class_2561 label = null;
        protected D defaultValue;
        protected boolean noGui = false;
        protected Function<D, String> toStringFunction = Object::toString;
        protected List<String> comment = new ArrayList<String>();
        protected List<Validator<D>> validators = new ArrayList<Validator<D>>();
        protected Consumer<ConfigOption<D>> onUpdate = configOption -> {};
        protected boolean allowNullDefault = false;
        private DisabledValueBehavior disabledValueBehavior = DisabledValueBehavior.STORED;
        private Function<ConfigOption<D>, D> disabledValueSupplier = null;

        protected AbstractBuilder(ConfigPath configPath) {
            this.path = configPath;
        }

        public B setLabel(String string) {
            this.label = class_2561.method_43471((String)string);
            return this.self();
        }

        public B setLabel(class_2561 class_25612) {
            this.label = class_25612;
            return this.self();
        }

        public B setDefaultValue(D d) {
            this.defaultValue = d;
            return this.self();
        }

        public B hideFromConfigScreen() {
            this.noGui = true;
            return this.self();
        }

        public B setToStringFunction(Function<D, String> function) {
            this.toStringFunction = function;
            return this.self();
        }

        public B setComment(String string) {
            this.comment = List.of(string);
            return this.self();
        }

        public B setComment(String ... stringArray) {
            this.comment = List.of(stringArray);
            return this.self();
        }

        public B setComment(Collection<String> collection) {
            this.comment = List.copyOf(collection);
            return this.self();
        }

        public B setValidators(Collection<Validator<D>> collection) {
            this.validators = List.copyOf(collection);
            return this.self();
        }

        public B addValidator(Validator<D> validator) {
            this.validators.add(validator);
            return this.self();
        }

        public B onUpdate(Consumer<ConfigOption<D>> consumer) {
            this.onUpdate = consumer;
            return this.self();
        }

        public B allowNullDefaultValue() {
            this.allowNullDefault = true;
            return this.self();
        }

        public B defaultWhenDisabled() {
            this.disabledValueBehavior = DisabledValueBehavior.DEFAULT;
            return this.self();
        }

        public B storedWhenDisabled() {
            this.disabledValueBehavior = DisabledValueBehavior.STORED;
            return this.self();
        }

        public B valueWhenDisabled(Function<ConfigOption<D>, D> function) {
            this.disabledValueBehavior = DisabledValueBehavior.PRODUCE;
            this.disabledValueSupplier = function;
            return this.self();
        }

        protected void validate() {
            if (!this.allowNullDefault && this.defaultValue == null) {
                Panic.panic(new IllegalArgumentPanic("All config options must have a non-null default value or explicitly set the flag allowing null"));
            }
        }

        private B self() {
            return (B)this;
        }

        protected abstract C buildInternal();

        public final C build() {
            this.validate();
            return this.buildInternal();
        }
    }

    public static enum DisabledValueBehavior {
        DEFAULT,
        STORED,
        PRODUCE;

    }

    @FunctionalInterface
    public static interface Validator<D> {
        public boolean validate(D var1, ConfigOption<D> var2);
    }
}

