/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource.legacy;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.client.texture.LoadingSprite;
import me.roundaround.custompaintings.resource.Image;
import me.roundaround.custompaintings.resource.MigrationResource;
import me.roundaround.custompaintings.resource.PackFileUid;
import me.roundaround.custompaintings.resource.PackIcons;
import me.roundaround.custompaintings.resource.PackMetadata;
import me.roundaround.custompaintings.resource.PackResource;
import me.roundaround.custompaintings.resource.PaintingResource;
import me.roundaround.custompaintings.resource.ResourceUtil;
import me.roundaround.custompaintings.resource.legacy.CustomPaintingsJson;
import me.roundaround.custompaintings.resource.legacy.LegacyMigrationResource;
import me.roundaround.custompaintings.resource.legacy.LegacyPackCheckResult;
import me.roundaround.custompaintings.resource.legacy.LegacyPackResource;
import me.roundaround.custompaintings.resource.legacy.LegacyPaintingResource;
import me.roundaround.custompaintings.resource.legacy.PackMcmeta;
import me.roundaround.custompaintings.roundalib.util.PathAccessor;
import me.roundaround.custompaintings.util.CustomId;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_7771;

public class LegacyPackConverter {
    private static final String CUSTOM_PAINTINGS_JSON = "custompaintings.json";
    private static final String PACK_MCMETA = "pack.mcmeta";
    private static final String PACK_PNG = "pack.png";
    private static final String ICON_PNG = "icon.png";
    private static LegacyPackConverter instance = null;
    private final HashSet<CustomId> spriteIds = new HashSet();
    private final Executor ioExecutor = class_156.method_27958();
    private class_1059 atlas = null;
    private Path globalOutDir = null;

    private LegacyPackConverter() {
    }

    public static LegacyPackConverter getInstance() {
        if (instance == null) {
            instance = new LegacyPackConverter();
        }
        return instance;
    }

    public class_2960 getAtlasId() {
        if (this.atlas == null) {
            return null;
        }
        return this.atlas.method_24106();
    }

    public class_1058 getMissingSprite() {
        if (this.atlas == null) {
            return null;
        }
        return this.atlas.method_4608(class_1047.method_4539());
    }

    public class_1058 getSprite(String string) {
        return this.getSprite(PackIcons.customId(string));
    }

    public class_1058 getSprite(CustomId customId) {
        if (this.atlas == null) {
            return null;
        }
        if (!this.spriteIds.contains(customId)) {
            return this.getMissingSprite();
        }
        return this.atlas.method_4608(customId.toIdentifier());
    }

    public Path getWorldOutDir() {
        try {
            Path path = PathAccessor.getInstance().getPerWorldModDir("custompaintings");
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            return path;
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn((Object)iOException);
            CustomPaintingsMod.LOGGER.warn("Failed to create output directory for legacy pack conversion.");
            return null;
        }
    }

    public Path getGlobalOutDir() {
        if (this.globalOutDir != null) {
            return this.globalOutDir;
        }
        try {
            Path path = FabricLoader.getInstance().getGameDir().resolve("data").resolve("custompaintings").resolve("converted");
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            this.globalOutDir = path;
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn((Object)iOException);
            CustomPaintingsMod.LOGGER.warn("Failed to create output directory for legacy pack conversion.");
        }
        return this.globalOutDir;
    }

    public CompletableFuture<Collection<PackMetadata<LegacyPackResource>>> checkForLegacyPacks(class_310 class_3102) {
        Path path = class_3102.method_1479();
        return CompletableFuture.supplyAsync(() -> this.checkForLegacyPackMetadata(path), this.ioExecutor);
    }

    public CompletableFuture<LegacyPackCheckResult> checkForLegacyPacksAndConvertedIds(class_310 class_3102) {
        Path path = class_3102.method_1479();
        boolean bl = class_3102.method_1542();
        return CompletableFuture.supplyAsync(() -> this.loadAllDataFromFiles(path, bl), this.ioExecutor).thenApplyAsync(legacyPackCheckResult -> {
            this.uploadIconsSpriteAtlas(class_3102, legacyPackCheckResult.metas());
            return legacyPackCheckResult;
        }, (Executor)class_3102);
    }

    private LegacyPackCheckResult loadAllDataFromFiles(Path path, boolean bl) {
        ArrayList<PackMetadata<LegacyPackResource>> arrayList = this.checkForLegacyPackMetadata(path);
        HashMap<String, Path> hashMap = this.lookUpConvertedPacks(this.getGlobalOutDir());
        HashMap<String, Path> hashMap2 = bl ? this.lookUpConvertedPacks(this.getWorldOutDir()) : new HashMap();
        return new LegacyPackCheckResult(arrayList, hashMap, hashMap2);
    }

    private ArrayList<PackMetadata<LegacyPackResource>> checkForLegacyPackMetadata(Path path2) {
        ArrayList<PackMetadata<LegacyPackResource>> arrayList = new ArrayList<PackMetadata<LegacyPackResource>>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2);){
            directoryStream.forEach(path -> {
                PackMetadata<LegacyPackResource> packMetadata = LegacyPackConverter.readPackMetadata(path);
                if (packMetadata == null) {
                    return;
                }
                arrayList.add(packMetadata);
            });
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn((Object)iOException);
            CustomPaintingsMod.LOGGER.warn("Error while checking for legacy packs in the resource pack directory...exiting early.");
        }
        return arrayList;
    }

    private HashMap<String, Path> lookUpConvertedPacks(Path path2) {
        HashMap<String, Path> hashMap = new HashMap<String, Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2);){
            directoryStream.forEach(path -> {
                try {
                    BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    String string = null;
                    if (basicFileAttributes.isDirectory()) {
                        string = this.readPackFileUidFromDirectory((Path)path);
                    } else if (basicFileAttributes.isRegularFile()) {
                        string = this.readPackFileUidFromZip((Path)path);
                    }
                    if (string != null) {
                        hashMap.put(string, (Path)path);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn((Object)iOException);
            CustomPaintingsMod.LOGGER.warn("Error while looking up list of already-converted packs...exiting early.");
        }
        return hashMap;
    }

    private String readPackFileUidFromDirectory(Path path) {
        SourceLegacyPackWrapper sourceLegacyPackWrapper;
        try {
            sourceLegacyPackWrapper = (SourceLegacyPackWrapper)CustomPaintingsMod.GSON.fromJson((Reader)Files.newBufferedReader(path.resolve(CUSTOM_PAINTINGS_JSON)), SourceLegacyPackWrapper.class);
        }
        catch (Exception exception) {
            return null;
        }
        return sourceLegacyPackWrapper.sourceLegacyPack();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readPackFileUidFromZip(Path path) {
        try (ZipFile zipFile = new ZipFile(path.toFile());){
            SourceLegacyPackWrapper sourceLegacyPackWrapper;
            Object object;
            ZipEntry zipEntry = zipFile.getEntry(CUSTOM_PAINTINGS_JSON);
            if (zipEntry == null) {
                String string = null;
                return string;
            }
            try {
                object = zipFile.getInputStream(zipEntry);
                try {
                    sourceLegacyPackWrapper = (SourceLegacyPackWrapper)CustomPaintingsMod.GSON.fromJson((Reader)new InputStreamReader((InputStream)object), SourceLegacyPackWrapper.class);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (Exception exception) {
                String string = null;
                zipFile.close();
                return string;
            }
            object = sourceLegacyPackWrapper.sourceLegacyPack();
            return object;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void uploadIconsSpriteAtlas(class_310 class_3102, Collection<PackMetadata<LegacyPackResource>> collection) {
        this.atlas = new class_1059(class_2960.method_60655((String)"custompaintings", (String)"textures/atlas/legacy_pack_icons.png"));
        class_3102.method_1531().method_4616(this.atlas.method_24106(), (class_1044)this.atlas);
        ArrayList<class_7764> arrayList = new ArrayList<class_7764>();
        arrayList.add(class_1047.method_45805());
        collection.forEach(packMetadata -> {
            if (packMetadata.icon() == null) {
                return;
            }
            CustomId customId = PackIcons.customId(((LegacyPackResource)packMetadata.pack()).packId());
            this.spriteIds.add(customId);
            arrayList.add(LegacyPackConverter.getIconSpriteContents(customId.toIdentifier(), packMetadata.icon()));
        });
        this.atlas.method_45848(class_7766.method_45837((class_1059)this.atlas).method_47663(arrayList, 0, (Executor)class_156.method_18349()));
    }

    public CompletableFuture<Boolean> convertPack(PackMetadata<LegacyPackResource> packMetadata, Path path) {
        return CompletableFuture.supplyAsync(() -> {
            Object object;
            LegacyPackResource legacyPackResource = (LegacyPackResource)packMetadata.pack();
            HashMap<CustomId, Image> hashMap = LegacyPackConverter.readPaintingImages(legacyPackResource);
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            legacyPackResource.paintings().forEach(legacyPaintingResource -> hashMap2.put(legacyPaintingResource.id(), new PaintingResource(legacyPaintingResource.id(), legacyPaintingResource.name(), legacyPaintingResource.artist(), legacyPaintingResource.height(), legacyPaintingResource.width())));
            hashMap2.keySet().removeIf(string -> !hashMap.containsKey(new CustomId(legacyPackResource.packId(), (String)string)));
            legacyPackResource.migrations().forEach(legacyMigrationResource -> {
                List<List<String>> list = legacyMigrationResource.pairs().stream().map(List::copyOf).toList();
                hashMap3.put(legacyMigrationResource.id(), new MigrationResource(legacyMigrationResource.id(), legacyMigrationResource.description(), list));
            });
            PackResource packResource = new PackResource(1, legacyPackResource.packId(), legacyPackResource.name(), legacyPackResource.description(), packMetadata.packFileUid().stringValue(), List.copyOf(hashMap2.values()), List.copyOf(hashMap3.values()));
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    object = path.resolveSibling(path.getFileName().toString() + "_old");
                    if (Files.exists((Path)object, new LinkOption[0])) {
                        Files.delete((Path)object);
                    }
                    Files.move(path, (Path)object, new CopyOption[0]);
                }
            }
            catch (IOException iOException) {
                return false;
            }
            try {
                object = new FileOutputStream(path.toFile());
                try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object);){
                    LegacyPackConverter.writeCustomPaintingsJson(zipOutputStream, packResource);
                    CustomId customId = PackIcons.customId(packResource.id());
                    if (hashMap.containsKey(customId)) {
                        LegacyPackConverter.writeImage(zipOutputStream, ICON_PNG, hashMap.get(customId));
                    }
                    for (PaintingResource paintingResource : packResource.paintings()) {
                        CustomId customId2 = new CustomId(packResource.id(), paintingResource.id());
                        if (!hashMap.containsKey(customId2)) continue;
                        LegacyPackConverter.writeImage(zipOutputStream, Paths.get("images", paintingResource.id() + ".png").toString(), hashMap.get(customId2));
                    }
                }
                finally {
                    ((FileOutputStream)object).close();
                }
            }
            catch (IOException iOException) {
                CustomPaintingsMod.LOGGER.warn("Failed to automatically convert legacy painting pack {}", (Object)legacyPackResource.path().getFileName());
                return false;
            }
            return true;
        }, this.ioExecutor);
    }

    private static class_7764 getIconSpriteContents(class_2960 class_29602, Image image) {
        if (image == null || image.isEmpty()) {
            return LoadingSprite.generate(class_29602, 16, 16);
        }
        class_1011 class_10112 = LegacyPackConverter.getNativeImage(image);
        return new class_7764(class_29602, new class_7771(image.width(), image.height()), class_10112, class_7368.field_38688);
    }

    private static class_1011 getNativeImage(Image image) {
        class_1011 class_10112 = new class_1011(image.width(), image.height(), false);
        for (int i = 0; i < image.width(); ++i) {
            for (int j = 0; j < image.height(); ++j) {
                class_10112.method_61941(i, j, image.getARGB(i, j));
            }
        }
        return class_10112;
    }

    private static PackMetadata<LegacyPackResource> readPackMetadata(Path path) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (basicFileAttributes.isDirectory()) {
                return LegacyPackConverter.readPackMetadataFromDirectory(path);
            }
            if (basicFileAttributes.isRegularFile()) {
                return LegacyPackConverter.readPackMetadataFromZip(path);
            }
        }
        catch (Exception exception) {
            CustomPaintingsMod.LOGGER.warn((Object)exception);
            CustomPaintingsMod.LOGGER.warn("Error reading Custom Paintings pack \"{}\", skipping...", (Object)path.getFileName());
        }
        return null;
    }

    private static PackMetadata<LegacyPackResource> readPackMetadataFromDirectory(Path path) {
        if (!Files.isRegularFile(path.resolve(CUSTOM_PAINTINGS_JSON), LinkOption.NOFOLLOW_LINKS)) {
            return null;
        }
        CustomPaintingsJson customPaintingsJson = LegacyPackConverter.readCustomPaintingsJson(path.resolve(CUSTOM_PAINTINGS_JSON));
        if (customPaintingsJson == null) {
            return null;
        }
        String string = path.getFileName().toString();
        long l = ResourceUtil.lastModified(path);
        long l2 = ResourceUtil.fileSize(path);
        PackFileUid packFileUid = new PackFileUid(false, string, l, l2);
        PackMcmeta packMcmeta = LegacyPackConverter.readPackMcmeta(path.resolve(PACK_MCMETA));
        String string2 = customPaintingsJson.id();
        String string3 = customPaintingsJson.name();
        List<LegacyPaintingResource> list = customPaintingsJson.paintings();
        List<LegacyMigrationResource> list2 = customPaintingsJson.migrations();
        String string4 = packMcmeta == null ? "" : packMcmeta.pack().description();
        LegacyPackResource legacyPackResource = new LegacyPackResource(path, string2, string3, string4, list, list2);
        Image image = LegacyPackConverter.readImage(path.resolve(PACK_PNG));
        return new PackMetadata<LegacyPackResource>(packFileUid, legacyPackResource, image);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PackMetadata<LegacyPackResource> readPackMetadataFromZip(Path path) {
        String string2 = path.getFileName().toString();
        if (!string2.endsWith(".zip")) {
            return null;
        }
        if (path.getFileSystem() != FileSystems.getDefault()) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(path.toFile());){
            String string = ResourceUtil.getFolderPrefix(zipFile);
            CustomPaintingsJson customPaintingsJson = LegacyPackConverter.readCustomPaintingsJson(zipFile, string + CUSTOM_PAINTINGS_JSON);
            if (customPaintingsJson == null) {
                PackMetadata<LegacyPackResource> packMetadata = null;
                return packMetadata;
            }
            long l = ResourceUtil.lastModified(path);
            long l2 = ResourceUtil.fileSize(path);
            PackFileUid packFileUid = new PackFileUid(true, string2, l, l2);
            PackMcmeta packMcmeta = LegacyPackConverter.readPackMcmeta(zipFile, string + PACK_MCMETA);
            String string3 = customPaintingsJson.id();
            String string4 = customPaintingsJson.name();
            List<LegacyPaintingResource> list = customPaintingsJson.paintings();
            List<LegacyMigrationResource> list2 = customPaintingsJson.migrations();
            String string5 = packMcmeta == null ? "" : packMcmeta.pack().description();
            LegacyPackResource legacyPackResource = new LegacyPackResource(path, string3, string4, string5, list, list2);
            Image image = ResourceUtil.readImageFromZip(zipFile, string, PACK_PNG);
            PackMetadata<LegacyPackResource> packMetadata = new PackMetadata<LegacyPackResource>(packFileUid, legacyPackResource, image);
            return packMetadata;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static HashMap<CustomId, Image> readPaintingImages(LegacyPackResource legacyPackResource) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(legacyPackResource.path(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (basicFileAttributes.isDirectory()) {
                return LegacyPackConverter.readPaintingImagesFromDirectory(legacyPackResource);
            }
            if (basicFileAttributes.isRegularFile()) {
                return LegacyPackConverter.readPaintingImagesFromZip(legacyPackResource);
            }
        }
        catch (Exception exception) {
            CustomPaintingsMod.LOGGER.warn((Object)exception);
            CustomPaintingsMod.LOGGER.warn("Error reading Custom Paintings pack \"{}\", skipping...", (Object)legacyPackResource.path().getFileName());
        }
        return new HashMap<CustomId, Image>();
    }

    private static HashMap<CustomId, Image> readPaintingImagesFromDirectory(LegacyPackResource legacyPackResource) {
        HashMap<CustomId, Image> hashMap = new HashMap<CustomId, Image>();
        Path path = legacyPackResource.path();
        if (Files.notExists(path, new LinkOption[0])) {
            return hashMap;
        }
        String string = legacyPackResource.packId();
        List<LegacyPaintingResource> list = legacyPackResource.paintings();
        Image image = LegacyPackConverter.readImage(path.resolve(PACK_PNG));
        if (image != null) {
            hashMap.put(PackIcons.customId(string), image);
        }
        for (LegacyPaintingResource legacyPaintingResource : list) {
            Image image2 = LegacyPackConverter.readImage(path.resolve(LegacyPackConverter.getPaintingPath(string, legacyPaintingResource.id())));
            if (image2 == null) continue;
            hashMap.put(new CustomId(string, legacyPaintingResource.id()), image2);
        }
        return hashMap;
    }

    private static HashMap<CustomId, Image> readPaintingImagesFromZip(LegacyPackResource legacyPackResource) {
        HashMap<CustomId, Image> hashMap = new HashMap<CustomId, Image>();
        Path path = legacyPackResource.path();
        String string = path.getFileName().toString();
        if (!string.endsWith(".zip")) {
            return hashMap;
        }
        if (path.getFileSystem() != FileSystems.getDefault()) {
            return hashMap;
        }
        try (ZipFile zipFile = new ZipFile(path.toFile());){
            String string2 = ResourceUtil.getFolderPrefix(zipFile);
            String string3 = legacyPackResource.packId();
            List<LegacyPaintingResource> list = legacyPackResource.paintings();
            Image image = ResourceUtil.readImageFromZip(zipFile, string2, PACK_PNG);
            if (image != null) {
                hashMap.put(PackIcons.customId(string3), image);
            }
            for (LegacyPaintingResource legacyPaintingResource : list) {
                Image image2;
                ArrayList<String> arrayList = LegacyPackConverter.getPaintingPathSegments(string3, legacyPaintingResource.id());
                if (!string2.isBlank()) {
                    arrayList.addFirst(string2);
                }
                if ((image2 = ResourceUtil.readImageFromZip(zipFile, arrayList)) == null) continue;
                hashMap.put(new CustomId(string3, legacyPaintingResource.id()), image2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hashMap;
    }

    private static CustomPaintingsJson readCustomPaintingsJson(Path path) {
        CustomPaintingsJson customPaintingsJson;
        try {
            customPaintingsJson = (CustomPaintingsJson)CustomPaintingsMod.GSON.fromJson((Reader)Files.newBufferedReader(path), CustomPaintingsJson.class);
        }
        catch (Exception exception) {
            return null;
        }
        if (customPaintingsJson.paintings().isEmpty()) {
            return null;
        }
        return customPaintingsJson;
    }

    private static CustomPaintingsJson readCustomPaintingsJson(ZipFile zipFile, String string) {
        CustomPaintingsJson customPaintingsJson;
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            customPaintingsJson = (CustomPaintingsJson)CustomPaintingsMod.GSON.fromJson((Reader)new InputStreamReader(inputStream), CustomPaintingsJson.class);
        }
        catch (Exception exception) {
            return null;
        }
        if (customPaintingsJson.paintings().isEmpty()) {
            return null;
        }
        return customPaintingsJson;
    }

    private static PackMcmeta readPackMcmeta(Path path) {
        try {
            return (PackMcmeta)CustomPaintingsMod.GSON.fromJson((Reader)Files.newBufferedReader(path), PackMcmeta.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static PackMcmeta readPackMcmeta(ZipFile zipFile, String string) {
        PackMcmeta packMcmeta;
        block9: {
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                return null;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                packMcmeta = (PackMcmeta)CustomPaintingsMod.GSON.fromJson((Reader)new InputStreamReader(inputStream), PackMcmeta.class);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            inputStream.close();
        }
        return packMcmeta;
    }

    private static Image readImage(Path path) {
        try {
            BufferedImage bufferedImage = ImageIO.read(Files.newInputStream(path, LinkOption.NOFOLLOW_LINKS));
            if (bufferedImage == null) {
                return null;
            }
            return Image.read(bufferedImage);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Path getPaintingPath(String string, String string2) {
        ArrayList<String> arrayList = LegacyPackConverter.getPaintingPathSegments(string, string2);
        String string3 = arrayList.removeFirst();
        String[] stringArray = arrayList.toArray(new String[0]);
        return Paths.get(string3, stringArray);
    }

    private static ArrayList<String> getPaintingPathSegments(String string, String string2) {
        return new ArrayList<CallSite>(List.of("assets", string, "textures", "painting", string2 + ".png"));
    }

    private static void writeCustomPaintingsJson(ZipOutputStream zipOutputStream, PackResource packResource) throws IOException {
        ZipEntry zipEntry = new ZipEntry(CUSTOM_PAINTINGS_JSON);
        zipOutputStream.putNextEntry(zipEntry);
        String string = CustomPaintingsMod.GSON.toJson((Object)packResource);
        byte[] byArray = string.getBytes();
        zipOutputStream.write(byArray, 0, byArray.length);
        zipOutputStream.closeEntry();
    }

    private static void writeImage(ZipOutputStream zipOutputStream, String string, Image image) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        ImageIO.write((RenderedImage)image.toBufferedImage(), "png", zipOutputStream);
    }

    private record SourceLegacyPackWrapper(String sourceLegacyPack) {
    }
}

