/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.resource.HashResult;
import me.roundaround.custompaintings.resource.Image;
import me.roundaround.custompaintings.resource.PackIcons;
import me.roundaround.custompaintings.util.CustomId;

public class ResourceUtil {
    private static final String CUSTOM_PAINTINGS_JSON = "custompaintings.json";

    private ResourceUtil() {
    }

    public static long lastModified(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public static long fileSize(Path path) {
        try {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                return Files.size(path);
            }
            return ResourceUtil.directorySize(path, true);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public static long directorySize(Path path) {
        return ResourceUtil.directorySize(path, false);
    }

    public static long directorySize(Path path, boolean bl) {
        var var2_2 = new Object(){
            long value = 0L;
        };
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            for (Path path2 : stream::iterator) {
                if (path2.equals(path)) continue;
                try {
                    if (bl) {
                        var2_2.value += ResourceUtil.fileSize(path2);
                        continue;
                    }
                    if (!Files.isRegularFile(path2, new LinkOption[0])) continue;
                    var2_2.value += Files.size(path2);
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return var2_2.value;
    }

    public static String getFolderPrefix(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        if (!enumeration.hasMoreElements()) {
            return "";
        }
        ZipEntry zipEntry = enumeration.nextElement();
        if (!zipEntry.isDirectory()) {
            return "";
        }
        String string = zipEntry.getName();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry2 = enumeration.nextElement();
            if (zipEntry2.getName().startsWith(string)) continue;
            return "";
        }
        return string;
    }

    public static String stripTrailingSeparator(String string) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static ZipEntry getImageZipEntry(ZipFile zipFile, String ... stringArray) {
        return ResourceUtil.getImageZipEntry(zipFile, List.of(stringArray));
    }

    public static ZipEntry getImageZipEntry(ZipFile zipFile, Iterable<String> iterable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : iterable) {
            String string2;
            if (string == null || (string2 = ResourceUtil.stripTrailingSeparator(string)).isBlank()) continue;
            arrayList.add(string2);
        }
        Object object = zipFile.getEntry(String.join((CharSequence)"/", arrayList));
        if (object == null) {
            object = zipFile.getEntry(String.join((CharSequence)"\\", arrayList));
        }
        return object;
    }

    public static Image readImageFromZip(ZipFile zipFile, String ... stringArray) {
        return ResourceUtil.readImageFromZip(zipFile, List.of(stringArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image readImageFromZip(ZipFile zipFile, Iterable<String> iterable) {
        ZipEntry zipEntry = ResourceUtil.getImageZipEntry(zipFile, iterable);
        if (zipEntry == null) {
            return null;
        }
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage == null) {
                Image image2 = null;
                return image2;
            }
            Image image = Image.read(bufferedImage);
            return image;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isPaintingPack(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return Files.exists(path.resolve(CUSTOM_PAINTINGS_JSON), new LinkOption[0]);
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            boolean bl;
            ZipFile zipFile = new ZipFile(path.toFile());
            try {
                bl = zipFile.getEntry(CUSTOM_PAINTINGS_JSON) != null;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            zipFile.close();
            return bl;
        }
        return false;
    }

    public static HashSet<CustomId> getAllImageIds(Collection<String> collection, Collection<CustomId> collection2) {
        HashSet<CustomId> hashSet = new HashSet<CustomId>();
        hashSet.addAll(collection.stream().map(PackIcons::customId).toList());
        hashSet.addAll(collection2);
        return hashSet;
    }

    public static String hashOrEmpty(ByteSource byteSource) {
        try {
            return byteSource.hash(Hashing.sha256()).toString();
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Exception raised while generating hash.", (Throwable)iOException);
            return "";
        }
    }

    public static HashResult hashImages(Map<CustomId, Image> map) {
        HashMap<CustomId, String> hashMap = new HashMap<CustomId, String>();
        LinkedHashMap<CustomId, ByteSource> linkedHashMap = ResourceUtil.getByteSources(map);
        for (Map.Entry<CustomId, ByteSource> entry : linkedHashMap.entrySet()) {
            hashMap.put(entry.getKey(), ResourceUtil.hashOrEmpty(entry.getValue()));
        }
        String string = ResourceUtil.calculateCombinedHash(linkedHashMap);
        return new HashResult(string, hashMap);
    }

    private static LinkedHashMap<CustomId, ByteSource> getByteSources(Map<CustomId, Image> map) {
        TreeSet<CustomId> treeSet = new TreeSet<CustomId>(map.keySet());
        LinkedHashMap<CustomId, ByteSource> linkedHashMap = new LinkedHashMap<CustomId, ByteSource>();
        for (CustomId customId : treeSet) {
            linkedHashMap.putIfAbsent(customId, map.get(customId).getByteSource());
        }
        return linkedHashMap;
    }

    private static String calculateCombinedHash(LinkedHashMap<CustomId, ByteSource> linkedHashMap) {
        return ResourceUtil.hashOrEmpty(ByteSource.concat(linkedHashMap.values()));
    }
}

