/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Function;
import javax.imageio.ImageIO;
import me.roundaround.custompaintings.CustomPaintingsMod;
import net.minecraft.class_9139;

public record Image(Color[] pixels, int width, int height) {
    public static final class_9139<ByteBuf, Image> PACKET_CODEC = class_9139.method_56438(Image::writeToByteBuf, Image::fromByteBuf);

    public static Image empty() {
        return new Image(new Color[0], 0, 0);
    }

    public static Image fromBytes(byte[] byArray, int n, int n2) {
        int n3 = n * n2;
        if (byArray.length < n3 * 4) {
            byArray = Arrays.copyOf(byArray, n3 * 4);
        }
        Color[] colorArray = new Color[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = i * 4;
            colorArray[i] = new Color(byArray[n4], byArray[n4 + 1], byArray[n4 + 2], byArray[n4 + 3]);
        }
        return new Image(colorArray, n, n2);
    }

    public static Image read(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        Color[] colorArray = new Color[n * n2];
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                colorArray[Image.getIndex((int)n2, (int)i, (int)j)] = Color.fromARGB(nArray[j * n + i]);
            }
        }
        return new Image(colorArray, n, n2);
    }

    public static Image read(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            throw new IOException("Invalid painting image file");
        }
        return Image.read(bufferedImage);
    }

    public static Image read(byte[] byArray) throws IOException {
        return Image.read(new ByteArrayInputStream(byArray));
    }

    public BufferedImage toBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                bufferedImage.setRGB(i, j, this.getARGB(i, j));
            }
        }
        return bufferedImage;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.getSize()];
        for (int i = 0; i < this.pixels.length; ++i) {
            byArray[i * 4] = this.pixels[i].r;
            byArray[i * 4 + 1] = this.pixels[i].g;
            byArray[i * 4 + 2] = this.pixels[i].b;
            byArray[i * 4 + 3] = this.pixels[i].a;
        }
        return byArray;
    }

    public int getSize() {
        return this.pixels.length * 4;
    }

    public ByteSource getByteSource() {
        return ByteSource.wrap((byte[])this.getBytes());
    }

    public String getHash() {
        try {
            return this.getByteSource().hash(Hashing.sha256()).toString();
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Exception raised while generating hash.", (Throwable)iOException);
            return "";
        }
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public int getARGB(int n, int n2) {
        return this.getColorInt(n, n2, Color::getARGB);
    }

    public int getABGR(int n, int n2) {
        return this.getColorInt(n, n2, Color::getABGR);
    }

    private int getColorInt(int n, int n2, Function<Color, Integer> function) {
        int n3 = this.getIndex(n, n2);
        Color color = this.pixels[n3];
        if (color == null) {
            return 0;
        }
        return function.apply(color);
    }

    private int getIndex(int n, int n2) {
        return Image.getIndex(this.height, n, n2);
    }

    private static int getIndex(int n, int n2, int n3) {
        return n2 * n + n3;
    }

    public void writeToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.width);
        byteBuf.writeInt(this.height);
        byteBuf.writeBytes(this.getBytes());
    }

    public static Image fromByteBuf(ByteBuf byteBuf) {
        int n = byteBuf.readInt();
        int n2 = byteBuf.readInt();
        byte[] byArray = new byte[n * n2 * 4];
        byteBuf.readBytes(byArray);
        return Image.fromBytes(byArray, n, n2);
    }

    public record Color(byte r, byte g, byte b, byte a) {
        public Color(int n, int n2, int n3, int n4) {
            this((byte)n, (byte)n2, (byte)n3, (byte)n4);
        }

        public static Color fromARGB(int n) {
            return new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, n >> 24 & 0xFF);
        }

        public int getARGB() {
            return Color.getAsInt(this.a, this.r, this.g, this.b);
        }

        public int getABGR() {
            return Color.getAsInt(this.a, this.b, this.g, this.r);
        }

        private static int getAsInt(byte by, byte by2, byte by3, byte by4) {
            return (by & 0xFF) << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
        }
    }
}

