/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.registry;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import me.roundaround.custompaintings.resource.Image;
import me.roundaround.custompaintings.util.CustomId;
import me.roundaround.custompaintings.util.TriConsumer;

public class ImageStore {
    private final HashMap<CustomId, StoredImage> store = new HashMap();

    public ImageStore() {
    }

    private ImageStore(Map<CustomId, StoredImage> map) {
        this.store.putAll(map);
    }

    public void clear() {
        this.store.clear();
    }

    public void putAll(Map<CustomId, Image> map, Map<CustomId, String> map2) {
        map.forEach((? super K customId, ? super V image) -> this.store.put((CustomId)customId, new StoredImage((Image)image, (String)map2.get(customId))));
    }

    public void setAll(Map<CustomId, Image> map, Map<CustomId, String> map2) {
        this.clear();
        this.putAll(map, map2);
    }

    public StoredImage put(CustomId customId, Image image) {
        return this.store.put(customId, new StoredImage(image));
    }

    public StoredImage put(CustomId customId, Image image, String string) {
        return this.store.put(customId, new StoredImage(image, string));
    }

    public boolean contains(CustomId customId) {
        return this.store.containsKey(customId);
    }

    public Image getImage(CustomId customId) {
        StoredImage storedImage = this.store.get(customId);
        if (storedImage == null) {
            return null;
        }
        return storedImage.image();
    }

    public StoredImage get(CustomId customId) {
        return this.store.get(customId);
    }

    public void forEach(TriConsumer<CustomId, Image, String> triConsumer) {
        this.store.forEach((? super K customId, ? super V storedImage) -> triConsumer.accept((CustomId)customId, storedImage.image(), storedImage.hash()));
    }

    public StoredImage remove(CustomId customId) {
        return this.store.remove(customId);
    }

    public boolean removeIf(Predicate<CustomId> predicate) {
        return this.store.keySet().removeIf(predicate);
    }

    public ImageStore copy() {
        return new ImageStore(this.store);
    }

    public ImmutableMap<CustomId, String> getHashes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.forEach((customId, image, string) -> {
            if (string != null) {
                builder.put(customId, string);
            }
        });
        return builder.build();
    }

    public record StoredImage(Image image, String hash) {
        public StoredImage(Image image) {
            this(image, null);
        }

        public StoredImage(Image image, String string) {
            this.image = image;
            this.hash = string == null ? image.getHash() : string;
        }
    }
}

