/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.command.argument;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.registry.CustomPaintingRegistry;
import me.roundaround.custompaintings.server.registry.ServerPaintingRegistry;

public enum PackType {
    ALL("all", CustomPaintingRegistry::getAllPacks),
    ENABLED("enabled", CustomPaintingRegistry::getActivePacks),
    DISABLED("disabled", CustomPaintingRegistry::getInactivePacks);

    private final String id;
    private final Function<ServerPaintingRegistry, Collection<PackData>> getPacks;

    private PackType(String string2, Function<ServerPaintingRegistry, Collection<PackData>> function) {
        this.id = string2;
        this.getPacks = function;
    }

    public String toString() {
        return this.id;
    }

    public Collection<PackData> getPacks(ServerPaintingRegistry serverPaintingRegistry) {
        return this.getPacks.apply(serverPaintingRegistry);
    }

    public static PackType parse(String string) throws IllegalArgumentException {
        return Arrays.stream(PackType.values()).filter(packType -> packType.id.equals(string)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown PackType " + string));
    }
}

