/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.client.registry.CacheRead;
import me.roundaround.custompaintings.config.CustomPaintingsConfig;
import me.roundaround.custompaintings.registry.ImageStore;
import me.roundaround.custompaintings.resource.Image;
import me.roundaround.custompaintings.util.CustomId;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_4844;
import org.jetbrains.annotations.NotNull;

public class CacheManager {
    private static CacheManager instance = null;
    private UUID serverId = null;

    private CacheManager() {
    }

    public static CacheManager getInstance() {
        if (instance == null) {
            instance = new CacheManager();
        }
        return instance;
    }

    public static void runBackgroundClean() {
        CompletableFuture.runAsync(() -> {
            try {
                Path path = CacheManager.getDataFile(CacheManager.getCacheDir());
                if (Files.notExists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
                    return;
                }
                class_2487 class_24872 = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
                CacheData cacheData = CacheData.fromNbt(class_24872);
                CacheManager.trimExpired(cacheData);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, (Executor)class_156.method_27958());
    }

    public CacheRead loadFromFile(UUID uUID, HashSet<CustomId> hashSet) {
        class_2487 class_24872;
        this.serverId = uUID;
        Path path = CacheManager.getCacheDir();
        Path path2 = CacheManager.getDataFile(path);
        if (Files.notExists(path2, new LinkOption[0]) || !Files.isRegularFile(path2, new LinkOption[0])) {
            return null;
        }
        try {
            class_24872 = class_2507.method_30613((Path)path2, (class_2505)class_2505.method_53898());
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Failed to load cache data");
            return null;
        }
        CacheData cacheData = CacheData.fromNbt(class_24872);
        if (!cacheData.byServer().containsKey(this.serverId)) {
            return null;
        }
        long l = class_156.method_659() - CacheManager.getTtlMs();
        ServerCacheData serverCacheData = cacheData.byServer().get(this.serverId);
        if (serverCacheData.lastAccess() <= l) {
            return null;
        }
        Set set = hashSet.stream().map(CustomId::pack).collect(Collectors.toSet());
        HashMap<CustomId, String> hashMap = new HashMap<CustomId, String>();
        for (PackCacheData object2 : serverCacheData.packs()) {
            if (!set.contains(object2.packId())) continue;
            for (ImageCacheData imageCacheData : object2.images()) {
                if (imageCacheData.lastAccess() <= l || !hashSet.contains(imageCacheData.id(object2.packId()))) continue;
                hashMap.put(imageCacheData.id(object2.packId()), imageCacheData.hash());
            }
        }
        HashMap hashMap2 = new HashMap();
        hashMap.forEach((customId, string) -> {
            Image image = CacheManager.loadImage(path, string);
            if (image == null || image.isEmpty()) {
                return;
            }
            hashMap2.put(customId, image);
        });
        String string2 = serverCacheData.combinedHash();
        CacheManager.touchCache(cacheData, uUID, string2, Map.copyOf(hashMap));
        return new CacheRead(hashMap2, hashMap, string2);
    }

    public void saveToFile(ImageStore imageStore, String string3) throws IOException {
        class_2487 class_24872;
        if (this.serverId == null) {
            return;
        }
        long l = class_156.method_659();
        Path path = CacheManager.getCacheDir();
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        Path path2 = CacheManager.getDataFile(path);
        HashMap hashMap = new HashMap();
        imageStore.forEach((customId, image, string) -> {
            try {
                String string3 = customId.pack();
                PackCacheData packCacheData = hashMap.computeIfAbsent(string3, string2 -> PackCacheData.empty(string3));
                if (string == null) {
                    CustomPaintingsMod.LOGGER.warn("Failed to save image to cache: {}", customId);
                    return;
                }
                ImageIO.write((RenderedImage)image.toBufferedImage(), "png", path.resolve(string + ".png").toFile());
                packCacheData.images().add(new ImageCacheData(customId.resource(), (String)string, l));
            }
            catch (IOException iOException) {
                CustomPaintingsMod.LOGGER.warn((Object)iOException);
                CustomPaintingsMod.LOGGER.warn("Failed to save image to cache: {}", customId);
            }
        });
        if (Files.notExists(path2, new LinkOption[0])) {
            class_24872 = new class_2487();
        } else {
            try {
                class_24872 = class_2507.method_30613((Path)path2, (class_2505)class_2505.method_53898());
            }
            catch (IOException iOException) {
                CustomPaintingsMod.LOGGER.warn("Failed to read existing cache data before writing");
                class_24872 = new class_2487();
            }
        }
        CacheData cacheData = CacheData.fromNbt(class_24872);
        cacheData.byServer().put(this.serverId, new ServerCacheData(this.serverId, string3, new ArrayList<PackCacheData>(hashMap.values()), l));
        imageStore.getHashes().forEach((customId, string2) -> {
            ArrayList arrayList = cacheData.byHash().computeIfAbsent((String)string2, string -> new ArrayList());
            arrayList.removeIf(hashCacheData -> hashCacheData.serverId().equals(this.serverId));
            arrayList.add(new HashCacheData(this.serverId, l));
        });
        class_2507.method_30614((class_2487)cacheData.toNbt(), (Path)path2);
        CompletableFuture.runAsync(() -> CacheManager.trimExpired(cacheData), (Executor)class_156.method_27958());
    }

    @NotNull
    public CacheStats clear() {
        Path path = CacheManager.getCacheDir();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                    @Override
                    @NotNull
                    public FileVisitResult visitFile(Path path, @NotNull BasicFileAttributes basicFileAttributes) throws IOException {
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    @NotNull
                    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return this.getStats();
    }

    @NotNull
    public CacheStats getStats() {
        class_2487 class_24872;
        Path path = CacheManager.getCacheDir();
        Path path2 = CacheManager.getDataFile(path);
        if (Files.notExists(path2, new LinkOption[0])) {
            return new CacheStats(0, 0, 0, 0L);
        }
        try {
            class_24872 = class_2507.method_30613((Path)path2, (class_2505)class_2505.method_53898());
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Exception raised while reading cache stats:", (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
        CacheData cacheData = CacheData.fromNbt(class_24872);
        int n = cacheData.byServer().size();
        int n2 = cacheData.byHash().size();
        int n3 = (int)cacheData.byHash().entrySet().stream().filter(entry -> ((ArrayList)entry.getValue()).size() > 1).count();
        final var var8_9 = new Object(this){
            long value = 0L;
        };
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                @NotNull
                public FileVisitResult visitFile(Path path, @NotNull BasicFileAttributes basicFileAttributes) {
                    var8_9.value += basicFileAttributes.size();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult visitFileFailed(Path path, @NotNull IOException iOException) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Exception raised while reading cache stats:", (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
        return new CacheStats(n, n2, n3, var8_9.value);
    }

    private static Path getCacheDir() {
        return FabricLoader.getInstance().getGameDir().resolve("data").resolve("custompaintings").resolve("cache");
    }

    private static Path getDataFile(Path path) {
        return path.resolve("data.dat");
    }

    private static void deleteImage(Path path, String string) throws IOException {
        Path path2 = path.resolve(string + ".png");
        if (Files.notExists(path2, new LinkOption[0]) || !Files.isRegularFile(path2, new LinkOption[0])) {
            return;
        }
        Files.delete(path2);
    }

    private static Image loadImage(Path path, String string) {
        Path path2 = path.resolve(string + ".png");
        if (Files.notExists(path2, new LinkOption[0]) || !Files.isRegularFile(path2, new LinkOption[0])) {
            return Image.empty();
        }
        try {
            return Image.read(Files.newInputStream(path2, new OpenOption[0]));
        }
        catch (IOException iOException) {
            return Image.empty();
        }
    }

    private static long getTtlMs() {
        return 86400000L * (long)((Integer)CustomPaintingsConfig.getInstance().cacheTtl.getValue()).intValue();
    }

    private static void touchCache(CacheData cacheData, UUID uUID, String string3, Map<CustomId, String> map) {
        long l = class_156.method_659();
        ServerCacheData serverCacheData2 = CacheManager.getAndIfPresentOrCompute(cacheData.byServer(), uUID, serverCacheData -> serverCacheData.setLastAccess(l), () -> new ServerCacheData(uUID, string3, new ArrayList<PackCacheData>(), l));
        HashMap<String, HashMap> hashMap2 = new HashMap<String, HashMap>();
        map.forEach((customId, string2) -> {
            HashMap hashMap2 = hashMap2.computeIfAbsent(customId.pack(), string -> new HashMap());
            hashMap2.put(customId, string2);
        });
        hashMap2.forEach((string2, hashMap) -> {
            PackCacheData packCacheData2 = CacheManager.findOrCompute(serverCacheData2.packs(), packCacheData -> Objects.equals(packCacheData.packId(), string2), () -> new PackCacheData((String)string2, new ArrayList<ImageCacheData>()));
            hashMap.forEach((customId, string) -> CacheManager.ifPresentOrCompute(packCacheData2.images(), imageCacheData -> imageCacheData.id(packCacheData2.packId()).equals(customId), imageCacheData -> imageCacheData.setLastAccess(l), () -> new ImageCacheData(customId.resource(), (String)string, l)));
        });
        map.forEach((customId, string) -> Optional.ofNullable(cacheData.byHash().get(string)).ifPresent(arrayList -> CacheManager.ifPresentOrCompute(arrayList, hashCacheData -> hashCacheData.serverId().equals(uUID), hashCacheData -> hashCacheData.setLastAccess(l), () -> new HashCacheData(uUID, l))));
        try {
            class_2507.method_30614((class_2487)cacheData.toNbt(), (Path)CacheManager.getDataFile(CacheManager.getCacheDir()));
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn(String.format("Failed to update access time in cache for server %s", uUID), (Throwable)iOException);
        }
    }

    private static void trimExpired(CacheData cacheData) {
        Path path = CacheManager.getCacheDir();
        long l = class_156.method_659();
        long l2 = CacheManager.getTtlMs();
        long l3 = l - l2;
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        Path path2 = CacheManager.getDataFile(path);
        HashSet hashSet = new HashSet();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            directoryStream.forEach(path3 -> {
                if (path3.equals(path2)) {
                    return;
                }
                String string = path3.getFileName().toString();
                if (!string.toLowerCase().endsWith(".png")) {
                    return;
                }
                String string2 = string.substring(0, string.length() - 4);
                if (!cacheData.byHash().containsKey(string2)) {
                    try {
                        CacheManager.deleteImage(path, string2);
                    }
                    catch (IOException iOException) {
                        CustomPaintingsMod.LOGGER.warn(String.format("Failed to delete stale cached image %s.png", string2), (Throwable)iOException);
                    }
                    return;
                }
                ArrayList<HashCacheData> arrayList = cacheData.byHash().get(string2);
                arrayList.removeIf(hashCacheData -> hashCacheData.lastAccess() < l3);
                if (arrayList.isEmpty()) {
                    cacheData.byHash().remove(string2);
                    try {
                        CacheManager.deleteImage(path, string2);
                    }
                    catch (IOException iOException) {
                        CustomPaintingsMod.LOGGER.warn(String.format("Failed to delete stale cached image %s.png", string2), (Throwable)iOException);
                    }
                    return;
                }
                hashSet.add(string2);
            });
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Failed to access cache directory for cleaning", (Throwable)iOException);
            return;
        }
        cacheData.byServer().entrySet().removeIf(entry -> {
            ServerCacheData serverCacheData = (ServerCacheData)entry.getValue();
            if (serverCacheData.lastAccess() < l3) {
                return true;
            }
            ArrayList<PackCacheData> arrayList = serverCacheData.packs();
            if (arrayList.isEmpty()) {
                return true;
            }
            arrayList.removeIf(packCacheData -> {
                ArrayList<ImageCacheData> arrayList = packCacheData.images();
                arrayList.removeIf(imageCacheData -> !hashSet.contains(imageCacheData.hash()) || imageCacheData.lastAccess() < l3);
                return arrayList.isEmpty();
            });
            return arrayList.isEmpty();
        });
        try {
            class_2507.method_30614((class_2487)cacheData.toNbt(), (Path)path2);
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Failed to write trimmed cache data file", (Throwable)iOException);
        }
    }

    private static <T, U> U getAndIfPresentOrCompute(Map<T, U> map, T t, Consumer<U> consumer, Supplier<U> supplier) {
        U u = map.get(t);
        if (u != null) {
            consumer.accept(u);
            return u;
        }
        return supplier.get();
    }

    private static <T> T findOrCompute(Collection<T> collection, Predicate<T> predicate, Supplier<T> supplier) {
        return (T)collection.stream().filter(predicate).findAny().orElseGet(() -> {
            Object t = supplier.get();
            collection.add(t);
            return t;
        });
    }

    private static <T> void ifPresentOrCompute(Collection<T> collection, Predicate<T> predicate, Consumer<T> consumer, Supplier<T> supplier) {
        collection.stream().filter(predicate).findAny().ifPresentOrElse(consumer, () -> collection.add(supplier.get()));
    }

    private record CacheData(int version, HashMap<UUID, ServerCacheData> byServer, HashMap<String, ArrayList<HashCacheData>> byHash) {
        public static final String NBT_VERSION = "Version";
        public static final String NBT_BY_SERVER = "ByServer";
        public static final String NBT_BY_HASH = "ByHash";
        public static Codec<CacheData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf(NBT_VERSION).forGetter(CacheData::version), (App)Codec.unboundedMap((Codec)class_4844.field_41525, ServerCacheData.CODEC).xmap(HashMap::new, Function.identity()).fieldOf(NBT_BY_SERVER).forGetter(CacheData::byServer), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.list(HashCacheData.CODEC).xmap(ArrayList::new, Function.identity())).xmap(HashMap::new, Function.identity()).fieldOf(NBT_BY_HASH).forGetter(CacheData::byHash)).apply((Applicative)instance, CacheData::new));

        public static CacheData fromNbt(class_2487 class_24872) {
            return (CacheData)CODEC.parse((DynamicOps)class_2509.field_11560, (Object)class_24872).getPartialOrThrow();
        }

        public class_2487 toNbt() {
            return (class_2487)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow();
        }
    }

    private static final class ServerCacheData {
        public static final String NBT_ID = "Id";
        public static final String NBT_COMBINED_HASH = "CombinedHash";
        public static final String NBT_PACKS = "Packs";
        public static final String NBT_LAST_ACCESS = "LastAccess";
        public static final Codec<ServerCacheData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf(NBT_ID).forGetter(ServerCacheData::serverId), (App)Codec.STRING.fieldOf(NBT_COMBINED_HASH).forGetter(ServerCacheData::combinedHash), (App)Codec.list(PackCacheData.CODEC).xmap(ArrayList::new, Function.identity()).fieldOf(NBT_PACKS).forGetter(ServerCacheData::packs), (App)Codec.LONG.fieldOf(NBT_LAST_ACCESS).forGetter(ServerCacheData::lastAccess)).apply((Applicative)instance, ServerCacheData::new));
        private final UUID serverId;
        private final String combinedHash;
        private final ArrayList<PackCacheData> packs;
        private long lastAccess;

        private ServerCacheData(UUID uUID, String string, ArrayList<PackCacheData> arrayList, long l) {
            this.serverId = uUID;
            this.combinedHash = string;
            this.packs = arrayList;
            this.lastAccess = l;
        }

        public UUID serverId() {
            return this.serverId;
        }

        public String combinedHash() {
            return this.combinedHash;
        }

        public ArrayList<PackCacheData> packs() {
            return this.packs;
        }

        public long lastAccess() {
            return this.lastAccess;
        }

        public void setLastAccess(long l) {
            this.lastAccess = l;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            ServerCacheData serverCacheData = (ServerCacheData)object;
            return Objects.equals(this.serverId, serverCacheData.serverId) && Objects.equals(this.combinedHash, serverCacheData.combinedHash) && Objects.equals(this.packs, serverCacheData.packs) && this.lastAccess == serverCacheData.lastAccess;
        }

        public int hashCode() {
            return Objects.hash(this.serverId, this.combinedHash, this.packs, this.lastAccess);
        }
    }

    private record PackCacheData(String packId, ArrayList<ImageCacheData> images) {
        public static final String NBT_ID = "Id";
        public static final String NBT_IMAGES = "Images";
        public static final Codec<PackCacheData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf(NBT_ID).forGetter(PackCacheData::packId), (App)Codec.list(ImageCacheData.CODEC).xmap(ArrayList::new, Function.identity()).fieldOf(NBT_IMAGES).forGetter(PackCacheData::images)).apply((Applicative)instance, PackCacheData::new));

        public static PackCacheData empty(String string) {
            return new PackCacheData(string, new ArrayList<ImageCacheData>());
        }
    }

    private static final class ImageCacheData {
        public static final String NBT_ID = "Id";
        public static final String NBT_HASH = "Hash";
        public static final String NBT_LAST_ACCESS = "LastAccess";
        public static final Codec<ImageCacheData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf(NBT_ID).forGetter(ImageCacheData::id), (App)Codec.STRING.fieldOf(NBT_HASH).forGetter(ImageCacheData::hash), (App)Codec.LONG.fieldOf(NBT_LAST_ACCESS).forGetter(ImageCacheData::lastAccess)).apply((Applicative)instance, ImageCacheData::new));
        private final String id;
        private final String hash;
        private long lastAccess;

        private ImageCacheData(String string, String string2, long l) {
            this.id = string;
            this.hash = string2;
            this.lastAccess = l;
        }

        public String id() {
            return this.id;
        }

        public CustomId id(String string) {
            return new CustomId(string, this.id());
        }

        public String hash() {
            return this.hash;
        }

        public long lastAccess() {
            return this.lastAccess;
        }

        public void setLastAccess(long l) {
            this.lastAccess = l;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            ImageCacheData imageCacheData = (ImageCacheData)object;
            return Objects.equals(this.id, imageCacheData.id) && Objects.equals(this.hash, imageCacheData.hash) && this.lastAccess == imageCacheData.lastAccess;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.hash, this.lastAccess);
        }
    }

    public record CacheStats(int servers, int images, int shared, long bytes) {
    }

    private static final class HashCacheData {
        public static final String NBT_ID = "Id";
        public static final String NBT_LAST_ACCESS = "LastAccess";
        public static final Codec<HashCacheData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf(NBT_ID).forGetter(HashCacheData::serverId), (App)Codec.LONG.fieldOf(NBT_LAST_ACCESS).forGetter(HashCacheData::lastAccess)).apply((Applicative)instance, HashCacheData::new));
        private final UUID serverId;
        private long lastAccess;

        private HashCacheData(UUID uUID, long l) {
            this.serverId = uUID;
            this.lastAccess = l;
        }

        public UUID serverId() {
            return this.serverId;
        }

        public long lastAccess() {
            return this.lastAccess;
        }

        public void setLastAccess(long l) {
            this.lastAccess = l;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            HashCacheData hashCacheData = (HashCacheData)object;
            return Objects.equals(this.serverId, hashCacheData.serverId) && this.lastAccess == hashCacheData.lastAccess;
        }

        public int hashCode() {
            return Objects.hash(this.serverId, this.lastAccess);
        }
    }
}

