/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.gui.widget;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.roundaround.custompaintings.client.gui.FiltersState;
import me.roundaround.custompaintings.roundalib.client.gui.layout.screen.ThreeSectionLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.IntSliderWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.ParentElementEntryListWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.drawable.LabelWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5676;

@Environment(value=EnvType.CLIENT)
public class FilterListWidget
extends ParentElementEntryListWidget<Entry> {
    public FilterListWidget(FiltersState filtersState, class_310 class_3102, ThreeSectionLayoutWidget threeSectionLayoutWidget) {
        super(class_3102, threeSectionLayoutWidget);
        this.addEntry((n, n2, n3, n4) -> new SectionTitleEntry(this.client.field_1772, (class_2561)class_2561.method_43471((String)"custompaintings.filter.section.search"), n, n2, n3, n4));
        this.addEntry((n, n2, n3, n4) -> new TextFilterEntry(this.client.field_1772, (class_2561)class_2561.method_43471((String)"custompaintings.filter.any"), filtersState::getSearch, filtersState::setSearch, n, n2, n3, n4));
        this.addEntry((n, n2, n3, n4) -> new TextFilterEntry(this.client.field_1772, (class_2561)class_2561.method_43471((String)"custompaintings.filter.name"), filtersState::getNameSearch, filtersState::setNameSearch, n, n2, n3, n4));
        this.addEntry((n, n2, n3, n4) -> new ToggleFilterEntry((class_2561)class_2561.method_43471((String)"custompaintings.filter.name.empty"), class_5244.field_24336, class_5244.field_24337, filtersState::getNonEmptyNameOnly, filtersState::setNonEmptyNameOnly, n, n2, n3, n4));
        this.addEntry((n, n2, n3, n4) -> new TextFilterEntry(this.client.field_1772, (class_2561)class_2561.method_43471((String)"custompaintings.filter.artist"), filtersState::getArtistSearch, filtersState::setArtistSearch, n, n2, n3, n4));
        this.addEntry((n, n2, n3, n4) -> new ToggleFilterEntry((class_2561)class_2561.method_43471((String)"custompaintings.filter.artist.empty"), class_5244.field_24336, class_5244.field_24337, filtersState::getNonEmptyArtistOnly, filtersState::setNonEmptyArtistOnly, n, n2, n3, n4));
        this.addEntry((n, n2, n3, n4) -> new SectionTitleEntry(this.client.field_1772, (class_2561)class_2561.method_43471((String)"custompaintings.filter.section.size"), n, n2, n3, n4));
        this.addEntry((n, n2, n3, n4) -> new ToggleFilterEntry((class_2561)class_2561.method_43471((String)"custompaintings.filter.canstay"), class_5244.field_24336, class_5244.field_24337, filtersState::getCanStayOnly, filtersState::setCanStayOnly, n, n2, n3, n4));
        this.addEntry((n, n2, n3, n4) -> new SizeRangeEntry(filtersState::getMinWidth, filtersState::getMaxWidth, filtersState::setMinWidth, filtersState::setMaxWidth, "custompaintings.filter.minwidth", "custompaintings.filter.maxwidth", n, n2, n3, n4));
        this.addEntry((n, n2, n3, n4) -> new SizeRangeEntry(filtersState::getMinHeight, filtersState::getMaxHeight, filtersState::setMinHeight, filtersState::setMaxHeight, "custompaintings.filter.minheight", "custompaintings.filter.maxheight", n, n2, n3, n4));
    }

    public void updateFilters() {
        this.forEachEntry(Entry::resetToFilterValue);
    }

    public class_364 getFirstFocusable() {
        return this.method_25396().stream().flatMap(entry -> entry.method_25396().stream()).filter(class_3642 -> class_3642 instanceof class_342 || class_3642 instanceof class_4185 || class_3642 instanceof class_357).findFirst().orElse(null);
    }

    @Override
    protected int getPreferredContentWidth() {
        return 280;
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends ParentElementEntryListWidget.Entry {
        protected static final int HEIGHT = 20;
        protected static final int MAX_FULL_WIDTH = 310;

        protected Entry(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3, n4, n5);
        }

        public void resetToFilterValue() {
        }

        protected int getFullControlWidth() {
            return Math.min(310, this.getContentWidth());
        }

        protected int getHalfControlWidth() {
            return (this.getFullControlWidth() - 8) / 2;
        }

        protected int getControlLeft() {
            return this.getContentCenterX() - this.getFullControlWidth() / 2;
        }

        protected int getControlRight() {
            return this.getContentCenterX() + this.getFullControlWidth() / 2;
        }

        protected int getRightControlLeft() {
            return this.getControlRight() - this.getHalfControlWidth();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SizeRangeEntry
    extends Entry {
        private final IntSliderWidget lowSlider;
        private final IntSliderWidget highSlider;
        private final Supplier<Integer> lowGetter;
        private final Supplier<Integer> highGetter;
        private final Consumer<Integer> lowSetter;
        private final Consumer<Integer> highSetter;

        public SizeRangeEntry(Supplier<Integer> supplier, Supplier<Integer> supplier2, Consumer<Integer> consumer, Consumer<Integer> consumer2, String string, String string2, int n2, int n3, int n4, int n5) {
            super(n2, n3, n4, n5, 20);
            this.lowGetter = supplier;
            this.highGetter = supplier2;
            this.lowSetter = consumer;
            this.highSetter = consumer2;
            this.lowSlider = this.addDrawableChild(new IntSliderWidget(this.getControlLeft(), this.getContentTop(), this.getHalfControlWidth(), this.getContentHeight(), 1, 32, this.lowGetter.get(), this::stepLow, this::onLowSliderChange, n -> class_2561.method_43469((String)string, (Object[])new Object[]{n})));
            this.highSlider = this.addDrawableChild(new IntSliderWidget(this.getRightControlLeft(), this.getContentTop(), this.getHalfControlWidth(), this.getContentHeight(), 1, 32, this.highGetter.get(), this::stepHigh, this::onHighSliderChange, n -> class_2561.method_43469((String)string2, (Object[])new Object[]{n})));
        }

        @Override
        public void resetToFilterValue() {
            this.lowSlider.setIntValue(this.lowGetter.get());
            this.highSlider.setIntValue(this.highGetter.get());
        }

        @Override
        public void method_48222() {
            super.method_48222();
            this.lowSlider.method_55444(this.getHalfControlWidth(), this.getContentHeight(), this.getControlLeft(), this.getContentTop());
            this.highSlider.method_55444(this.getHalfControlWidth(), this.getContentHeight(), this.getRightControlLeft(), this.getContentTop());
        }

        private int stepLow(int n) {
            return SizeRangeEntry.step(this.lowSlider.getIntValue(), n);
        }

        private int stepHigh(int n) {
            return SizeRangeEntry.step(this.highSlider.getIntValue(), n);
        }

        private void onLowSliderChange(int n) {
            this.lowSetter.accept(n);
        }

        private void onHighSliderChange(int n) {
            this.highSetter.accept(n);
        }

        private static int step(int n, int n2) {
            if (n == 1 && n2 == 1) {
                return 4;
            }
            return class_3532.method_15340((int)(n + 4 * n2), (int)1, (int)32);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ToggleFilterEntry
    extends Entry {
        private final Supplier<Boolean> getter;
        private final class_5676<Boolean> button;

        public ToggleFilterEntry(class_2561 class_25612, class_2561 class_25613, class_2561 class_25614, Supplier<Boolean> supplier, Consumer<Boolean> consumer, int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4, 20);
            this.getter = supplier;
            this.button = class_5676.method_32607((class_2561)class_25613, (class_2561)class_25614).method_32620(List.of(Boolean.valueOf(true), Boolean.valueOf(false))).method_32619((Object)this.getter.get()).method_32617(this.getControlLeft(), this.getContentTop(), this.getFullControlWidth(), this.getContentHeight(), class_25612, (class_56762, bl) -> consumer.accept((Boolean)bl));
            this.addDrawableChild(this.button);
        }

        @Override
        public void method_48222() {
            this.button.method_55444(this.getFullControlWidth(), this.getContentHeight(), this.getControlLeft(), this.getContentTop());
        }

        @Override
        public void resetToFilterValue() {
            this.button.method_32605((Object)this.getter.get());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SectionTitleEntry
    extends Entry {
        protected final LabelWidget label;

        public SectionTitleEntry(class_327 class_3272, class_2561 class_25612, int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4, 20);
            this.setForceRowShading(true);
            this.setMarginY(8);
            this.label = LabelWidget.builder(class_3272, class_25612).position(this.getContentLeft(), this.getContentTop()).dimensions(this.getFullControlWidth(), this.getContentHeight()).alignTextCenterX().alignTextCenterY().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).showShadow().hideBackground().build();
            this.addDrawableChild(this.label);
        }

        @Override
        public void method_48222() {
            this.label.batchUpdates(() -> {
                this.label.method_48229(this.getContentLeft(), this.getContentTop());
                this.label.method_55445(this.getFullControlWidth(), this.getContentHeight());
            });
        }

        @Override
        protected void renderRowShade(class_332 class_3322) {
            SectionTitleEntry.renderRowShade(class_3322, this.method_46426(), this.method_46427() + this.margin.top(), this.getRight(), this.getBottom() - this.margin.bottom(), this.getRowShadeFadeWidth(), this.getRowShadeStrength());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class TextFilterEntry
    extends Entry {
        private final Supplier<String> getter;
        private final LabelWidget label;
        private final class_342 textField;

        public TextFilterEntry(class_327 class_3272, class_2561 class_25612, Supplier<String> supplier, Consumer<String> consumer, int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4, 20);
            this.getter = supplier;
            this.label = LabelWidget.builder(class_3272, class_25612).position(this.getControlLeft(), this.getContentCenterY()).dimensions(this.getHalfControlWidth(), this.getContentHeight()).alignSelfLeft().alignSelfCenterY().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).showShadow().hideBackground().build();
            this.addDrawableChild(this.label);
            this.textField = new class_342(class_3272, this.getRightControlLeft(), this.getContentTop(), this.getHalfControlWidth(), this.getContentHeight(), class_25612);
            this.textField.method_1863(consumer);
            this.textField.method_1852(this.getter.get());
            this.addDrawableChild(this.textField);
        }

        @Override
        public void resetToFilterValue() {
            this.textField.method_1852(this.getter.get());
        }

        @Override
        public void method_48222() {
            this.label.batchUpdates(() -> {
                this.label.method_48229(this.getControlLeft(), this.getContentCenterY());
                this.label.method_55445(this.getHalfControlWidth(), this.getContentHeight());
            });
            this.textField.method_55444(this.getHalfControlWidth(), this.getContentHeight(), this.getRightControlLeft(), this.getContentTop());
        }
    }
}

