/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.gui.screen.edit;

import java.util.List;
import java.util.Objects;
import me.roundaround.custompaintings.client.gui.PaintingEditState;
import me.roundaround.custompaintings.client.gui.screen.edit.FiltersScreen;
import me.roundaround.custompaintings.client.gui.screen.edit.PackSelectScreen;
import me.roundaround.custompaintings.client.gui.screen.edit.PaintingEditScreen;
import me.roundaround.custompaintings.client.gui.widget.PaintingListWidget;
import me.roundaround.custompaintings.client.gui.widget.PaintingSpriteWidget;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.entity.decoration.painting.PaintingData;
import me.roundaround.custompaintings.roundalib.client.gui.icon.BuiltinIcon;
import me.roundaround.custompaintings.roundalib.client.gui.layout.FillerWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.screen.ThreeSectionLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.util.Axis;
import me.roundaround.custompaintings.roundalib.client.gui.util.GuiUtil;
import me.roundaround.custompaintings.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.drawable.LabelWidget;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7836;
import net.minecraft.class_7919;

public class PaintingSelectScreen
extends PaintingEditScreen
implements PaintingEditState.StateChangedListener {
    protected static final int BUTTON_HEIGHT = 20;
    protected static final int BUTTON_SPACING = 8;
    private final ThreeSectionLayoutWidget layout = new ThreeSectionLayoutWidget(this);
    private class_342 searchBox;
    private PaintingListWidget paintingList;
    private LabelWidget infoLabel;
    private PaintingSpriteWidget paintingSprite;
    private IconButtonWidget prevButton;
    private LabelWidget controlsLabel;
    private IconButtonWidget nextButton;
    private class_4185 doneButton;

    public PaintingSelectScreen(PaintingEditState paintingEditState) {
        super(PaintingSelectScreen.getTitleText(paintingEditState), paintingEditState);
    }

    public void method_25426() {
        this.layout.addHeader(this.field_22793, this.field_22785);
        this.layout.getBody().flowAxis(Axis.HORIZONTAL).spacing(0);
        LinearLayoutWidget linearLayoutWidget4 = LinearLayoutWidget.vertical().defaultOffAxisContentAlignEnd().spacing(4);
        LinearLayoutWidget linearLayoutWidget5 = linearLayoutWidget4.add(LinearLayoutWidget.horizontal().spacing(4), (linearLayoutWidget2, linearLayoutWidget3) -> linearLayoutWidget3.setDimensions(linearLayoutWidget4.method_25368() - 4, 20));
        this.searchBox = linearLayoutWidget5.add(new class_342(this.field_22793, 0, 20, (class_2561)class_2561.method_43471((String)"custompaintings.painting.search")), (linearLayoutWidget, class_3422) -> class_3422.method_25358(linearLayoutWidget.method_25368() - linearLayoutWidget.getSpacing() - 20));
        this.searchBox.method_1863(this::onSearchBoxChanged);
        linearLayoutWidget5.add(IconButtonWidget.builder(BuiltinIcon.FILTER_18, "custompaintings").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"custompaintings.painting.filter")).onPress(this::filterButtonPressed).build());
        this.paintingList = linearLayoutWidget4.add(new PaintingListWidget(this.field_22787, this.state, this::onPaintingListSelect, this::saveSelection), (linearLayoutWidget, paintingListWidget) -> paintingListWidget.method_55445(linearLayoutWidget.method_25368(), linearLayoutWidget.method_25364() - linearLayoutWidget.getSpacing() - 20));
        LinearLayoutWidget linearLayoutWidget6 = LinearLayoutWidget.vertical().spacing(4).defaultOffAxisContentAlignCenter();
        this.infoLabel = linearLayoutWidget6.add(LabelWidget.builder(this.field_22793, this.getInfoLines()).alignTextCenterX().alignTextCenterY().hideBackground().showShadow().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).lineSpacing(1).build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(linearLayoutWidget.method_25368()));
        this.paintingSprite = linearLayoutWidget6.add(PaintingSpriteWidget.builder(this.state.getCurrentPainting()).border(true).build(), (linearLayoutWidget, paintingSpriteWidget) -> paintingSpriteWidget.method_55445(linearLayoutWidget.method_25368() - 8, linearLayoutWidget.method_25364() - this.infoLabel.method_25364() - 20 - 2 * linearLayoutWidget.getSpacing()));
        LinearLayoutWidget linearLayoutWidget7 = LinearLayoutWidget.horizontal().spacing(4).defaultOffAxisContentAlignCenter();
        this.prevButton = linearLayoutWidget7.add(IconButtonWidget.builder(BuiltinIcon.PREV_18, "custompaintings").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"custompaintings.painting.previous")).onPress(class_41852 -> this.state.setPreviousPainting()).build());
        this.controlsLabel = linearLayoutWidget7.add(LabelWidget.builder(this.field_22793, this.getControlsText()).alignTextCenterX().alignTextCenterY().hideBackground().showShadow().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_55445(linearLayoutWidget.method_25368() - 48, linearLayoutWidget.method_25364()));
        this.nextButton = linearLayoutWidget7.add(IconButtonWidget.builder(BuiltinIcon.NEXT_18, "custompaintings").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"custompaintings.painting.next")).onPress(class_41852 -> this.state.setNextPainting()).build());
        linearLayoutWidget6.add(linearLayoutWidget7, (linearLayoutWidget, linearLayoutWidget2) -> linearLayoutWidget2.setWidth(linearLayoutWidget.method_25368()));
        this.layout.addBody(linearLayoutWidget4, (linearLayoutWidget, linearLayoutWidget2) -> {
            class_7836 class_78362 = new class_7836(linearLayoutWidget.method_25368() - 8, 2);
            linearLayoutWidget2.setDimensions(class_78362.nextInt(), linearLayoutWidget.method_25364());
        });
        this.layout.addBody(FillerWidget.ofWidth(8));
        this.layout.addBody(linearLayoutWidget6, (linearLayoutWidget, linearLayoutWidget2) -> {
            class_7836 class_78362 = new class_7836(linearLayoutWidget.method_25368() - 8, 2);
            class_78362.skip(1);
            linearLayoutWidget2.setDimensions(class_78362.nextInt() - 4, linearLayoutWidget.method_25364());
        });
        this.layout.addBody(FillerWidget.ofWidth(4));
        this.layout.addFooter(class_4185.method_46430((class_2561)class_5244.field_24339, class_41852 -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new PackSelectScreen(this.state))).method_46431());
        this.doneButton = this.layout.addFooter(class_4185.method_46430((class_2561)class_5244.field_24334, class_41852 -> this.saveCurrentSelection()).method_46431());
        this.layout.method_48206(class_3642 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)class_3642);
        });
        this.method_48640();
        this.state.setStateChangedListener(this);
        this.searchBox.method_1852(this.state.getFilters().getSearch());
        this.method_48265((class_364)this.searchBox);
    }

    protected void method_48640() {
        this.layout.method_48222();
    }

    public boolean method_25422() {
        return false;
    }

    public boolean method_25404(int n, int n2, int n3) {
        switch (n) {
            case 263: {
                if (!this.state.hasPaintingsToIterate() || !PaintingSelectScreen.method_25441()) break;
                GuiUtil.playClickSound();
                this.state.setPreviousPainting();
                return true;
            }
            case 262: {
                if (!this.state.hasPaintingsToIterate() || !PaintingSelectScreen.method_25441()) break;
                GuiUtil.playClickSound();
                this.state.setNextPainting();
                return true;
            }
            case 256: {
                this.navigate(new PackSelectScreen(this.state));
                return true;
            }
            case 70: {
                if (!PaintingSelectScreen.method_25441()) break;
                if (PaintingSelectScreen.method_25442()) {
                    this.navigate(new FiltersScreen(this.state));
                    return true;
                }
                if (this.method_25399() == this.searchBox) break;
                this.method_25395((class_364)this.searchBox);
            }
        }
        return super.method_25404(n, n2, n3);
    }

    @Override
    public void onPaintingsListChanged() {
        this.paintingList.refreshPaintings();
        this.controlsLabel.setText(this.getControlsText());
        this.prevButton.field_22763 = this.state.hasPaintingsToIterate();
        this.nextButton.field_22763 = this.state.hasPaintingsToIterate();
    }

    @Override
    public void onCurrentPaintingChanged() {
        PaintingData paintingData = this.state.getCurrentPainting();
        boolean bl = this.state.canStay();
        this.paintingList.selectPainting(paintingData);
        this.infoLabel.batchUpdates(() -> {
            this.infoLabel.setText(this.getInfoLines());
            this.infoLabel.method_53533(this.infoLabel.getDefaultHeight());
        });
        this.paintingSprite.batchUpdates(() -> {
            this.paintingSprite.setPaintingData(paintingData);
            this.paintingSprite.setActive(bl);
            this.paintingSprite.method_47400(bl ? null : class_7919.method_47407((class_2561)PaintingSelectScreen.getTooBigText(paintingData)));
        });
        this.controlsLabel.setText(this.getControlsText());
        this.doneButton.field_22763 = bl;
        this.doneButton.method_47400(bl ? null : class_7919.method_47407((class_2561)PaintingSelectScreen.getTooBigText(paintingData)));
    }

    private void onSearchBoxChanged(String string) {
        if (this.state.getFilters().getSearch().equals(string)) {
            return;
        }
        this.state.getFilters().setSearch(string);
        this.state.updatePaintingList();
    }

    private void onPaintingListSelect(PaintingData paintingData) {
        this.state.setCurrentPainting(paintingData);
    }

    private void saveCurrentSelection() {
        PackData packData = this.state.getCurrentPack();
        PaintingData paintingData = this.state.getCurrentPainting();
        if (packData == null || paintingData == null) {
            this.saveEmpty();
            return;
        }
        this.saveSelection(paintingData);
    }

    private void filterButtonPressed(class_4185 class_41852) {
        Objects.requireNonNull(this.field_22787).method_1507((class_437)new FiltersScreen(this.state));
    }

    private List<class_2561> getInfoLines() {
        PaintingData paintingData = this.state.getCurrentPainting();
        if (paintingData.isEmpty()) {
            return List.of(class_2561.method_43471((String)"custompaintings.painting.none").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)));
        }
        return paintingData.getInfoLines();
    }

    private class_2561 getControlsText() {
        if (this.state.getCurrentPainting().isEmpty()) {
            return class_2561.method_43473();
        }
        PackData packData = this.state.getCurrentPack();
        int n = packData.paintings().indexOf(this.state.getCurrentPainting());
        return class_2561.method_43469((String)"custompaintings.painting.number", (Object[])new Object[]{n + 1, packData.paintings().size()});
    }

    private static class_2561 getTitleText(PaintingEditState paintingEditState) {
        return class_2561.method_43470((String)(paintingEditState.getCurrentPack().name() + " - ")).method_10852((class_2561)class_2561.method_43471((String)"custompaintings.painting.title"));
    }

    private static class_2561 getTooBigText(PaintingData paintingData) {
        return class_2561.method_43469((String)"custompaintings.painting.big", (Object[])new Object[]{paintingData.width(), paintingData.height()});
    }
}

