/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.gui.screen;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.client.gui.widget.VersionStamp;
import me.roundaround.custompaintings.client.registry.CacheManager;
import me.roundaround.custompaintings.config.CustomPaintingsConfig;
import me.roundaround.custompaintings.config.CustomPaintingsPerWorldConfig;
import me.roundaround.custompaintings.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.screen.ThreeSectionLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.screen.ConfigScreen;
import me.roundaround.custompaintings.roundalib.client.gui.util.GuiUtil;
import me.roundaround.custompaintings.roundalib.client.gui.widget.FlowListWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.NarratableEntryListWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.drawable.LabelWidget;
import me.roundaround.custompaintings.util.StringUtil;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7413;

public class CacheScreen
extends class_437 {
    private static final int BUTTON_WIDTH = 120;
    private static final class_2561 LABEL_SERVERS = class_2561.method_43471((String)"custompaintings.cache.servers");
    private static final class_2561 LABEL_IMAGES = class_2561.method_43471((String)"custompaintings.cache.images");
    private static final class_2561 LABEL_SHARED = class_2561.method_43471((String)"custompaintings.cache.shared");
    private static final class_2561 LABEL_BYTES = class_2561.method_43471((String)"custompaintings.cache.bytes");
    private final ThreeSectionLayoutWidget layout = new ThreeSectionLayoutWidget(this);
    private final class_437 parent;

    public CacheScreen(class_437 class_4372) {
        super((class_2561)class_2561.method_43471((String)"custompaintings.cache.title"));
        this.parent = class_4372;
    }

    protected void method_25426() {
        assert (this.field_22787 != null);
        this.layout.addHeader(this.field_22793, this.field_22785);
        StatsList statsList = this.layout.addBody(new StatsList(this.field_22787, this.layout));
        this.fetchStats(statsList, CacheManager.getInstance()::getStats);
        this.layout.addFooter(class_4185.method_46430((class_2561)class_2561.method_43471((String)"custompaintings.cache.clear"), class_41852 -> this.clearCache(statsList)).method_46432(120).method_46431());
        this.layout.addFooter(class_4185.method_46430((class_2561)class_2561.method_43471((String)"custompaintings.cache.configure"), class_41852 -> this.navigateConfig()).method_46432(120).method_46431());
        this.layout.addFooter(class_4185.method_46430((class_2561)class_5244.field_24334, class_41852 -> this.method_25419()).method_46432(120).method_46431());
        VersionStamp.create(this.field_22793, this.layout);
        this.layout.method_48206(class_3642 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)class_3642);
        });
        this.method_48640();
    }

    protected void method_48640() {
        this.layout.method_48222();
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    private void clearCache(StatsList statsList) {
        this.fetchStats(statsList, CacheManager.getInstance()::clear);
    }

    private void fetchStats(StatsList statsList, Supplier<CacheManager.CacheStats> supplier) {
        CompletableFuture.supplyAsync(supplier, (Executor)class_156.method_27958()).orTimeout(30L, TimeUnit.SECONDS).whenCompleteAsync((cacheStats, throwable) -> {
            if (throwable != null || cacheStats == null) {
                if (throwable instanceof TimeoutException) {
                    CustomPaintingsMod.LOGGER.warn("Timeout while loading cache stats:", throwable);
                } else if (throwable != null) {
                    CustomPaintingsMod.LOGGER.warn("Exception raised while loading cache stats:", throwable);
                }
                statsList.setError();
            } else {
                statsList.setStats(cacheStats.servers(), cacheStats.images(), cacheStats.shared(), cacheStats.bytes());
            }
        }, (Executor)this.field_22787);
    }

    private void navigateConfig() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507((class_437)new ConfigScreen((class_437)this, "custompaintings", CustomPaintingsConfig.getInstance(), CustomPaintingsPerWorldConfig.getInstance()));
    }

    private static class StatsList
    extends NarratableEntryListWidget<Entry> {
        public StatsList(class_310 class_3102, ThreeSectionLayoutWidget threeSectionLayoutWidget) {
            super(class_3102, threeSectionLayoutWidget);
            this.setShouldHighlightHover(false);
            this.setShouldHighlightSelection(false);
            this.setAlternatingRowShading(true);
            this.addEntry(LoadingEntry.factory(class_3102.field_1772));
        }

        public void setError() {
            this.clearEntries();
            this.addEntry(ErrorEntry.factory(this.client.field_1772));
            this.method_48222();
        }

        public void setStats(int n, int n2, int n3, long l) {
            this.clearEntries();
            class_2561 class_25612 = class_2561.method_30163((String)String.valueOf(n));
            class_2561 class_25613 = class_2561.method_30163((String)String.valueOf(n2));
            class_2561 class_25614 = class_2561.method_30163((String)String.valueOf(n3));
            class_2561 class_25615 = class_2561.method_30163((String)StringUtil.formatBytes(l));
            int n4 = Stream.of(class_25612, class_25613, class_25615).mapToInt(arg_0 -> ((class_327)this.client.field_1772).method_27525(arg_0)).max().orElse(1);
            this.addEntry(StatEntry.factory(this.client.field_1772, LABEL_SERVERS, class_25612, n4));
            this.addEntry(StatEntry.factory(this.client.field_1772, LABEL_IMAGES, class_25613, n4));
            this.addEntry(StatEntry.factory(this.client.field_1772, LABEL_SHARED, class_25614, n4));
            this.addEntry(StatEntry.factory(this.client.field_1772, LABEL_BYTES, class_25615, n4));
            this.method_48222();
        }

        private static class LoadingEntry
        extends Entry {
            private static final class_2561 LOADING_TEXT = class_2561.method_43471((String)"custompaintings.cache.loading");
            private final class_327 textRenderer;

            protected LoadingEntry(int n, int n2, int n3, int n4, class_327 class_3272) {
                super(n, n2, n3, n4);
                this.textRenderer = class_3272;
            }

            public static FlowListWidget.EntryFactory<LoadingEntry> factory(class_327 class_3272) {
                return (n, n2, n3, n4) -> new LoadingEntry(n, n2, n3, n4, class_3272);
            }

            @Override
            protected void renderContent(class_332 class_3322, int n, int n2, float f) {
                int n3 = this.getContentCenterX() - this.textRenderer.method_27525((class_5348)LOADING_TEXT) / 2;
                int n4 = this.getContentTop();
                int n5 = this.getContentHeight();
                Objects.requireNonNull(this.textRenderer);
                int n6 = n4 + (n5 - 9) / 2;
                class_3322.method_51439(this.textRenderer, LOADING_TEXT, n3, n6, GuiUtil.LABEL_COLOR, false);
                String string = class_7413.method_43449((long)class_156.method_658());
                n3 = this.getContentCenterX() - this.textRenderer.method_1727(string) / 2;
                Objects.requireNonNull(this.textRenderer);
                class_3322.method_51433(this.textRenderer, string, n3, n6 += 9, -8355712, false);
            }

            @Override
            public class_2561 getNarration() {
                return LOADING_TEXT;
            }
        }

        private static class ErrorEntry
        extends Entry {
            private static final class_2561 MESSAGE_LINE_1 = class_2561.method_43471((String)"custompaintings.cache.error1");
            private static final class_2561 MESSAGE_LINE_2 = class_2561.method_43471((String)"custompaintings.cache.error2");
            private final LabelWidget label;

            protected ErrorEntry(int n, int n2, int n3, int n4, class_327 class_3272) {
                super(n, n2, n3, n4);
                this.label = LabelWidget.builder(class_3272, List.of(MESSAGE_LINE_1, MESSAGE_LINE_2)).position(this.getContentCenterX(), this.getContentCenterY()).dimensions(this.getContentWidth(), this.getContentHeight()).alignSelfCenterX().alignSelfCenterY().alignTextCenterX().alignTextCenterY().hideBackground().showShadow().color(-65536).build();
                this.addDrawable(this.label);
            }

            @Override
            public class_2561 getNarration() {
                return this.label.getText();
            }

            public static FlowListWidget.EntryFactory<ErrorEntry> factory(class_327 class_3272) {
                return (n, n2, n3, n4) -> new ErrorEntry(n, n2, n3, n4, class_3272);
            }

            @Override
            public void method_48222() {
                this.label.batchUpdates(() -> {
                    this.label.method_48229(this.getContentCenterX(), this.getContentCenterY());
                    this.label.method_55445(this.getContentWidth(), this.getContentHeight());
                });
            }
        }

        private static class StatEntry
        extends Entry {
            private final class_2561 label;
            private final class_2561 value;

            public StatEntry(int n, int n2, int n3, int n4, class_327 class_3272, class_2561 class_25612, class_2561 class_25613, int n5) {
                super(n, n2, n3, n4);
                this.label = class_25612;
                this.value = class_25613;
                LinearLayoutWidget linearLayoutWidget2 = this.addLayout(LinearLayoutWidget.horizontal().spacing(4).defaultOffAxisContentAlignCenter(), linearLayoutWidget -> linearLayoutWidget.setPositionAndDimensions(this.getContentLeft(), this.getContentTop(), this.getContentWidth(), this.getContentHeight()));
                linearLayoutWidget2.add(LabelWidget.builder(class_3272, this.label).alignTextLeft().hideBackground().showShadow().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(this.getContentWidth() - linearLayoutWidget.getSpacing() - n5));
                linearLayoutWidget2.add(LabelWidget.builder(class_3272, this.value).alignTextRight().hideBackground().showShadow().width(n5).build());
                linearLayoutWidget2.method_48206(class_40682 -> {
                    class_339 cfr_ignored_0 = (class_339)this.addDrawable(class_40682);
                });
            }

            @Override
            public class_2561 getNarration() {
                return this.label.method_27661().method_10852(this.value);
            }

            public static FlowListWidget.EntryFactory<StatEntry> factory(class_327 class_3272, class_2561 class_25612, class_2561 class_25613, int n) {
                return (n2, n3, n4, n5) -> new StatEntry(n2, n3, n4, n5, class_3272, class_25612, class_25613, n);
            }
        }

        private static abstract class Entry
        extends NarratableEntryListWidget.Entry {
            protected Entry(int n, int n2, int n3, int n4) {
                super(n, n2, n3, n4, 11);
            }
        }
    }
}

