/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.roundaround.custompaintings.client.registry.ClientPaintingRegistry;
import me.roundaround.custompaintings.entity.decoration.painting.PaintingData;
import me.roundaround.custompaintings.network.PaintingAssignment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1534;
import net.minecraft.class_156;
import net.minecraft.class_1937;

public class ClientPaintingManager {
    private static final long TTL = 900000L;
    private static ClientPaintingManager instance = null;
    private final HashMap<Integer, PaintingData> cachedData = new HashMap();
    private final HashMap<Integer, Long> expiryTimes = new HashMap();

    private ClientPaintingManager() {
        ClientEntityEvents.ENTITY_LOAD.register((class_12972, class_6382) -> {
            if (!(class_12972 instanceof class_1534)) {
                return;
            }
            class_1534 class_15342 = (class_1534)class_12972;
            int n = class_15342.method_5628();
            PaintingData paintingData = this.cachedData.get(n);
            if (paintingData != null && !paintingData.isEmpty()) {
                this.setPaintingData(class_15342, paintingData);
            }
            this.remove(n);
        });
        ClientEntityEvents.ENTITY_UNLOAD.register((class_12972, class_6382) -> {
            if (!(class_12972 instanceof class_1534)) {
                return;
            }
            class_1534 class_15342 = (class_1534)class_12972;
            class_1297.class_5529 class_55292 = class_15342.method_35049();
            if (class_55292 == class_1297.class_5529.field_26999) {
                this.cacheData(class_15342);
            } else {
                this.remove(class_15342.method_5628());
            }
        });
        ClientTickEvents.START_CLIENT_TICK.register(class_3102 -> {
            long l = class_156.method_659();
            List<Integer> list = this.expiryTimes.entrySet().stream().filter(entry -> l >= (Long)entry.getValue()).map(Map.Entry::getKey).toList();
            list.forEach(this::remove);
        });
    }

    public static void init() {
        ClientPaintingManager clientPaintingManager = ClientPaintingManager.getInstance();
        clientPaintingManager.clear();
    }

    public static ClientPaintingManager getInstance() {
        if (instance == null) {
            instance = new ClientPaintingManager();
        }
        return instance;
    }

    public void trySetPaintingData(class_1937 class_19372, PaintingAssignment paintingAssignment) {
        int n = paintingAssignment.getPaintingId();
        CompletableFuture<PaintingData> completableFuture = paintingAssignment.isKnown() ? ClientPaintingRegistry.getInstance().safeGet(paintingAssignment.getDataId()) : CompletableFuture.completedFuture(paintingAssignment.getData());
        completableFuture.thenAccept(paintingData -> {
            if (paintingData == null || paintingData.isEmpty()) {
                return;
            }
            class_1297 class_12972 = class_19372.method_8469(n);
            if (!(class_12972 instanceof class_1534)) {
                this.cachedData.put(n, (PaintingData)paintingData);
                return;
            }
            class_1534 class_15342 = (class_1534)class_12972;
            this.setPaintingData(class_15342, (PaintingData)paintingData);
        });
    }

    public void clear() {
        this.cachedData.clear();
        this.expiryTimes.clear();
    }

    private void setPaintingData(class_1534 class_15342, PaintingData paintingData) {
        if (paintingData.vanilla()) {
            class_15342.custompaintings$setVariant(paintingData.id());
        }
        class_15342.custompaintings$setData(paintingData);
    }

    private void remove(int n) {
        this.cachedData.remove(n);
        this.expiryTimes.remove(n);
    }

    private void cacheData(class_1534 class_15342) {
        int n = class_15342.method_5628();
        PaintingData paintingData = class_15342.custompaintings$getData();
        if (paintingData != null && !paintingData.isEmpty()) {
            this.cachedData.put(n, paintingData);
            this.expiryTimes.put(n, class_156.method_659() + 900000L);
        }
    }
}

