/*
 * Decompiled with CFR 0.152.
 */
package fuzs.goldenagecombat.handler;

import com.google.common.collect.ImmutableList;
import fuzs.goldenagecombat.GoldenAgeCombat;
import fuzs.goldenagecombat.config.CommonConfig;
import fuzs.goldenagecombat.handler.ToolComponentsHelper;
import fuzs.goldenagecombat.handler.ToolMaterials;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_10590;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5134;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9886;

public class AttackAttributeHandler {
    public static void onFinalizeItemComponents(class_1792 item, Consumer<Function<class_9323, class_9326>> consumer) {
        if (!GoldenAgeCombat.CONFIG.getHolder(CommonConfig.class).isAvailable()) {
            return;
        }
        if (((CommonConfig)GoldenAgeCombat.CONFIG.get(CommonConfig.class)).noItemDurabilityPenalty) {
            consumer.accept(dataComponents -> {
                class_10590 weapon = (class_10590)dataComponents.method_58694(class_9334.field_55878);
                if (weapon != null && weapon.comp_3481() == 2) {
                    return class_9326.method_57841().method_57854(class_9334.field_55878, (Object)new class_10590(1, weapon.comp_3602())).method_57852();
                }
                class_9424 tool = (class_9424)dataComponents.method_58694(class_9334.field_50077);
                if (tool != null && tool.comp_2500() == 2) {
                    return class_9326.method_57841().method_57854(class_9334.field_50077, (Object)new class_9424(tool.comp_2498(), tool.comp_2499(), 1, tool.comp_3480())).method_57852();
                }
                return class_9326.field_49588;
            });
        }
        consumer.accept(dataComponents -> {
            List<class_9285.class_9287> itemAttributeModifiers2;
            List<class_9285.class_9287> itemAttributeModifiers = ((class_9285)dataComponents.method_58695(class_9334.field_49636, (Object)class_9285.field_49326)).comp_2393();
            if (itemAttributeModifiers == (itemAttributeModifiers2 = AttackAttributeHandler.setAttributeValue(item, itemAttributeModifiers, (class_6880<class_1320>)class_5134.field_23721, class_1792.field_8006, ((CommonConfig)GoldenAgeCombat.CONFIG.get(CommonConfig.class)).attackDamageOverrides))) {
                OptionalDouble baseAttackDamage = AttackAttributeHandler.getBaseAttackDamage(dataComponents);
                OptionalDouble attackDamageBonus = AttackAttributeHandler.getAttackDamageBonus(dataComponents);
                if (baseAttackDamage.isPresent() && attackDamageBonus.isPresent()) {
                    itemAttributeModifiers = AttackAttributeHandler.setAttributeValue(itemAttributeModifiers, (class_6880<class_1320>)class_5134.field_23721, class_1792.field_8006, baseAttackDamage.getAsDouble() + attackDamageBonus.getAsDouble());
                }
            } else {
                itemAttributeModifiers = itemAttributeModifiers2;
            }
            if (((class_9285)dataComponents.method_58695(class_9334.field_49636, (Object)class_9285.field_49326)).comp_2393() != itemAttributeModifiers) {
                return class_9326.method_57841().method_57854(class_9334.field_49636, (Object)new class_9285((List)ImmutableList.copyOf(itemAttributeModifiers))).method_57852();
            }
            return class_9326.field_49588;
        });
        if (((CommonConfig)GoldenAgeCombat.CONFIG.get(CommonConfig.class)).removeAttackCooldown) {
            consumer.accept(dataComponents -> {
                List<class_9285.class_9287> itemAttributeModifiers2;
                List itemAttributeModifiers = ((class_9285)dataComponents.method_58695(class_9334.field_49636, (Object)class_9285.field_49326)).comp_2393();
                if (itemAttributeModifiers != (itemAttributeModifiers2 = AttackAttributeHandler.hideAttribute(itemAttributeModifiers, (class_6880<class_1320>)class_5134.field_23723))) {
                    return class_9326.method_57841().method_57854(class_9334.field_49636, (Object)new class_9285((List)ImmutableList.copyOf(itemAttributeModifiers2))).method_57852();
                }
                return class_9326.field_49588;
            });
        }
    }

    private static List<class_9285.class_9287> hideAttribute(List<class_9285.class_9287> itemAttributeModifiers, class_6880<class_1320> holder) {
        for (class_9285.class_9287 entry : itemAttributeModifiers) {
            if (!entry.comp_2395().method_55838(holder)) continue;
            ArrayList<class_9285.class_9287> newItemAttributeModifiers = new ArrayList<class_9285.class_9287>(itemAttributeModifiers);
            ListIterator<class_9285.class_9287> iterator = newItemAttributeModifiers.listIterator();
            while (iterator.hasNext()) {
                class_9285.class_9287 newEntry = (class_9285.class_9287)iterator.next();
                if (!newEntry.comp_2395().method_55838(holder)) continue;
                iterator.set(new class_9285.class_9287(newEntry.comp_2395(), newEntry.comp_2396(), newEntry.comp_2397(), class_9285.class_11193.method_70733()));
            }
            return newItemAttributeModifiers;
        }
        return itemAttributeModifiers;
    }

    private static OptionalDouble getBaseAttackDamage(class_9323 dataComponents) {
        class_9886 toolMaterial = ToolMaterials.getToolMaterial(dataComponents);
        return toolMaterial != null ? OptionalDouble.of(toolMaterial.comp_2933()) : OptionalDouble.empty();
    }

    private static OptionalDouble getAttackDamageBonus(class_9323 dataComponents) {
        if (ToolComponentsHelper.isComponentsForBlocks(dataComponents, (class_6862<class_2248>)class_3481.field_44469)) {
            return OptionalDouble.of(4.0);
        }
        if (ToolComponentsHelper.isComponentsForBlocks(dataComponents, (class_6862<class_2248>)class_3481.field_33713)) {
            return OptionalDouble.of(3.0);
        }
        if (ToolComponentsHelper.isComponentsForBlocks(dataComponents, (class_6862<class_2248>)class_3481.field_33715)) {
            return OptionalDouble.of(2.0);
        }
        if (ToolComponentsHelper.isComponentsForBlocks(dataComponents, (class_6862<class_2248>)class_3481.field_33716)) {
            return OptionalDouble.of(1.0);
        }
        if (ToolComponentsHelper.isComponentsForBlocks(dataComponents, (class_6862<class_2248>)class_3481.field_33714)) {
            return OptionalDouble.of(0.0);
        }
        return OptionalDouble.empty();
    }

    private static List<class_9285.class_9287> setAttributeValue(class_1792 item, List<class_9285.class_9287> itemAttributeModifiers, class_6880<class_1320> attribute, class_2960 id, ConfigDataSet<class_1792> attackDamageOverrides) {
        if (attackDamageOverrides.contains((Object)item)) {
            double newValue = (Double)attackDamageOverrides.getOptional((Object)item, 0).orElseThrow();
            return AttackAttributeHandler.setAttributeValue(itemAttributeModifiers, attribute, id, newValue);
        }
        return itemAttributeModifiers;
    }

    private static List<class_9285.class_9287> setAttributeValue(List<class_9285.class_9287> itemAttributeModifiers, class_6880<class_1320> attribute, class_2960 id, double newValue) {
        itemAttributeModifiers = new ArrayList<class_9285.class_9287>(itemAttributeModifiers);
        class_1322 attributeModifier = new class_1322(id, newValue, class_1322.class_1323.field_6328);
        class_9285.class_9287 newEntry = new class_9285.class_9287(attribute, attributeModifier, class_9274.field_49217);
        ListIterator<class_9285.class_9287> iterator = itemAttributeModifiers.listIterator();
        while (iterator.hasNext()) {
            class_9285.class_9287 entry = iterator.next();
            if (entry.comp_2397() != class_9274.field_49217 || !entry.method_60767(attribute, id)) continue;
            iterator.set(newEntry);
            return itemAttributeModifiers;
        }
        itemAttributeModifiers.add(newEntry);
        return itemAttributeModifiers;
    }
}

