/*
 * Decompiled with CFR 0.152.
 */
package net.fellter.vanillablocksplus.custom_blocks.falling;

import net.minecraft.class_10225;
import net.minecraft.class_1540;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2389;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_247;
import net.minecraft.class_2544;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_4778;
import net.minecraft.class_4970;
import net.minecraft.class_5688;
import net.minecraft.class_5819;
import net.minecraft.class_5945;

public class FallingWallBlock
extends class_2544
implements class_5688 {
    private static final class_265 TALL_POST_SHAPE = FallingWallBlock.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final class_265 TALL_NORTH_SHAPE = FallingWallBlock.method_9541((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final class_265 TALL_SOUTH_SHAPE = FallingWallBlock.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final class_265 TALL_WEST_SHAPE = FallingWallBlock.method_9541((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final class_265 TALL_EAST_SHAPE = FallingWallBlock.method_9541((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public FallingWallBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public void method_10127(class_1937 world, class_2338 pos, class_2680 fallingBlockState, class_2680 currentStateInPos, class_1540 fallingBlockEntity) {
        class_3610 fluidState = world.method_8316(pos);
        class_2338 northPos = pos.method_10095();
        class_2338 eastPos = pos.method_10078();
        class_2338 southPos = pos.method_10072();
        class_2338 westPos = pos.method_10067();
        class_2338 upPos = pos.method_10084();
        class_2680 northState = world.method_8320(northPos);
        class_2680 eastState = world.method_8320(eastPos);
        class_2680 southState = world.method_8320(southPos);
        class_2680 westState = world.method_8320(westPos);
        class_2680 upState = world.method_8320(upPos);
        boolean north = this.shouldConnectTo(northState, northState.method_26206((class_1922)world, northPos, class_2350.field_11035), class_2350.field_11035);
        boolean south = this.shouldConnectTo(eastState, eastState.method_26206((class_1922)world, eastPos, class_2350.field_11039), class_2350.field_11039);
        boolean east = this.shouldConnectTo(southState, southState.method_26206((class_1922)world, southPos, class_2350.field_11043), class_2350.field_11043);
        boolean west = this.shouldConnectTo(westState, westState.method_26206((class_1922)world, westPos, class_2350.field_11034), class_2350.field_11034);
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)field_22160, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        class_2680 newState = this.getStateWith((class_4538)world, state, upPos, upState, north, south, east, west);
        world.method_8501(pos, newState);
    }

    private class_2680 getStateWith(class_4538 world, class_2680 state, class_2338 pos, class_2680 aboveState, boolean north, boolean east, boolean south, boolean west) {
        class_265 voxelShape = aboveState.method_26220((class_1922)world, pos).method_20538(class_2350.field_11033);
        class_2680 blockState = this.getStateWith(state, north, east, south, west, voxelShape);
        return (class_2680)blockState.method_11657((class_2769)field_11717, (Comparable)Boolean.valueOf(this.shouldHavePost(blockState, aboveState, voxelShape)));
    }

    private class_2680 getStateWith(class_2680 state, boolean north, boolean east, boolean south, boolean west, class_265 aboveShape) {
        return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)field_55816, (Comparable)this.getWallShape(north, aboveShape, TALL_NORTH_SHAPE))).method_11657((class_2769)field_55815, (Comparable)this.getWallShape(east, aboveShape, TALL_EAST_SHAPE))).method_11657((class_2769)field_55817, (Comparable)this.getWallShape(south, aboveShape, TALL_SOUTH_SHAPE))).method_11657((class_2769)field_55818, (Comparable)this.getWallShape(west, aboveShape, TALL_WEST_SHAPE));
    }

    private class_4778 getWallShape(boolean connected, class_265 aboveShape, class_265 tallShape) {
        if (connected) {
            if (FallingWallBlock.shouldUseTallShape(aboveShape, tallShape)) {
                return class_4778.field_22180;
            }
            return class_4778.field_22179;
        }
        return class_4778.field_22178;
    }

    private boolean shouldHavePost(class_2680 state, class_2680 aboveState, class_265 aboveShape) {
        boolean allTall;
        boolean shouldHavePost;
        boolean bl;
        boolean bl2 = bl = aboveState.method_26204() instanceof class_2544 && (Boolean)aboveState.method_11654((class_2769)field_11717) != false;
        if (bl) {
            return true;
        }
        class_4778 northShape = (class_4778)state.method_11654((class_2769)field_55816);
        class_4778 southShape = (class_4778)state.method_11654((class_2769)field_55817);
        class_4778 eastShape = (class_4778)state.method_11654((class_2769)field_55815);
        class_4778 westShape = (class_4778)state.method_11654((class_2769)field_55818);
        boolean southDisconnected = southShape == class_4778.field_22178;
        boolean westDisconnected = westShape == class_4778.field_22178;
        boolean eastDisconnected = eastShape == class_4778.field_22178;
        boolean northDisconnected = northShape == class_4778.field_22178;
        boolean bl3 = shouldHavePost = northDisconnected && southDisconnected && westDisconnected && eastDisconnected || northDisconnected != southDisconnected || westDisconnected != eastDisconnected;
        if (shouldHavePost) {
            return true;
        }
        boolean bl4 = allTall = northShape == class_4778.field_22180 && southShape == class_4778.field_22180 || eastShape == class_4778.field_22180 && westShape == class_4778.field_22180;
        if (allTall) {
            return false;
        }
        return aboveState.method_26164(class_3481.field_22276) || FallingWallBlock.shouldUseTallShape(aboveShape, TALL_POST_SHAPE);
    }

    private static boolean shouldUseTallShape(class_265 aboveShape, class_265 tallShape) {
        return !class_259.method_1074((class_265)tallShape, (class_265)aboveShape, (class_247)class_247.field_16886);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        world.method_64310(pos, (class_2248)this, this.getFallDelay());
    }

    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        tickView.method_64310(pos, (class_2248)this, this.getFallDelay());
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!FallingWallBlock.canFallThrough(world.method_8320(pos.method_10074())) || pos.method_10264() < world.method_31607()) {
            return;
        }
        class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)world, (class_2338)pos, (class_2680)state);
        this.configureFallingBlockEntity(fallingBlockEntity);
    }

    protected void configureFallingBlockEntity(class_1540 entity) {
    }

    public boolean shouldConnectTo(class_2680 state, boolean faceFullSquare, class_2350 side) {
        class_2248 block = state.method_26204();
        boolean bl = block instanceof class_2349 && class_2349.method_16703((class_2680)state, (class_2350)side);
        return state.method_26164(class_3481.field_15504) || !FallingWallBlock.method_9581((class_2680)state) && faceFullSquare || block instanceof class_2389 || bl;
    }

    protected int getFallDelay() {
        return 2;
    }

    public static boolean canFallThrough(class_2680 state) {
        return state.method_26215() || state.method_26164(class_3481.field_21952) || state.method_51176() || state.method_45474();
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(16) == 0 && FallingWallBlock.canFallThrough(world.method_8320(pos.method_10074()))) {
            class_5945.method_49099((class_1937)world, (class_2338)pos, (class_5819)random, (class_2394)new class_2388(class_2398.field_11206, state));
        }
    }
}

