/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.block.entity;

import java.util.ArrayList;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.lunade.copper.block.CopperFitting;
import net.lunade.copper.block.CopperPipe;
import net.lunade.copper.block.entity.AbstractSimpleCopperBlockEntity;
import net.lunade.copper.block.entity.CopperFittingEntity;
import net.lunade.copper.block.entity.leaking.LeakingPipeManager;
import net.lunade.copper.block.entity.nbt.MoveablePipeDataHandler;
import net.lunade.copper.block.properties.PipeFluid;
import net.lunade.copper.config.SimpleCopperPipesConfig;
import net.lunade.copper.registry.CopperPipeDispenseBehaviors;
import net.lunade.copper.registry.PipeMovementRestrictions;
import net.lunade.copper.registry.SimpleCopperPipesBlockEntityTypes;
import net.lunade.copper.registry.SimpleCopperPipesBlockStateProperties;
import net.lunade.copper.registry.SimpleCopperPipesSoundEvents;
import net.lunade.copper.tag.SimpleCopperPipesBlockTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3922;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8514;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperPipeEntity
extends AbstractSimpleCopperBlockEntity
implements class_5714.class_8513<class_8514.class_8516>,
class_8514 {
    private static final int VIBRATION_RANGE = 8;
    private static final int MAX_TRANSFER_AMOUNT = 1;
    private final class_8514.class_8516 vibrationListener;
    private final class_8514.class_5719 vibrationUser = this.createVibrationUser();
    public int transferCooldown;
    public int dispenseCooldown;
    public int noteBlockCooldown = 0;
    public boolean canDispense;
    public boolean shootsControlled;
    public boolean shootsSpecial;
    public boolean canAccept;
    public class_2338 inputGameEventPos;
    public class_243 gameEventNbtVec3;
    private class_8514.class_8515 vibrationData = new class_8514.class_8515();

    public CopperPipeEntity(class_2338 blockPos, class_2680 blockState) {
        super(SimpleCopperPipesBlockEntityTypes.COPPER_PIPE_ENTITY, blockPos, blockState, AbstractSimpleCopperBlockEntity.MoveType.FROM_PIPE);
        this.vibrationListener = new class_8514.class_8516((class_8514)this);
    }

    public static boolean canTransfer(class_1937 level, class_2338 pos, boolean to, @NotNull CopperPipeEntity copperPipe, @Nullable Storage<ItemVariant> inventory, @Nullable Storage<ItemVariant> pipeInventory) {
        class_2586 entity;
        if (copperPipe.transferCooldown > 0) {
            return false;
        }
        boolean transferApiCheck = true;
        boolean usingTransferApi = false;
        if (inventory != null) {
            usingTransferApi = true;
            boolean bl = to ? inventory.supportsInsertion() && (pipeInventory == null || pipeInventory.supportsExtraction()) : (transferApiCheck = inventory.supportsExtraction() && (pipeInventory == null || pipeInventory.supportsInsertion()));
        }
        if ((entity = level.method_8321(pos)) != null) {
            PipeMovementRestrictions.CanTakeFrom<class_2586> canTake;
            PipeMovementRestrictions.CanTransferTo<class_2586> canTransfer;
            if (entity instanceof CopperPipeEntity) {
                CopperPipeEntity pipe = (CopperPipeEntity)entity;
                return (to || pipe.transferCooldown <= 0) && transferApiCheck;
            }
            if (entity instanceof CopperFittingEntity) {
                return false;
            }
            if (to ? (canTransfer = PipeMovementRestrictions.getCanTransferTo(entity)) != null : (canTake = PipeMovementRestrictions.getCanTakeFrom(entity)) != null) {
                return canTransfer.canTransfer((class_3218)level, pos, level.method_8320(pos), copperPipe, entity) && transferApiCheck;
            }
        }
        return usingTransferApi && transferApiCheck;
    }

    public static long addItem(ItemVariant resource, @NotNull Storage<ItemVariant> inventory, Transaction transaction) {
        if (inventory.supportsInsertion()) {
            return inventory.insert((Object)resource, 1L, (TransactionContext)transaction);
        }
        return 0L;
    }

    public static void spawnItem(class_1937 level, class_1799 itemStack, int shotLength, @NotNull class_2350 direction, @NotNull class_243 vec3, class_2350 facing) {
        double d = vec3.method_10216();
        double e = vec3.method_10214();
        double f = vec3.method_10215();
        e = direction.method_10166() == class_2350.class_2351.field_11052 ? (e -= 0.125) : (e -= 0.15625);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        class_2350.class_2351 axis = facing.method_10166();
        x = axis == class_2350.class_2351.field_11048 ? (double)(shotLength * facing.method_10148()) * 0.1 : x;
        y = axis == class_2350.class_2351.field_11052 ? (double)(shotLength * facing.method_10164()) * 0.1 : y;
        z = axis == class_2350.class_2351.field_11051 ? (double)(shotLength * facing.method_10165()) * 0.1 : z;
        class_1542 itemEntity = new class_1542(level, d, e, f, itemStack);
        itemEntity.method_18800(x, y, z);
        level.method_8649((class_1297)itemEntity);
    }

    public static void setCooldown(@NotNull class_1937 level, class_2338 blockPos) {
        class_2586 entity = level.method_8321(blockPos);
        class_2680 state = level.method_8320(blockPos);
        if (entity instanceof CopperPipeEntity) {
            CopperPipeEntity pipe = (CopperPipeEntity)entity;
            pipe.setCooldown(state);
        }
    }

    public static Storage<ItemVariant> getStorageAt(class_1937 level, class_2338 blockPos, class_2350 direction) {
        return (Storage)ItemStorage.SIDED.find(level, blockPos, level.method_8320(blockPos), level.method_8321(blockPos), (Object)direction);
    }

    public void method_5447(int i, class_1799 itemStack) {
        this.method_54873(null);
        if (itemStack != null) {
            this.method_11282().set(i, (Object)itemStack);
            if (itemStack.method_7947() > this.method_5444()) {
                itemStack.method_7939(this.method_5444());
            }
        }
    }

    @Override
    public void serverTick(@NotNull class_1937 level, class_2338 blockPos, class_2680 blockState) {
        class_8514.class_8517.method_51406((class_1937)this.field_11863, (class_8514.class_8515)this.method_51298(), (class_8514.class_5719)this.createVibrationUser());
        super.serverTick(level, blockPos, blockState);
        if (!level.field_9236) {
            if (this.noteBlockCooldown > 0) {
                --this.noteBlockCooldown;
            }
            if (this.dispenseCooldown > 0) {
                --this.dispenseCooldown;
            } else {
                this.dispense((class_3218)level, blockPos, blockState);
                int i = 0;
                class_2248 class_22482 = level.method_8320(blockPos.method_10093(((class_2350)blockState.method_11654((class_2769)class_2741.field_12525)).method_10153())).method_26204();
                if (class_22482 instanceof CopperFitting) {
                    CopperFitting fitting = (CopperFitting)class_22482;
                    i = fitting.cooldown;
                } else {
                    class_2248 class_22483 = blockState.method_26204();
                    if (class_22483 instanceof CopperPipe) {
                        CopperPipe pipe = (CopperPipe)class_22483;
                        i = class_3532.method_15357((double)((double)pipe.cooldown * 0.5));
                    }
                }
                this.dispenseCooldown = i;
            }
            if (this.transferCooldown > 0) {
                --this.transferCooldown;
            } else {
                this.pipeMove(level, blockPos, blockState);
            }
            if (blockState.method_11654(SimpleCopperPipesBlockStateProperties.FLUID) == PipeFluid.WATER && blockState.method_11654((class_2769)class_2741.field_12525) != class_2350.field_11036) {
                LeakingPipeManager.addPos(level, blockPos);
            }
        }
    }

    @Override
    public void updateBlockEntityValues(class_1937 level, class_2338 pos, @NotNull class_2680 state) {
        if (state.method_26204() instanceof CopperPipe) {
            boolean canWaterAndLava;
            class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            class_2350 directionOpp = direction.method_10153();
            class_2248 dirBlock = level.method_8320(pos.method_10093(direction)).method_26204();
            class_2680 oppState = level.method_8320(pos.method_10093(directionOpp));
            class_2248 oppBlock = oppState.method_26204();
            this.canDispense = (dirBlock == class_2246.field_10124 || dirBlock == class_2246.field_10382) && oppBlock != class_2246.field_10124 && oppBlock != class_2246.field_10382;
            this.shootsControlled = oppBlock == class_2246.field_10228;
            this.shootsSpecial = oppBlock == class_2246.field_10200;
            this.canAccept = !(oppBlock instanceof CopperPipe) && !(oppBlock instanceof CopperFitting) && !oppState.method_26212((class_1922)level, pos);
            this.canWater = (oppBlock == class_2246.field_10382 || (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false || oppState.method_28498((class_2769)class_2741.field_12508) && (Boolean)oppState.method_11654((class_2769)class_2741.field_12508) != false) && SimpleCopperPipesConfig.get().carryWater;
            this.canLava = oppBlock == class_2246.field_10164 && SimpleCopperPipesConfig.get().carryLava;
            boolean bl = canWaterAndLava = this.canWater && this.canLava;
            boolean bl2 = (oppBlock instanceof class_3922 && !this.canWater && !this.canLava ? (Boolean)oppState.method_11654((class_2769)class_2741.field_12548) != false : canWaterAndLava) && SimpleCopperPipesConfig.get().carrySmoke ? true : (this.canSmoke = false);
            if (canWaterAndLava) {
                this.canWater = false;
                this.canLava = false;
            }
        }
    }

    public void pipeMove(class_1937 level, class_2338 blockPos, @NotNull class_2680 blockState) {
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)class_2741.field_12525);
        boolean bl1 = this.moveOut(level, blockPos, facing);
        int bl2 = this.moveIn(level, blockPos, blockState, facing);
        if (bl1 || bl2 >= 2) {
            this.setCooldown(blockState);
            CopperPipeEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)blockState);
            if (bl2 == 3 && SimpleCopperPipesConfig.get().suctionSounds) {
                level.method_8396(null, blockPos, SimpleCopperPipesSoundEvents.ITEM_IN, class_3419.field_15245, 0.2f, level.field_9229.method_43057() * 0.25f + 0.8f);
            }
        }
    }

    private int moveIn(class_1937 level, @NotNull class_2338 blockPos, class_2680 blockState, @NotNull class_2350 facing) {
        class_2350 opposite = facing.method_10153();
        class_2338 offsetOppPos = blockPos.method_10093(opposite);
        Storage<ItemVariant> inventory = CopperPipeEntity.getStorageAt(level, offsetOppPos, facing);
        Storage<ItemVariant> pipeInventory = CopperPipeEntity.getStorageAt(level, blockPos, opposite);
        if (inventory != null && pipeInventory != null && CopperPipeEntity.canTransfer(level, offsetOppPos, false, this, inventory, pipeInventory)) {
            for (StorageView storageView : inventory) {
                long inserted;
                if (storageView.isResourceBlank() || storageView.getAmount() <= 0L) continue;
                Transaction transaction = Transaction.openOuter();
                ItemVariant resource = (ItemVariant)storageView.getResource();
                long extracted = inventory.extract((Object)resource, 1L, (TransactionContext)transaction);
                if (extracted > 0L && (inserted = CopperPipeEntity.addItem(resource, pipeInventory, transaction)) > 0L) {
                    transaction.commit();
                    if (blockState.method_26164(SimpleCopperPipesBlockTags.SILENT_PIPES)) {
                        return 2;
                    }
                    class_2248 block = level.method_8320(offsetOppPos).method_26204();
                    if (!(block instanceof CopperPipe) && !(block instanceof CopperFitting)) {
                        return 3;
                    }
                    return 2;
                }
                transaction.close();
            }
        }
        return 0;
    }

    private boolean moveOut(class_1937 level, @NotNull class_2338 blockPos, class_2350 facing) {
        class_2338 offsetPos = blockPos.method_10093(facing);
        Storage<ItemVariant> inventory = CopperPipeEntity.getStorageAt(level, offsetPos, facing.method_10153());
        Storage<ItemVariant> pipeInventory = CopperPipeEntity.getStorageAt(level, blockPos, facing);
        if (inventory != null && pipeInventory != null && CopperPipeEntity.canTransfer(level, offsetPos, true, this, inventory, pipeInventory)) {
            boolean canMove = true;
            class_2680 state = level.method_8320(offsetPos);
            if (state.method_26204() instanceof CopperPipe) {
                boolean bl = canMove = state.method_11654((class_2769)class_2741.field_12525) != facing;
            }
            if (!canMove) {
                return false;
            }
            for (StorageView storageView : pipeInventory) {
                long extracted;
                if (storageView.isResourceBlank() || storageView.getAmount() <= 0L) continue;
                Transaction transaction = Transaction.openOuter();
                ItemVariant resource = (ItemVariant)storageView.getResource();
                long inserted = inventory.insert((Object)resource, 1L, (TransactionContext)transaction);
                if (inserted > 0L && (extracted = pipeInventory.extract((Object)resource, 1L, (TransactionContext)transaction)) > 0L) {
                    transaction.commit();
                    return true;
                }
                transaction.close();
            }
        }
        return false;
    }

    private boolean dispense(class_3218 serverLevel, class_2338 blockPos, @NotNull class_2680 blockState) {
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)class_2741.field_12525);
        class_2350 directionOpp = direction.method_10153();
        boolean powered = (Boolean)blockState.method_11654((class_2769)CopperPipe.POWERED);
        if (this.canDispense) {
            class_1799 shotItem;
            int slot = this.chooseNonEmptySlot(serverLevel.field_9229);
            if (slot < 0) {
                return false;
            }
            class_1799 itemStack = this.method_5438(slot);
            if (itemStack.method_7960()) {
                return false;
            }
            int shotLength = 4;
            if (this.shootsControlled) {
                shotLength = 10;
                if (SimpleCopperPipesConfig.get().dispenseSounds) {
                    serverLevel.method_8396(null, blockPos, SimpleCopperPipesSoundEvents.LAUNCH, class_3419.field_15245, 0.2f, serverLevel.field_9229.method_43057() * 0.25f + 0.8f);
                }
            } else if (this.shootsSpecial) {
                class_2248 class_22482 = blockState.method_26204();
                if (class_22482 instanceof CopperPipe) {
                    CopperPipe pipe = (CopperPipe)class_22482;
                    shotLength = pipe.dispenseShotLength;
                    if (SimpleCopperPipesConfig.get().dispenseSounds) {
                        serverLevel.method_8396(null, blockPos, SimpleCopperPipesSoundEvents.LAUNCH, class_3419.field_15245, 0.2f, serverLevel.field_9229.method_43057() * 0.25f + 0.8f);
                    }
                } else {
                    shotLength = 12;
                }
            }
            boolean silent = blockState.method_26164(SimpleCopperPipesBlockTags.SILENT_PIPES);
            if (serverLevel.method_8320(blockPos.method_10093(directionOpp)).method_26204() instanceof CopperFitting) {
                shotItem = this.canonShoot(serverLevel, blockPos, itemStack, blockState, shotLength, powered, true, silent);
            } else {
                shotItem = this.canonShoot(serverLevel, blockPos, itemStack, blockState, shotLength, powered, false, silent);
                serverLevel.method_20290(2010, blockPos, direction.method_10146());
            }
            this.method_5447(slot, shotItem);
            return true;
        }
        return false;
    }

    private class_1799 canonShoot(class_3218 serverLevel, @NotNull class_2338 pos, class_1799 itemStack, @NotNull class_2680 state, int shotLength, boolean powered, boolean fitting, boolean silent) {
        CopperPipeDispenseBehaviors.PoweredDispense poweredDispense;
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        class_243 vec3 = CopperPipe.getOutputLocation(pos, direction);
        class_1799 itemStack2 = itemStack;
        if (powered && (poweredDispense = CopperPipeDispenseBehaviors.getDispense((class_1935)itemStack2.method_7909())) != null) {
            itemStack2 = itemStack.method_7971(1);
            poweredDispense.dispense(serverLevel, itemStack2, shotLength, direction, (class_2374)vec3, state, pos, this);
            if (!fitting && !silent) {
                if (SimpleCopperPipesConfig.get().dispenseSounds) {
                    serverLevel.method_8396(null, pos, SimpleCopperPipesSoundEvents.ITEM_OUT, class_3419.field_15245, 0.2f, serverLevel.field_9229.method_43057() * 0.25f + 0.8f);
                }
                serverLevel.method_33596(null, (class_6880)class_5712.field_28738, pos);
            }
            return itemStack;
        }
        if (SimpleCopperPipesConfig.get().dispensing) {
            itemStack2 = itemStack.method_7971(1);
            serverLevel.method_20290(2000, pos, direction.method_10146());
            CopperPipeEntity.spawnItem((class_1937)serverLevel, itemStack2, shotLength, direction, vec3, direction);
            if (!silent) {
                serverLevel.method_33596(null, (class_6880)class_5712.field_28738, pos);
                if (SimpleCopperPipesConfig.get().dispenseSounds) {
                    serverLevel.method_8396(null, pos, SimpleCopperPipesSoundEvents.ITEM_OUT, class_3419.field_15245, 0.2f, serverLevel.field_9229.method_43057() * 0.25f + 0.8f);
                }
            }
        }
        return itemStack;
    }

    public int chooseNonEmptySlot(class_5819 random) {
        this.method_54873(null);
        int i = -1;
        int j = 1;
        for (int k = 0; k < this.inventory.size(); ++k) {
            if (((class_1799)this.inventory.get(k)).method_7960() || random.method_43048(j++) != 0) continue;
            i = k;
        }
        return i;
    }

    public void setCooldown(@NotNull class_2680 state) {
        int i = 2;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof CopperPipe) {
            CopperPipe pipe = (CopperPipe)class_22482;
            i = pipe.cooldown;
        }
        this.transferCooldown = i;
    }

    @Override
    public void method_11014(class_11368 input) {
        super.method_11014(input);
        this.transferCooldown = input.method_71424("transferCooldown", 0);
        this.dispenseCooldown = input.method_71424("dispenseCooldown", 0);
        this.noteBlockCooldown = input.method_71424("noteBlockCooldown", 0);
        this.canDispense = input.method_71433("canDispense", false);
        this.shootsControlled = input.method_71433("shootsControlled", false);
        this.shootsSpecial = input.method_71433("shootsSpecial", false);
        this.canAccept = input.method_71433("canAccept", false);
        this.vibrationData = input.method_71426("listener", class_8514.class_8515.field_44640).orElseGet(class_8514.class_8515::new);
    }

    @Override
    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71465("transferCooldown", this.transferCooldown);
        output.method_71465("dispenseCooldown", this.dispenseCooldown);
        output.method_71465("noteBlockCooldown", this.noteBlockCooldown);
        output.method_71472("canDispense", this.canDispense);
        output.method_71472("shootsControlled", this.shootsControlled);
        output.method_71472("shootsSpecial", this.shootsSpecial);
        output.method_71472("canAccept", this.canAccept);
        output.method_71468("listener", class_8514.class_8515.field_44640, (Object)this.vibrationData);
    }

    public class_8514.class_5719 createVibrationUser() {
        return new VibrationUser(this.method_11016());
    }

    @NotNull
    public class_8514.class_8515 method_51298() {
        return this.vibrationData;
    }

    @NotNull
    public class_8514.class_5719 method_51299() {
        return this.vibrationUser;
    }

    @NotNull
    public class_8514.class_8516 getListener() {
        return this.vibrationListener;
    }

    @Override
    public boolean canAcceptMoveableNbt(AbstractSimpleCopperBlockEntity.MoveType moveType, class_2350 moveDirection, class_2680 fromState) {
        if (moveType == AbstractSimpleCopperBlockEntity.MoveType.FROM_FITTING) {
            return this.method_11010().method_11654((class_2769)class_2741.field_12525) == moveDirection;
        }
        return this.method_11010().method_11654((class_2769)class_2741.field_12525) == moveDirection || moveDirection == fromState.method_11654((class_2769)class_2741.field_12525);
    }

    @Override
    public boolean canMoveNbtInDirection(class_2350 direction, @NotNull class_2680 state) {
        return direction != ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10153();
    }

    @Override
    public void dispenseMoveableNbt(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState) {
        ArrayList<MoveablePipeDataHandler.SaveableMovablePipeNbt> nbtList;
        if (this.canDispense && !(nbtList = this.moveablePipeDataHandler.getSavedNbtList()).isEmpty()) {
            for (MoveablePipeDataHandler.SaveableMovablePipeNbt nbt : nbtList) {
                if (!nbt.getShouldMove()) continue;
                nbt.dispense(serverLevel, blockPos, blockState, this);
            }
            this.moveMoveableNbt(serverLevel, blockPos, blockState);
        }
    }

    public class VibrationUser
    implements class_8514.class_5719 {
        protected final class_2338 blockPos;
        private final class_5716 positionSource;

        public VibrationUser(class_2338 blockPos) {
            this.blockPos = blockPos;
            this.positionSource = new class_5707(blockPos);
        }

        public int method_49797() {
            return 8;
        }

        @NotNull
        public class_5716 method_51300() {
            return this.positionSource;
        }

        public boolean method_32970(@NotNull class_3218 serverLevel, @NotNull class_2338 blockPos, @NotNull class_6880<class_5712> gameEvent, @Nullable class_5712.class_7397 context) {
            if (SimpleCopperPipesConfig.get().senseGameEvents) {
                boolean placeDestroy;
                boolean bl = placeDestroy = gameEvent == class_5712.field_28165 || gameEvent == class_5712.field_28164;
                if (serverLevel.method_8320(blockPos).method_26204() instanceof CopperPipe || blockPos == CopperPipeEntity.this.method_11016() && placeDestroy) {
                    return false;
                }
                if (CopperPipeEntity.this.canAccept) {
                    CopperPipeEntity.this.moveablePipeDataHandler.addSaveableMoveablePipeNbt(new MoveablePipeDataHandler.SaveableMovablePipeNbt((class_5712)gameEvent.comp_349(), class_243.method_24953((class_2382)blockPos), context, CopperPipeEntity.this.method_11016()).withShouldMove(true).withShouldSave(true));
                    return true;
                }
            }
            return false;
        }

        public void method_32969(@NotNull class_3218 serverLevel, @NotNull class_2338 blockPos, @NotNull class_6880<class_5712> gameEvent, @Nullable class_1297 entity, @Nullable class_1297 entity2, float f) {
        }

        public void method_42672() {
            CopperPipeEntity.this.method_5431();
        }

        public boolean method_51363() {
            return true;
        }
    }
}

