/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.lunade.copper.SimpleCopperPipes;
import net.lunade.copper.block.entity.nbt.MoveablePipeDataHandler;
import net.lunade.copper.block.properties.PipeFluid;
import net.lunade.copper.config.SimpleCopperPipesConfig;
import net.lunade.copper.registry.RegisterPipeNbtMethods;
import net.lunade.copper.registry.SimpleCopperPipesBlockStateProperties;
import net.lunade.copper.tag.SimpleCopperPipesBlockTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1722;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_5955;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractSimpleCopperBlockEntity
extends class_2621
implements class_1263 {
    public final MoveType moveType;
    public class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    public int waterCooldown = -1;
    public int electricityCooldown = -1;
    public boolean canWater;
    public boolean canLava;
    public boolean canSmoke;
    public int lastFixVersion;
    public MoveablePipeDataHandler moveablePipeDataHandler = new MoveablePipeDataHandler();

    public AbstractSimpleCopperBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState, MoveType moveType) {
        super(blockEntityType, blockPos, blockState);
        this.moveType = moveType;
    }

    public static void sendElectricity(class_1937 level, class_2338 blockPos) {
        for (class_2350 direction : class_2350.values()) {
            int axis;
            class_2586 entity;
            class_2680 state;
            class_2338 pos = blockPos.method_10093(direction);
            if (!level.method_22340(pos) || !(state = level.method_8320(pos)).method_28498((class_2769)SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY) || !((entity = level.method_8321(pos)) instanceof AbstractSimpleCopperBlockEntity)) continue;
            AbstractSimpleCopperBlockEntity copperBlockEntity = (AbstractSimpleCopperBlockEntity)entity;
            int n = axis = state.method_28498((class_2769)class_2741.field_12525) ? ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10166().ordinal() : direction.method_10166().ordinal();
            if (copperBlockEntity.electricityCooldown != -1) continue;
            level.method_20290(3002, pos, axis);
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void serverTick(@NotNull class_1937 level, class_2338 blockPos, class_2680 blockState) {
        class_2680 state = blockState;
        if (!level.field_9236) {
            boolean validSmoke;
            if (this.lastFixVersion < 4 || SimpleCopperPipes.REFRESH_VALUES) {
                this.updateBlockEntityValues(level, blockPos, blockState);
                this.lastFixVersion = 4;
            }
            if (this.canWater && !this.canLava && SimpleCopperPipesConfig.get().carryWater) {
                this.moveablePipeDataHandler.setMoveablePipeNbt(RegisterPipeNbtMethods.WATER, new MoveablePipeDataHandler.SaveableMovablePipeNbt().withVec3d(new class_243(11.0, 0.0, 0.0)).withShouldCopy(true).withNBTID(RegisterPipeNbtMethods.WATER));
            }
            if (this.canLava && !this.canWater && SimpleCopperPipesConfig.get().carryLava) {
                this.moveablePipeDataHandler.setMoveablePipeNbt(RegisterPipeNbtMethods.LAVA, new MoveablePipeDataHandler.SaveableMovablePipeNbt().withVec3d(new class_243(11.0, 0.0, 0.0)).withShouldCopy(true).withNBTID(RegisterPipeNbtMethods.LAVA));
            }
            if (this.canSmoke && !this.canWater && !this.canLava || this.canWater && this.canLava && SimpleCopperPipesConfig.get().carrySmoke) {
                this.moveablePipeDataHandler.setMoveablePipeNbt(RegisterPipeNbtMethods.SMOKE, new MoveablePipeDataHandler.SaveableMovablePipeNbt().withVec3d(new class_243(11.0, 0.0, 0.0)).withShouldCopy(true).withNBTID(RegisterPipeNbtMethods.SMOKE));
            }
            MoveablePipeDataHandler.SaveableMovablePipeNbt waterNbt = this.moveablePipeDataHandler.getMoveablePipeNbt(RegisterPipeNbtMethods.WATER);
            MoveablePipeDataHandler.SaveableMovablePipeNbt lavaNbt = this.moveablePipeDataHandler.getMoveablePipeNbt(RegisterPipeNbtMethods.LAVA);
            MoveablePipeDataHandler.SaveableMovablePipeNbt smokeNbt = this.moveablePipeDataHandler.getMoveablePipeNbt(RegisterPipeNbtMethods.SMOKE);
            boolean validWater = this.isValidFluidNBT(waterNbt) && SimpleCopperPipesConfig.get().carryWater;
            boolean validLava = this.isValidFluidNBT(lavaNbt) && SimpleCopperPipesConfig.get().carryLava;
            boolean bl = validSmoke = this.isValidFluidNBT(smokeNbt) && SimpleCopperPipesConfig.get().carrySmoke;
            if (this.canSmoke && (this.canLava && !this.canWater || this.canWater && !this.canLava)) {
                validSmoke = false;
            }
            if (this.canWater && this.canLava) {
                validSmoke = SimpleCopperPipesConfig.get().carrySmoke;
                validWater = false;
                validLava = false;
            }
            if (state.method_28498(SimpleCopperPipesBlockStateProperties.FLUID)) {
                state = (class_2680)state.method_11657(SimpleCopperPipesBlockStateProperties.FLUID, (Comparable)((Object)(validWater ? PipeFluid.WATER : (validLava ? PipeFluid.LAVA : (validSmoke ? PipeFluid.SMOKE : PipeFluid.NONE)))));
            }
            this.tickMoveableNbt((class_3218)level, blockPos, blockState);
            this.dispenseMoveableNbt((class_3218)level, blockPos, blockState);
            this.moveMoveableNbt((class_3218)level, blockPos, blockState);
            if (this.electricityCooldown >= 0) {
                --this.electricityCooldown;
            }
            if (this.electricityCooldown == -1 && ((Boolean)state.method_11654((class_2769)SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY)).booleanValue()) {
                this.electricityCooldown = 80;
                class_2248 stateGetBlock = state.method_26204();
                Optional previous = class_5955.method_34732((class_2248)stateGetBlock);
                if (previous.isPresent() && !state.method_26164(SimpleCopperPipesBlockTags.WAXED)) {
                    state = ((class_2248)previous.get()).method_34725(state);
                }
            }
            if (this.electricityCooldown == 79) {
                AbstractSimpleCopperBlockEntity.sendElectricity(level, blockPos);
            }
            if (this.electricityCooldown == 0 && state.method_28498((class_2769)SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY)) {
                state = (class_2680)state.method_11657((class_2769)SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY, (Comparable)Boolean.valueOf(false));
            }
            if (state != blockState) {
                level.method_8501(blockPos, state);
            }
        }
    }

    public boolean isValidFluidNBT(@Nullable MoveablePipeDataHandler.SaveableMovablePipeNbt fluidNBT) {
        if (fluidNBT != null) {
            return fluidNBT.vec3d.method_10216() > 0.0;
        }
        return false;
    }

    public void updateBlockEntityValues(class_1937 level, class_2338 pos, class_2680 state) {
    }

    public boolean canAcceptMoveableNbt(MoveType moveType, class_2350 moveDirection, class_2680 fromState) {
        return true;
    }

    public boolean canMoveNbtInDirection(class_2350 direction, class_2680 blockState) {
        return true;
    }

    public void tickMoveableNbt(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState) {
        for (MoveablePipeDataHandler.SaveableMovablePipeNbt nbt : (List)this.moveablePipeDataHandler.getSavedNbtList().clone()) {
            nbt.tick(serverLevel, blockPos, blockState, this);
        }
    }

    public void dispenseMoveableNbt(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState) {
    }

    public void moveMoveableNbt(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState) {
        ArrayList<MoveablePipeDataHandler.SaveableMovablePipeNbt> nbtList = this.moveablePipeDataHandler.getSavedNbtList();
        ArrayList<MoveablePipeDataHandler.SaveableMovablePipeNbt> usedNbts = new ArrayList<MoveablePipeDataHandler.SaveableMovablePipeNbt>();
        if (!nbtList.isEmpty()) {
            List dirs = class_156.method_43253((Object[])class_2350.values(), (class_5819)serverLevel.method_8409());
            for (class_2350 direction : dirs) {
                AbstractSimpleCopperBlockEntity copperEntity;
                class_2338 newPos;
                if (!this.canMoveNbtInDirection(direction, blockState) || !serverLevel.method_22340(newPos = blockPos.method_10093(direction))) continue;
                class_2680 state = serverLevel.method_8320(newPos);
                class_2586 entity = serverLevel.method_8321(newPos);
                if (!(entity instanceof AbstractSimpleCopperBlockEntity) || !(copperEntity = (AbstractSimpleCopperBlockEntity)entity).canAcceptMoveableNbt(this.moveType, direction, blockState)) continue;
                for (MoveablePipeDataHandler.SaveableMovablePipeNbt nbt : nbtList) {
                    if (!nbt.getShouldMove() || nbt.getCanOnlyGoThroughOnePipe() && usedNbts.contains(nbt) || !nbt.canMove(serverLevel, newPos, state, copperEntity)) continue;
                    MoveablePipeDataHandler.SaveableMovablePipeNbt onMove = nbt.getShouldCopy() ? nbt.copyOf() : nbt;
                    copperEntity.moveablePipeDataHandler.setMoveablePipeNbt(nbt.getNbtID(), onMove);
                    onMove.onMove(serverLevel, newPos, state, copperEntity);
                    if (usedNbts.contains(nbt)) continue;
                    usedNbts.add(nbt);
                }
            }
            this.moveablePipeDataHandler.clearAllButNonMoveable();
            usedNbts.clear();
            this.method_5431();
        }
    }

    public void method_11014(class_11368 input) {
        super.method_11014(input);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(input)) {
            class_1262.method_5429((class_11368)input, this.inventory);
        }
        this.waterCooldown = input.method_71424("WaterCooldown", 0);
        this.electricityCooldown = input.method_71424("electricityCooldown", 0);
        this.canWater = input.method_71433("canWater", false);
        this.canLava = input.method_71433("canLava", false);
        this.canSmoke = input.method_71433("canSmoke", false);
        this.lastFixVersion = input.method_71424("lastFixVersion", 0);
        this.moveablePipeDataHandler.load(input);
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        if (!this.method_54872(output)) {
            class_1262.method_5426((class_11372)output, this.inventory);
        }
        output.method_71465("WaterCooldown", this.waterCooldown);
        output.method_71465("electricityCooldown", this.electricityCooldown);
        output.method_71472("canWater", this.canWater);
        output.method_71472("canLava", this.canLava);
        output.method_71472("canSmoke", this.canSmoke);
        output.method_71465("lastFixVersion", this.lastFixVersion);
        this.moveablePipeDataHandler.save(output);
    }

    @NotNull
    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> defaultedList) {
        this.inventory = defaultedList;
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_63499());
    }

    @NotNull
    protected class_1703 method_5465(int i, class_1661 playerInventory) {
        return new class_1722(i, playerInventory, (class_1263)this);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public static enum MoveType {
        FROM_PIPE,
        FROM_FITTING;

    }
}

