/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.lunade.copper.block.CopperFitting;
import net.lunade.copper.block.entity.CopperPipeEntity;
import net.lunade.copper.block.entity.leaking.LeakingPipeDripBehaviors;
import net.lunade.copper.block.properties.PipeFluid;
import net.lunade.copper.config.SimpleCopperPipesConfig;
import net.lunade.copper.registry.SimpleCopperPipesBlockEntityTypes;
import net.lunade.copper.registry.SimpleCopperPipesBlockStateProperties;
import net.lunade.copper.registry.SimpleCopperPipesStats;
import net.lunade.copper.tag.SimpleCopperPipesItemTags;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5554;
import net.minecraft.class_5558;
import net.minecraft.class_5714;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_5955;
import net.minecraft.class_6019;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperPipe
extends class_2237
implements class_3737,
class_5955 {
    public static final class_2754<class_2350> FACING = class_2741.field_12525;
    public static final class_2746 FRONT_CONNECTED = SimpleCopperPipesBlockStateProperties.FRONT_CONNECTED;
    public static final class_2746 BACK_CONNECTED = SimpleCopperPipesBlockStateProperties.BACK_CONNECTED;
    public static final class_2746 SMOOTH = SimpleCopperPipesBlockStateProperties.SMOOTH;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<PipeFluid> FLUID = SimpleCopperPipesBlockStateProperties.FLUID;
    public static final class_2746 HAS_ELECTRICITY = SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY;
    private static final class_265 UP_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), (class_265)class_2248.method_9541((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    private static final class_265 DOWN_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0));
    private static final class_265 NORTH_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)16.0), (class_265)class_2248.method_9541((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0));
    private static final class_265 SOUTH_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)14.0), (class_265)class_2248.method_9541((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0));
    private static final class_265 EAST_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0), (class_265)class_2248.method_9541((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
    private static final class_265 WEST_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)2.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (class_265)class_2248.method_9541((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0));
    private static final class_265 DOWN_FRONT = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)-2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (class_265)class_2248.method_9541((double)3.0, (double)-4.0, (double)3.0, (double)13.0, (double)-2.0, (double)13.0));
    private static final class_265 EAST_FRONT = class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)18.0, (double)12.0, (double)12.0), (class_265)class_2248.method_9541((double)18.0, (double)3.0, (double)3.0, (double)20.0, (double)13.0, (double)13.0));
    private static final class_265 NORTH_FRONT = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)4.0, (double)-2.0, (double)12.0, (double)12.0, (double)16.0), (class_265)class_2248.method_9541((double)3.0, (double)3.0, (double)-4.0, (double)13.0, (double)13.0, (double)-2.0));
    private static final class_265 SOUTH_FRONT = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)18.0), (class_265)class_2248.method_9541((double)3.0, (double)3.0, (double)18.0, (double)13.0, (double)13.0, (double)20.0));
    private static final class_265 WEST_FRONT = class_259.method_1084((class_265)class_2248.method_9541((double)-2.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (class_265)class_2248.method_9541((double)-4.0, (double)3.0, (double)3.0, (double)-2.0, (double)13.0, (double)13.0));
    private static final class_265 UP_FRONT = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)18.0, (double)12.0), (class_265)class_2248.method_9541((double)3.0, (double)18.0, (double)3.0, (double)13.0, (double)20.0, (double)13.0));
    private static final class_265 DOWN_BACK = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0), (class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0));
    private static final class_265 EAST_BACK = class_259.method_1084((class_265)class_2248.method_9541((double)-4.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0), (class_265)class_2248.method_9541((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
    private static final class_265 NORTH_BACK = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)20.0), (class_265)class_2248.method_9541((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0));
    private static final class_265 SOUTH_BACK = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)4.0, (double)-4.0, (double)12.0, (double)12.0, (double)14.0), (class_265)class_2248.method_9541((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0));
    private static final class_265 WEST_BACK = class_259.method_1084((class_265)class_2248.method_9541((double)2.0, (double)4.0, (double)4.0, (double)20.0, (double)12.0, (double)12.0), (class_265)class_2248.method_9541((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0));
    private static final class_265 UP_BACK = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)-4.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), (class_265)class_2248.method_9541((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    private static final class_265 DOWN_DOUBLE = class_2248.method_9541((double)4.0, (double)-4.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0);
    private static final class_265 NORTH_DOUBLE = class_2248.method_9541((double)4.0, (double)4.0, (double)-4.0, (double)12.0, (double)12.0, (double)20.0);
    private static final class_265 EAST_DOUBLE = class_2248.method_9541((double)-4.0, (double)4.0, (double)4.0, (double)20.0, (double)12.0, (double)12.0);
    private static final class_265 DOWN_SMOOTH = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 NORTH_SMOOTH = class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    private static final class_265 EAST_SMOOTH = class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final class_265 DOWN_BACK_SMOOTH = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0);
    private static final class_265 NORTH_BACK_SMOOTH = class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)20.0);
    private static final class_265 SOUTH_BACK_SMOOTH = class_2248.method_9541((double)4.0, (double)4.0, (double)-4.0, (double)12.0, (double)12.0, (double)16.0);
    private static final class_265 EAST_BACK_SMOOTH = class_2248.method_9541((double)-4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final class_265 WEST_BACK_SMOOTH = class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)20.0, (double)12.0, (double)12.0);
    private static final class_265 UP_BACK_SMOOTH = class_2248.method_9541((double)4.0, (double)-4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final MapCodec<CopperPipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5955.class_5811.field_46493.fieldOf("weather_state").forGetter(copperPipe -> copperPipe.weatherState), (App)CopperPipe.method_54096(), (App)Codec.INT.fieldOf("cooldown").forGetter(copperPipe -> copperPipe.cooldown), (App)Codec.INT.fieldOf("dispense_shot_length").forGetter(copperPipe -> copperPipe.dispenseShotLength)).apply((Applicative)instance, CopperPipe::new));
    public final int cooldown;
    public final int dispenseShotLength;
    private final class_5955.class_5811 weatherState;

    public CopperPipe(class_5955.class_5811 weatherState, class_4970.class_2251 settings, int cooldown, int dispenseShotLength) {
        super(settings);
        this.weatherState = weatherState;
        this.cooldown = cooldown;
        this.dispenseShotLength = dispenseShotLength;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11033)).method_11657((class_2769)SMOOTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(FLUID, (Comparable)((Object)PipeFluid.NONE))).method_11657((class_2769)HAS_ELECTRICITY, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public CopperPipe(class_4970.class_2251 settings, int cooldown, int dispenseShotLength) {
        this(class_5955.class_5811.field_28704, settings, cooldown, dispenseShotLength);
    }

    public static void updateBlockEntityValues(class_1937 level, class_2338 pos, @NotNull class_2680 state) {
        if (state.method_26204() instanceof CopperPipe) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            class_2680 dirState = level.method_8320(pos.method_10093(direction));
            class_2680 oppState = level.method_8320(pos.method_10093(direction.method_10153()));
            class_2248 oppBlock = oppState.method_26204();
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof CopperPipeEntity) {
                boolean canWaterAndLava;
                CopperPipeEntity pipe = (CopperPipeEntity)class_25862;
                pipe.canDispense = (dirState.method_26215() || dirState.method_26204() == class_2246.field_10382) && !oppState.method_26215() && oppBlock != class_2246.field_10382;
                pipe.shootsControlled = oppBlock == class_2246.field_10228;
                pipe.shootsSpecial = oppBlock == class_2246.field_10200;
                pipe.canAccept = !(oppBlock instanceof CopperPipe) && !(oppBlock instanceof CopperFitting) && !oppState.method_26212((class_1922)level, pos);
                pipe.canWater = (oppBlock == class_2246.field_10382 || (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false || oppState.method_28498((class_2769)class_2741.field_12508) && (Boolean)oppState.method_11654((class_2769)class_2741.field_12508) != false) && SimpleCopperPipesConfig.get().carryWater;
                pipe.canLava = oppBlock == class_2246.field_10164 && SimpleCopperPipesConfig.get().carryLava;
                boolean bl = canWaterAndLava = pipe.canWater && pipe.canLava;
                boolean bl2 = (oppBlock instanceof class_3922 && !pipe.canWater && !pipe.canLava ? (Boolean)oppState.method_11654((class_2769)class_2741.field_12548) != false : canWaterAndLava) && SimpleCopperPipesConfig.get().carrySmoke ? true : (pipe.canSmoke = false);
                if (canWaterAndLava) {
                    pipe.canWater = false;
                    pipe.canLava = false;
                }
            }
        }
    }

    public static boolean canConnectFront(@NotNull class_4538 level, @NotNull class_2338 blockPos, class_2350 direction) {
        class_2680 state = level.method_8320(blockPos.method_10093(direction));
        if (state.method_26204() instanceof CopperPipe) {
            return state.method_11654(FACING) != direction.method_10153() && state.method_11654(FACING) != direction;
        }
        return state.method_26204() instanceof CopperFitting;
    }

    public static boolean canConnectBack(@NotNull class_4538 level, @NotNull class_2338 blockPos, @NotNull class_2350 direction) {
        class_2680 state = level.method_8320(blockPos.method_10093(direction.method_10153()));
        if (state.method_26204() instanceof CopperPipe) {
            return state.method_11654(FACING) != direction.method_10153() && state.method_11654(FACING) != direction;
        }
        return state.method_26204() instanceof CopperFitting;
    }

    public static boolean isSmooth(@NotNull class_4538 level, @NotNull class_2338 blockPos, class_2350 direction) {
        class_2680 state = level.method_8320(blockPos.method_10093(direction));
        if (state.method_26204() instanceof CopperPipe) {
            return state.method_11654(FACING) == direction && !CopperPipe.canConnectFront(level, blockPos, direction);
        }
        return false;
    }

    public static boolean canConnectFront(@NotNull class_1936 level, @NotNull class_2338 blockPos, class_2350 direction) {
        class_2680 state = level.method_8320(blockPos.method_10093(direction));
        if (state.method_26204() instanceof CopperPipe) {
            return state.method_11654(FACING) != direction.method_10153() && state.method_11654(FACING) != direction;
        }
        return state.method_26204() instanceof CopperFitting;
    }

    public static boolean canConnectBack(@NotNull class_1936 level, @NotNull class_2338 blockPos, @NotNull class_2350 direction) {
        class_2680 state = level.method_8320(blockPos.method_10093(direction.method_10153()));
        if (state.method_26204() instanceof CopperPipe) {
            return state.method_11654(FACING) != direction.method_10153() && state.method_11654(FACING) != direction;
        }
        return state.method_26204() instanceof CopperFitting;
    }

    public static boolean isSmooth(@NotNull class_1936 level, @NotNull class_2338 blockPos, class_2350 direction) {
        class_2680 state = level.method_8320(blockPos.method_10093(direction));
        if (state.method_26204() instanceof CopperPipe) {
            return state.method_11654(FACING) == direction && !CopperPipe.canConnectFront(level, blockPos, direction);
        }
        return false;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static class_243 getOutputLocation(@NotNull class_2338 pos, @NotNull class_2350 facing) {
        return new class_243((double)pos.method_10263() + 0.5 + 0.7 * (double)facing.method_10148(), (double)pos.method_10264() + 0.5 + 0.7 * (double)facing.method_10164(), (double)pos.method_10260() + 0.5 + 0.7 * (double)facing.method_10165());
    }

    public static boolean isReceivingRedstonePower(class_2338 blockPos, class_1937 level) {
        for (class_2350 direction : class_2350.values()) {
            if (level.method_49808(blockPos.method_10093(direction), direction) <= 0) continue;
            return true;
        }
        return false;
    }

    public class_265 getPipeShape(class_2680 blockState) {
        boolean front = (Boolean)blockState.method_11654((class_2769)FRONT_CONNECTED);
        boolean back = (Boolean)blockState.method_11654((class_2769)BACK_CONNECTED);
        boolean smooth = (Boolean)blockState.method_11654((class_2769)SMOOTH);
        if (smooth && back) {
            return switch ((class_2350)blockState.method_11654(FACING)) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11033 -> DOWN_BACK_SMOOTH;
                case class_2350.field_11036 -> UP_BACK_SMOOTH;
                case class_2350.field_11043 -> NORTH_BACK_SMOOTH;
                case class_2350.field_11035 -> SOUTH_BACK_SMOOTH;
                case class_2350.field_11034 -> EAST_BACK_SMOOTH;
                case class_2350.field_11039 -> WEST_BACK_SMOOTH;
            };
        }
        if (smooth) {
            return switch ((class_2350)blockState.method_11654(FACING)) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11033, class_2350.field_11036 -> DOWN_SMOOTH;
                case class_2350.field_11043, class_2350.field_11035 -> NORTH_SMOOTH;
                case class_2350.field_11034, class_2350.field_11039 -> EAST_SMOOTH;
            };
        }
        if (front && back) {
            return switch ((class_2350)blockState.method_11654(FACING)) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11033, class_2350.field_11036 -> DOWN_DOUBLE;
                case class_2350.field_11043, class_2350.field_11035 -> NORTH_DOUBLE;
                case class_2350.field_11034, class_2350.field_11039 -> EAST_DOUBLE;
            };
        }
        if (front) {
            return switch ((class_2350)blockState.method_11654(FACING)) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11033 -> DOWN_FRONT;
                case class_2350.field_11036 -> UP_FRONT;
                case class_2350.field_11043 -> NORTH_FRONT;
                case class_2350.field_11035 -> SOUTH_FRONT;
                case class_2350.field_11034 -> EAST_FRONT;
                case class_2350.field_11039 -> WEST_FRONT;
            };
        }
        if (back) {
            return switch ((class_2350)blockState.method_11654(FACING)) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11033 -> DOWN_BACK;
                case class_2350.field_11036 -> UP_BACK;
                case class_2350.field_11043 -> NORTH_BACK;
                case class_2350.field_11035 -> SOUTH_BACK;
                case class_2350.field_11034 -> EAST_BACK;
                case class_2350.field_11039 -> WEST_BACK;
            };
        }
        return switch ((class_2350)blockState.method_11654(FACING)) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> DOWN_SHAPE;
            case class_2350.field_11036 -> UP_SHAPE;
            case class_2350.field_11043 -> NORTH_SHAPE;
            case class_2350.field_11035 -> SOUTH_SHAPE;
            case class_2350.field_11034 -> EAST_SHAPE;
            case class_2350.field_11039 -> WEST_SHAPE;
        };
    }

    @NotNull
    public class_265 method_9530(class_2680 blockState, class_1922 blockView, class_2338 blockPos, class_3726 shapeContext) {
        return this.getPipeShape(blockState);
    }

    @NotNull
    public class_265 method_9584(class_2680 blockState, class_1922 blockView, class_2338 blockPos) {
        return this.getPipeShape(blockState);
    }

    public class_2680 method_9605(@NotNull class_1750 itemPlacementContext) {
        class_2350 direction = itemPlacementContext.method_8038();
        class_2338 blockPos = itemPlacementContext.method_8037();
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)direction)).method_11657((class_2769)FRONT_CONNECTED, (Comparable)Boolean.valueOf(CopperPipe.canConnectFront((class_1936)itemPlacementContext.method_8045(), blockPos, direction)))).method_11657((class_2769)BACK_CONNECTED, (Comparable)Boolean.valueOf(CopperPipe.canConnectBack((class_1936)itemPlacementContext.method_8045(), blockPos, direction)))).method_11657((class_2769)SMOOTH, (Comparable)Boolean.valueOf(CopperPipe.isSmooth((class_1936)itemPlacementContext.method_8045(), blockPos, direction)))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(itemPlacementContext.method_8045().method_8316(blockPos).method_15772() == class_3612.field_15910));
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 randomSource) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        boolean electricity = (Boolean)blockState.method_11654((class_2769)HAS_ELECTRICITY);
        if (neighborState.method_26204() instanceof class_5554 && ((Boolean)neighborState.method_11654((class_2769)POWERED)).booleanValue()) {
            electricity = true;
        }
        class_2350 facing = (class_2350)blockState.method_11654(FACING);
        return (class_2680)((class_2680)((class_2680)((class_2680)blockState.method_11657((class_2769)FRONT_CONNECTED, (Comparable)Boolean.valueOf(CopperPipe.canConnectFront(levelReader, blockPos, facing)))).method_11657((class_2769)BACK_CONNECTED, (Comparable)Boolean.valueOf(CopperPipe.canConnectBack(levelReader, blockPos, facing)))).method_11657((class_2769)SMOOTH, (Comparable)Boolean.valueOf(CopperPipe.isSmooth(levelReader, blockPos, facing)))).method_11657((class_2769)HAS_ELECTRICITY, (Comparable)Boolean.valueOf(electricity));
    }

    protected void method_9612(@NotNull class_2680 blockState, @NotNull class_1937 level, class_2338 blockPos, class_2248 block, @Nullable class_9904 orientation, boolean bl) {
        boolean powered = CopperPipe.isReceivingRedstonePower(blockPos, level);
        if (powered != (Boolean)blockState.method_11654((class_2769)POWERED)) {
            level.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)));
        }
        CopperPipe.updateBlockEntityValues(level, blockPos, blockState);
    }

    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new CopperPipeEntity(blockPos, blockState);
    }

    protected boolean method_9579(@NotNull class_2680 blockState) {
        return blockState.method_26227().method_15769();
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        if (!level.field_9236) {
            return CopperPipe.method_31618(blockEntityType, SimpleCopperPipesBlockEntityTypes.COPPER_PIPE_ENTITY, (level1, blockPos, blockState1, copperPipeEntity) -> copperPipeEntity.serverTick(level1, blockPos, blockState1));
        }
        return null;
    }

    @Nullable
    public <T extends class_2586> class_5714 method_32896(class_3218 serverLevel, T blockEntity) {
        if (blockEntity instanceof CopperPipeEntity) {
            CopperPipeEntity pipeEntity = (CopperPipeEntity)blockEntity;
            return pipeEntity.getListener();
        }
        return null;
    }

    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1309 livingEntity, @NotNull class_1799 itemStack) {
        super.method_9567(level, blockPos, blockState, livingEntity, itemStack);
        CopperPipe.updateBlockEntityValues(level, blockPos, blockState);
    }

    @NotNull
    public class_3610 method_9545(@NotNull class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(blockState);
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, @NotNull class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof CopperPipeEntity) {
            CopperPipeEntity copperPipeEntity = (CopperPipeEntity)blockEntity;
            player.method_17355((class_3908)copperPipeEntity);
            player.method_7259(class_3468.field_15419.method_14956((Object)SimpleCopperPipesStats.INSPECT_PIPE));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @NotNull
    protected class_1269 method_55765(@NotNull class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (stack.method_31573(SimpleCopperPipesItemTags.IGNORES_COPPER_PIPE_MENU)) {
            return class_1269.field_5811;
        }
        return class_1269.field_52423;
    }

    @NotNull
    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public boolean method_9498(class_2680 blockState) {
        return true;
    }

    public int method_9572(class_2680 blockState, @NotNull class_1937 level, class_2338 blockPos) {
        return class_1703.method_7608((class_2586)level.method_8321(blockPos));
    }

    @NotNull
    public class_2680 method_9598(@NotNull class_2680 blockState, @NotNull class_2470 blockRotation) {
        return (class_2680)blockState.method_11657(FACING, (Comparable)blockRotation.method_10503((class_2350)blockState.method_11654(FACING)));
    }

    @NotNull
    public class_2680 method_9569(@NotNull class_2680 blockState, @NotNull class_2415 blockMirror) {
        return blockState.method_26186(blockMirror.method_10345((class_2350)blockState.method_11654(FACING)));
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, FRONT_CONNECTED, BACK_CONNECTED, SMOOTH, WATERLOGGED, FLUID, HAS_ELECTRICITY, POWERED});
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public void method_9514(@NotNull class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        boolean isLava;
        class_2350 direction = (class_2350)blockState.method_11654(FACING);
        boolean bl = isLava = blockState.method_11654(FLUID) == PipeFluid.LAVA;
        if (blockState.method_11654(FLUID) == PipeFluid.WATER || isLava && direction != class_2350.field_11036) {
            float f = random.method_43057();
            float f2 = isLava ? 0.05859375f : 0.17578125f;
            if (f <= f2 * 2.0f) {
                class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
                boolean hasOffset = false;
                for (int i = 0; i < 12; ++i) {
                    if (direction != class_2350.field_11033 && !hasOffset) {
                        mutableBlockPos.method_10098(direction);
                        hasOffset = true;
                    }
                    mutableBlockPos.method_10098(class_2350.field_11033);
                    class_2680 state = serverLevel.method_8320((class_2338)mutableBlockPos);
                    if (!serverLevel.method_8316((class_2338)mutableBlockPos).method_15769()) break;
                    LeakingPipeDripBehaviors.DripOn dripOn = LeakingPipeDripBehaviors.getDrip(state.method_26204());
                    if (dripOn != null) {
                        dripOn.dripOn(isLava, serverLevel, (class_2338)mutableBlockPos, state);
                        break;
                    }
                    if (state.method_26220((class_1922)serverLevel, (class_2338)mutableBlockPos) != class_259.method_1073()) break;
                }
            }
        }
        this.method_54764(blockState, serverLevel, blockPos, random);
    }

    public boolean method_9542(@NotNull class_2680 blockState) {
        return class_5955.method_34737((class_2248)blockState.method_26204()).isPresent() || blockState.method_11654(FLUID) == PipeFluid.WATER || blockState.method_11654(FLUID) == PipeFluid.LAVA;
    }

    public void method_9496(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, class_5819 random) {
        boolean hasSmokeOrWaterOrLava;
        class_2350 direction = (class_2350)blockState.method_11654(FACING);
        class_2338 offsetPos = blockPos.method_10093(direction);
        class_2680 offsetState = level.method_8320(offsetPos);
        class_3610 fluidState = offsetState.method_26227();
        boolean canWater = blockState.method_11654(FLUID) == PipeFluid.WATER && direction != class_2350.field_11036;
        boolean canLava = blockState.method_11654(FLUID) == PipeFluid.LAVA && random.method_43048(2) == 0 && direction != class_2350.field_11036;
        boolean canSmoke = blockState.method_11654(FLUID) == PipeFluid.SMOKE && random.method_43048(5) == 0;
        boolean canWaterOrLava = canWater || canLava;
        boolean bl = hasSmokeOrWaterOrLava = canWaterOrLava || canSmoke;
        if (hasSmokeOrWaterOrLava) {
            double outX = (double)blockPos.method_10263() + this.getDripX(direction, random);
            double outY = (double)blockPos.method_10264() + this.getDripY(direction, random);
            double outZ = (double)blockPos.method_10260() + this.getDripZ(direction, random);
            if (canWaterOrLava && (fluidState.method_15769() || (double)fluidState.method_15763((class_1922)level, offsetPos) + (double)offsetPos.method_10264() < outY)) {
                level.method_8406((class_2394)(canWater ? class_2398.field_11232 : class_2398.field_11223), outX, outY, outZ, 0.0, 0.0, 0.0);
            }
            if (canSmoke) {
                level.method_8406((class_2394)class_2398.field_17430, outX, outY, outZ, 0.0, 0.07, 0.0);
            }
            if (!offsetState.method_26215() && fluidState.method_15769()) {
                double x = (double)blockPos.method_10263() + this.getDripX(direction, random);
                double y = (double)blockPos.method_10264() + this.getDripY(direction, random);
                double z = (double)blockPos.method_10260() + this.getDripZ(direction, random);
                if (canWaterOrLava && direction == class_2350.field_11033) {
                    level.method_8406((class_2394)(canWater ? class_2398.field_11232 : class_2398.field_11223), x, outY, z, 0.0, 0.0, 0.0);
                }
                if (canSmoke && direction == class_2350.field_11036) {
                    level.method_8406((class_2394)class_2398.field_17430, x, y, z, 0.0, 0.07, 0.0);
                }
            }
        }
        if (((Boolean)blockState.method_11654((class_2769)HAS_ELECTRICITY)).booleanValue()) {
            class_5945.method_34683((class_2350.class_2351)direction.method_10166(), (class_1937)level, (class_2338)blockPos, (double)0.4, (class_2394)class_2398.field_29644, (class_6019)class_6019.method_35017((int)1, (int)2));
        }
        if (fluidState.method_15767(class_3486.field_15517) && (random.method_43057() <= 0.1f || offsetState.method_26220((class_1922)level, offsetPos).method_1110())) {
            level.method_8406((class_2394)class_2398.field_11247, (double)blockPos.method_10263() + this.getDripX(direction, random), (double)blockPos.method_10264() + this.getDripY(direction, random), (double)blockPos.method_10260() + this.getDripZ(direction, random), (double)direction.method_10148() * 0.7, (double)direction.method_10164() * 0.7, (double)direction.method_10165() * 0.7);
            if ((canLava || canSmoke) && random.method_43048(2) == 0) {
                level.method_8406((class_2394)class_2398.field_11251, (double)blockPos.method_10263() + this.getDripX(direction, random), (double)blockPos.method_10264() + this.getDripY(direction, random), (double)blockPos.method_10260() + this.getDripZ(direction, random), (double)direction.method_10148() * 0.05, (double)direction.method_10164() * 0.05, (double)direction.method_10165() * 0.05);
            }
        }
    }

    public double getRan(class_5819 random) {
        return (double)class_6019.method_35017((int)-25, (int)25).method_35008(random) * 0.01;
    }

    public double getDripX(@NotNull class_2350 direction, class_5819 random) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033, class_2350.field_11043, class_2350.field_11035 -> 0.5 + this.getRan(random);
            case class_2350.field_11036 -> 0.5;
            case class_2350.field_11034 -> 1.05;
            case class_2350.field_11039 -> -0.05;
        };
    }

    public double getDripY(@NotNull class_2350 direction, class_5819 random) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> -0.05;
            case class_2350.field_11036 -> 1.05;
            case class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039 -> 0.4375 + class_3532.method_15350((double)this.getRan(random), (double)-2.0, (double)0.625);
        };
    }

    public double getDripZ(@NotNull class_2350 direction, class_5819 random) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033, class_2350.field_11034, class_2350.field_11039 -> 0.5 + this.getRan(random);
            case class_2350.field_11036 -> 0.5;
            case class_2350.field_11043 -> -0.05;
            case class_2350.field_11035 -> 1.05;
        };
    }

    @NotNull
    public class_5955.class_5811 getAge() {
        return this.weatherState;
    }

    protected void method_66388(class_2680 blockState, class_3218 level, class_2338 blockPos, boolean bl) {
        CopperPipe.updateBlockEntityValues((class_1937)level, blockPos, blockState);
        class_1264.method_66221((class_2680)blockState, (class_1937)level, (class_2338)blockPos);
    }

    @NotNull
    protected MapCodec<? extends CopperPipe> method_53969() {
        return CODEC;
    }
}

