/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.lunade.copper.block.entity.CopperFittingEntity;
import net.lunade.copper.block.properties.PipeFluid;
import net.lunade.copper.config.SimpleCopperPipesConfig;
import net.lunade.copper.registry.SimpleCopperPipesBlockEntityTypes;
import net.lunade.copper.registry.SimpleCopperPipesBlockStateProperties;
import net.lunade.copper.registry.SimpleCopperPipesStats;
import net.lunade.copper.tag.SimpleCopperPipesItemTags;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5554;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_5955;
import net.minecraft.class_6019;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperFitting
extends class_2237
implements class_3737,
class_5955 {
    public static final MapCodec<CopperFitting> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5955.class_5811.field_46493.fieldOf("weather_state").forGetter(copperFitting -> copperFitting.weatherState), (App)CopperFitting.method_54096(), (App)Codec.INT.fieldOf("cooldown").forGetter(copperFitting -> copperFitting.cooldown)).apply((Applicative)instance, CopperFitting::new));
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<PipeFluid> FLUID = SimpleCopperPipesBlockStateProperties.FLUID;
    public static final class_2746 HAS_ELECTRICITY = SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY;
    private static final class_265 FITTING_SHAPE = class_2248.method_9541((double)2.5, (double)2.5, (double)2.5, (double)13.5, (double)13.5, (double)13.5);
    public final int cooldown;
    private final class_5955.class_5811 weatherState;

    public CopperFitting(class_5955.class_5811 weatherState, class_4970.class_2251 settings, int cooldown) {
        super(settings);
        this.weatherState = weatherState;
        this.cooldown = cooldown;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(FLUID, (Comparable)((Object)PipeFluid.NONE))).method_11657((class_2769)HAS_ELECTRICITY, (Comparable)Boolean.valueOf(false)));
    }

    public CopperFitting(class_4970.class_2251 settings, int cooldown) {
        this(class_5955.class_5811.field_28704, settings, cooldown);
    }

    public static void updateBlockEntityValues(class_1937 level, class_2338 pos, @NotNull class_2680 state) {
        class_2586 entity;
        if (state.method_26204() instanceof CopperFitting && (entity = level.method_8321(pos)) instanceof CopperFittingEntity) {
            CopperFittingEntity fitting = (CopperFittingEntity)entity;
            fitting.canWater = (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false && SimpleCopperPipesConfig.get().carryWater;
        }
    }

    @NotNull
    public class_265 method_9530(class_2680 blockState, class_1922 blockView, class_2338 blockPos, class_3726 shapeContext) {
        return FITTING_SHAPE;
    }

    @NotNull
    public class_265 method_9584(class_2680 blockState, class_1922 blockView, class_2338 blockPos) {
        return FITTING_SHAPE;
    }

    public class_2680 method_9605(@NotNull class_1750 itemPlacementContext) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(itemPlacementContext.method_8045().method_8316(itemPlacementContext.method_8037()).method_15772() == class_3612.field_15910))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(itemPlacementContext.method_8045().method_49803(itemPlacementContext.method_8037())));
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 randomSource) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        boolean electricity = (Boolean)blockState.method_11654((class_2769)HAS_ELECTRICITY);
        if (neighborState.method_26204() instanceof class_5554 && ((Boolean)neighborState.method_11654((class_2769)POWERED)).booleanValue()) {
            electricity = true;
        }
        return (class_2680)blockState.method_11657((class_2769)HAS_ELECTRICITY, (Comparable)Boolean.valueOf(electricity));
    }

    protected void method_9612(@NotNull class_2680 blockState, @NotNull class_1937 level, class_2338 blockPos, class_2248 block, @Nullable class_9904 orientation, boolean bl) {
        level.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(level.method_49803(blockPos))));
        CopperFitting.updateBlockEntityValues(level, blockPos, blockState);
    }

    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new CopperFittingEntity(blockPos, blockState);
    }

    protected boolean method_9579(@NotNull class_2680 blockState) {
        return blockState.method_26227().method_15769();
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        if (!level.field_9236) {
            return CopperFitting.method_31618(blockEntityType, SimpleCopperPipesBlockEntityTypes.COPPER_FITTING_ENTITY, (level1, blockPos, blockState1, copperFittingEntity) -> copperFittingEntity.serverTick(level1, blockPos, blockState1));
        }
        return null;
    }

    public void method_9567(@NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2680 blockState, class_1309 livingEntity, @NotNull class_1799 itemStack) {
        super.method_9567(level, blockPos, blockState, livingEntity, itemStack);
        CopperFitting.updateBlockEntityValues(level, blockPos, blockState);
    }

    @NotNull
    public class_3610 method_9545(@NotNull class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(blockState);
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        if (!SimpleCopperPipesConfig.get().openableFittings) {
            return super.method_55766(state, level, pos, player, hitResult);
        }
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof CopperFittingEntity) {
            CopperFittingEntity fittingEntity = (CopperFittingEntity)blockEntity;
            player.method_17355((class_3908)fittingEntity);
            player.method_7259(class_3468.field_15419.method_14956((Object)SimpleCopperPipesStats.INSPECT_FITTING));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @NotNull
    protected class_1269 method_55765(@NotNull class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (stack.method_31573(SimpleCopperPipesItemTags.IGNORES_COPPER_PIPE_MENU)) {
            return class_1269.field_5811;
        }
        return class_1269.field_52423;
    }

    @NotNull
    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public boolean method_9498(class_2680 blockState) {
        return true;
    }

    public int method_9572(class_2680 blockState, @NotNull class_1937 level, class_2338 blockPos) {
        return class_1703.method_7608((class_2586)level.method_8321(blockPos));
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, POWERED, FLUID, HAS_ELECTRICITY});
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        this.method_54764(blockState, serverLevel, blockPos, random);
    }

    public boolean method_9542(@NotNull class_2680 blockState) {
        return class_5955.method_34737((class_2248)blockState.method_26204()).isPresent();
    }

    protected void method_66388(class_2680 blockState, class_3218 level, class_2338 blockPos, boolean bl) {
        CopperFitting.updateBlockEntityValues((class_1937)level, blockPos, blockState);
        class_1264.method_66221((class_2680)blockState, (class_1937)level, (class_2338)blockPos);
    }

    public void method_9496(@NotNull class_2680 blockState, class_1937 level, class_2338 blockPos, class_5819 random) {
        if (((Boolean)blockState.method_11654((class_2769)HAS_ELECTRICITY)).booleanValue()) {
            class_5945.method_34683((class_2350.class_2351)class_2350.field_11036.method_10166(), (class_1937)level, (class_2338)blockPos, (double)0.55, (class_2394)class_2398.field_29644, (class_6019)class_6019.method_35017((int)1, (int)2));
        }
    }

    @NotNull
    public class_5955.class_5811 getAge() {
        return this.weatherState;
    }

    @NotNull
    protected MapCodec<? extends CopperFitting> method_53969() {
        return CODEC;
    }
}

