/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9848;

public class ExperienceDisplayEntry
extends DisplayEntry {
    private static final class_2960 EXPERIENCE_ORB_TEXTURES = ResourceLocationHelper.withDefaultNamespace((String)"textures/entity/experience_orb.png");
    private final class_2561 name;
    private int ageInTicks;

    public ExperienceDisplayEntry(class_2561 name, int amount) {
        super(amount, class_1814.field_8907);
        this.name = name;
    }

    @Override
    public void tick() {
        super.tick();
        ++this.ageInTicks;
    }

    @Override
    protected class_2561 getEntryName() {
        return this.name;
    }

    @Override
    public boolean mayMergeWith(DisplayEntry other, boolean excludeNamed) {
        return other instanceof ExperienceDisplayEntry;
    }

    @Override
    protected int getInventoryCount(class_1661 inventory) {
        return 0;
    }

    @Override
    protected void renderSprite(class_332 guiGraphics, class_327 font, int posX, int posY, float scale, float fadeTime) {
        int textureOffset = ExperienceDisplayEntry.getXpTexture(this.getDisplayAmount());
        int textureX = textureOffset % 4 * 16;
        int textureY = textureOffset / 4 * 16;
        int textureColor = ExperienceDisplayEntry.getExperienceOrbColor((float)this.ageInTicks / 2.0f, class_9848.method_61326((float)fadeTime));
        guiGraphics.method_25293(class_10799.field_56883, EXPERIENCE_ORB_TEXTURES, posX, posY, (float)textureX, (float)textureY, 16, 16, 16, 16, 64, 64, textureColor);
    }

    static int getExperienceOrbColor(float ageInTicks, int alpha) {
        int red = class_9848.method_61326((float)((class_3532.method_15374((float)ageInTicks) + 1.0f) * 0.5f));
        int green = 255;
        int blue = class_9848.method_61326((float)((class_3532.method_15374((float)(ageInTicks + 4.1887903f)) + 1.0f) * 0.1f));
        return class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue);
    }

    static int getXpTexture(int displayCount) {
        if (displayCount >= 2477) {
            return 10;
        }
        if (displayCount >= 1237) {
            return 9;
        }
        if (displayCount >= 617) {
            return 8;
        }
        if (displayCount >= 307) {
            return 7;
        }
        if (displayCount >= 149) {
            return 6;
        }
        if (displayCount >= 73) {
            return 5;
        }
        if (displayCount >= 37) {
            return 4;
        }
        if (displayCount >= 17) {
            return 3;
        }
        if (displayCount >= 7) {
            return 2;
        }
        if (displayCount >= 3) {
            return 1;
        }
        return 0;
    }
}

