/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.client.gui;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_2457;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_8710;
import net.minecraft.class_9848;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.ClientCircuit;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.Components;
import net.replaceitem.integratedcircuit.circuit.components.FacingComponent;
import net.replaceitem.integratedcircuit.circuit.components.PortComponent;
import net.replaceitem.integratedcircuit.client.config.DefaultConfig;
import net.replaceitem.integratedcircuit.client.gui.widget.ToolSelectionInfo;
import net.replaceitem.integratedcircuit.client.gui.widget.Toolbox;
import net.replaceitem.integratedcircuit.network.packet.FinishEditingC2SPacket;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class IntegratedCircuitScreen
extends class_437 {
    public static final class_2960 BACKGROUND_TEXTURE = IntegratedCircuit.id("textures/gui/container/integrated_circuit.png");
    protected static final int BACKGROUND_WIDTH = 302;
    protected static final int BACKGROUND_HEIGHT = 250;
    public static final int COMPONENT_SIZE = 16;
    public static final int RENDER_COMPONENT_SIZE = 12;
    private static final float RENDER_SCALE = 0.75f;
    private static final int TITLE_X = 8;
    private static final int TITLE_Y = 9;
    private static final int GRID_X = 101;
    private static final int GRID_Y = 36;
    private static final int CIRCUIT_NAME_TEXTBOX_X = 153;
    private static final int CIRCUIT_NAME_TEXTBOX_Y = 9;
    private static final int CIRCUIT_NAME_TEXTBOX_WIDTH = 132;
    private static final int CIRCUIT_NAME_TEXTBOX_HEIGHT = 12;
    private static final int TOOLBOX_X = 8;
    private static final int TOOLBOX_Y = 24;
    private static final int STATUSBAR_X = 89;
    private static final int STATUSBAR_Y = 234;
    private static final int STATUSBAR_RIGHT_MARGIN = 8;
    private boolean startedDraggingInside = false;
    protected int x;
    protected int y;
    protected int titleX;
    protected int titleY;
    protected Toolbox toolbox;
    protected class_342 customNameTextField;
    protected class_2561 customName;
    protected final ClientCircuit circuit;
    private FlatDirection cursorRotation = FlatDirection.NORTH;
    @Nullable
    private ComponentState cursorState = null;

    public IntegratedCircuitScreen(ClientCircuit circuit, class_2561 customName) {
        super((class_2561)class_2561.method_43471((String)"integrated_circuit.gui.screen_title"));
        this.circuit = circuit;
        this.customName = customName;
    }

    protected void method_25426() {
        this.x = (this.field_22789 - 302) / 2;
        this.y = (this.field_22790 - 250) / 2;
        this.titleX = this.x + 8;
        this.titleY = this.y + 9;
        this.toolbox = new Toolbox(this, 8, 24);
        this.toolbox.init();
        this.toolbox.registerToolSelectionSubscriber(this::updateToolSelection);
        this.customNameTextField = new class_342(this.field_22793, this.x + 153, this.y + 9, 132, 12, this.customName){

            public void method_25365(boolean focused) {
                super.method_25365(focused);
                if (!focused) {
                    IntegratedCircuitScreen.this.circuit.rename(IntegratedCircuitScreen.this.customName);
                }
            }
        };
        this.customNameTextField.method_1858(false);
        this.customNameTextField.method_1880(50);
        this.customNameTextField.method_1888(true);
        this.customNameTextField.method_1852(this.customName.getString());
        this.customNameTextField.method_47404((class_2561)class_2561.method_43471((String)"integrated_circuit.gui.rename_field_placeholder").method_27694(style -> style.method_36139(0x9C9C9C).method_65302(0x22222222)));
        this.customNameTextField.method_1863(name -> {
            this.customName = class_2561.method_43470((String)name);
        });
        this.method_25429((class_364)this.customNameTextField);
        this.method_37063(this.customNameTextField);
    }

    public void updateToolSelection(ToolSelectionInfo selectionInfo) {
        this.updateCursorState(selectionInfo.component());
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        ClientPlayNetworking.send((class_8710)new FinishEditingC2SPacket(this.circuit.getContext().getBlockPos()));
        super.method_25419();
    }

    public ClientCircuit getClientCircuit() {
        return this.circuit;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(drawContext, mouseX, mouseY, delta);
        drawContext.method_51439(this.field_22793, this.field_22785, this.titleX, this.titleY, 0x404040, false);
        this.renderStatusBar(drawContext, mouseX, mouseY);
        this.renderContent(drawContext);
        this.renderCursorState(drawContext, mouseX, mouseY);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        context.method_25290(class_10799.field_56883, BACKGROUND_TEXTURE, this.x, this.y, 0.0f, 0.0f, 302, 250, 512, 512);
    }

    private void renderStatusBar(class_332 drawContext, int mouseX, int mouseY) {
        ComponentPos pos = this.getComponentPosAt(mouseX, mouseY);
        ComponentState componentState = this.circuit.getComponentState(pos);
        Component component = componentState.getComponent();
        int gridX = this.getGridXAt(mouseX);
        int gridY = this.getGridYAt(mouseY);
        class_2561 leftSideText = null;
        class_2561 rightSideText = null;
        if (this.circuit.isInside(pos)) {
            String componentName = component != Components.AIR ? component.getName().getString() : "";
            leftSideText = class_2561.method_43470((String)String.format("(%d, %d) %s", gridX, gridY, componentName));
        } else {
            Component component2 = componentState.getComponent();
            if (component2 instanceof PortComponent) {
                PortComponent portComponent = (PortComponent)component2;
                leftSideText = portComponent.getName();
            }
        }
        if (component != Components.AIR) {
            rightSideText = componentState.getHoverInfoText();
        }
        if (leftSideText != null) {
            drawContext.method_51439(this.field_22793, leftSideText, this.x + 89, this.y + 234, 0x404040, false);
        }
        if (rightSideText != null) {
            int componentInfoWidth = this.field_22793.method_27525((class_5348)rightSideText);
            drawContext.method_51439(this.field_22793, rightSideText, this.x + 302 - componentInfoWidth - 8, this.y + 234, 0x404040, false);
        }
    }

    public static class_2561 getSignalStrengthText(int signalStrength) {
        int color = class_2457.method_10487((int)signalStrength);
        return class_2561.method_43470((String)String.valueOf(signalStrength)).method_27694(style -> style.method_36139(color));
    }

    private void renderCursorState(class_332 drawContext, int mouseX, int mouseY) {
        float a;
        ComponentPos pos = this.getComponentPosAt(mouseX, mouseY);
        boolean validSpot = this.circuit.getComponentState(pos).isAir();
        float f = a = validSpot ? 0.5f : 0.2f;
        if (this.cursorState != null && this.circuit.isInside(pos)) {
            drawContext.method_51448().pushMatrix();
            drawContext.method_51448().translate((float)this.getGridPosX(0), (float)this.getGridPosY(0));
            drawContext.method_51448().scale(0.75f, 0.75f);
            this.renderComponentStateInGrid(drawContext, this.cursorState, pos.method_10263(), pos.method_10264(), a);
            drawContext.method_51448().popMatrix();
        }
    }

    protected void renderContent(class_332 drawContext) {
        drawContext.method_51448().pushMatrix();
        drawContext.method_51448().translate((float)this.getGridPosX(0), (float)this.getGridPosY(0));
        drawContext.method_51448().scale(0.75f, 0.75f);
        for (FlatDirection direction : FlatDirection.VALUES) {
            ComponentState port = this.circuit.getPorts()[direction.getIndex()];
            ComponentPos pos = (ComponentPos)((Object)Circuit.PORT_POSITIONS.get((Object)direction));
            this.renderComponentStateInGrid(drawContext, port, pos.method_10263(), pos.method_10264(), 1.0f);
        }
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 15; ++j) {
                ComponentState componentState = this.circuit.getSection().getComponentState(i, j);
                this.renderComponentStateInGrid(drawContext, componentState, i, j, 1.0f);
            }
        }
        drawContext.method_51448().popMatrix();
    }

    protected static void renderComponentState(class_332 drawContext, ComponentState state, int x, int y, float a) {
        state.getComponent().render(drawContext, x, y, a, state);
    }

    protected void renderComponentStateInGrid(class_332 drawContext, ComponentState state, int x, int y, float a) {
        IntegratedCircuitScreen.renderComponentState(drawContext, state, x * 16, y * 16, a);
    }

    public static void renderComponentTexture(class_332 drawContext, class_2960 component, int x, int y, int rot, float alpha) {
        IntegratedCircuitScreen.renderComponentTexture(drawContext, component, x, y, rot, class_9848.method_61317((float)alpha));
    }

    public static void renderComponentTexture(class_332 drawContext, class_2960 component, int x, int y, int rot, int color) {
        IntegratedCircuitScreen.renderComponentTexture(drawContext, component, x, y, rot, color, 0, 0, 16, 16);
    }

    public static void renderComponentTexture(class_332 drawContext, class_2960 component, int x, int y, int rot, int color, int u, int v, int w, int h) {
        IntegratedCircuitScreen.renderPartialTexture(drawContext, component, x, y, u, v, 16, 16, rot, color, u, v, w, h);
    }

    public static void renderPartialTexture(class_332 drawContext, class_2960 texture, int componentX, int componentY, int x, int y, int textureW, int textureH, int rot, float alpha) {
        IntegratedCircuitScreen.renderPartialTexture(drawContext, texture, componentX, componentY, x, y, textureW, textureH, rot, class_9848.method_61317((float)alpha));
    }

    public static void renderPartialTexture(class_332 drawContext, class_2960 texture, int componentX, int componentY, int x, int y, int textureW, int textureH, int rot, int color) {
        IntegratedCircuitScreen.renderPartialTexture(drawContext, texture, componentX, componentY, x, y, textureW, textureH, rot, color, 0, 0, textureW, textureH);
    }

    private static void renderPartialTexture(class_332 drawContext, class_2960 texture, int componentX, int componentY, int x, int y, int textureW, int textureH, int rot, int color, int u, int v, int w, int h) {
        drawContext.method_51448().pushMatrix();
        drawContext.method_51448().translate((float)(componentX + 8), (float)(componentY + 8));
        drawContext.method_51448().rotate((float)((double)rot * Math.PI * 0.5));
        drawContext.method_51448().translate(-8.0f, -8.0f);
        drawContext.method_25291(class_10799.field_56883, texture, x, y, (float)u, (float)v, w, h, textureW, textureH, color);
        drawContext.method_51448().popMatrix();
    }

    public <T extends class_364 & class_4068> T method_37063(T drawableElement) {
        return (T)super.method_37063(drawableElement);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.field_22787 == null) {
            return false;
        }
        ComponentPos clickedPos = this.getComponentPosAt((int)mouseX, (int)mouseY);
        if (this.customNameTextField.method_25370() && !this.customNameTextField.method_25405(mouseX, mouseY)) {
            this.customNameTextField.method_25365(false);
        }
        if (IntegratedCircuitScreen.matchesMouse(DefaultConfig.config.getRotateKeybind(), button)) {
            this.rotateComponent(1);
            return true;
        }
        boolean isInCircuit = this.circuit.isInside(clickedPos);
        boolean isPlace = IntegratedCircuitScreen.matchesMouse(DefaultConfig.config.getPlaceKeybind(), button);
        this.startedDraggingInside = false;
        if (isInCircuit) {
            boolean isPick;
            boolean isDestroy = !isPlace && IntegratedCircuitScreen.matchesMouse(DefaultConfig.config.getDestroyKeybind(), button);
            boolean bl = isPick = !isDestroy && IntegratedCircuitScreen.matchesMouse(DefaultConfig.config.getPickKeybind(), button);
            if (isPlace) {
                ComponentState state = this.circuit.getComponentState(clickedPos);
                if (state.isAir()) {
                    this.placeComponent(clickedPos);
                    this.startedDraggingInside = true;
                } else {
                    this.circuit.useComponent(clickedPos, (class_1657)this.field_22787.field_1724);
                }
                return true;
            }
            if (isDestroy) {
                this.breakComponent(clickedPos);
                this.startedDraggingInside = true;
                return true;
            }
            if (isPick) {
                ComponentState state = this.circuit.getComponentState(clickedPos);
                Component component = state.getComponent();
                this.selectPalette(component);
                return true;
            }
        } else if (isPlace && Circuit.isPortPos(clickedPos)) {
            this.circuit.useComponent(clickedPos, (class_1657)this.field_22787.field_1724);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void breakComponent(ComponentPos pos) {
        this.circuit.breakComponentState(pos);
    }

    private void placeComponent(ComponentPos pos) {
        ComponentState state = this.circuit.getComponentState(pos);
        if (state.isAir() && this.cursorState != null) {
            this.circuit.placeComponentState(pos, this.cursorState.getComponent(), this.cursorRotation);
        }
    }

    private void selectPalette(Component component) {
        this.selectPalette(this.toolbox.getComponentIndex(component));
    }

    private void selectPalette(int index) {
        this.toolbox.selectTool(index);
    }

    private void deselectPalette() {
        this.toolbox.deselectTool();
    }

    private void updateCursorState(@Nullable Component component) {
        if (component != null) {
            this.cursorState = component.getDefaultState();
            if (component instanceof FacingComponent) {
                this.cursorState = (ComponentState)((Object)this.cursorState.method_11657((class_2769)FacingComponent.FACING, (Comparable)((Object)this.cursorRotation)));
            }
        } else {
            this.cursorState = null;
        }
    }

    public void updateCustomNameForExternalChange(class_2561 customName) {
        if (!this.customNameTextField.method_25370()) {
            this.customNameTextField.method_1852(customName.getString());
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        ComponentPos mousePos;
        if (this.startedDraggingInside && this.field_22787 != null && this.circuit.isInside(mousePos = this.getComponentPosAt((int)mouseX, (int)mouseY))) {
            boolean isDestroy;
            boolean isPlace = IntegratedCircuitScreen.matchesMouse(DefaultConfig.config.getPlaceKeybind(), button);
            boolean bl = isDestroy = !isPlace && IntegratedCircuitScreen.matchesMouse(DefaultConfig.config.getDestroyKeybind(), button);
            if (isPlace) {
                this.placeComponent(mousePos);
            } else if (isDestroy) {
                this.breakComponent(mousePos);
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void rotateComponent(int amount) {
        if (this.cursorState != null && this.cursorState.getComponent() instanceof FacingComponent) {
            this.cursorRotation = this.cursorRotation.rotated(amount);
            this.cursorState = (ComponentState)((Object)this.cursorState.method_11657((class_2769)FacingComponent.FACING, (Comparable)((Object)this.cursorRotation)));
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (DefaultConfig.config.getInvertScrollDirection()) {
            verticalAmount = -verticalAmount;
        }
        int intAmount = (int)verticalAmount;
        switch (DefaultConfig.config.getScrollBehaviour()) {
            case ROTATE: {
                this.rotateComponent(-intAmount);
                break;
            }
            case SELECT_COMPONENT: {
                this.selectPalette(this.toolbox.getSelectedToolSlot() - intAmount);
            }
        }
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.customNameTextField.method_25370() && (keyCode == 257 || keyCode == 335 || keyCode == 256)) {
            this.customNameTextField.method_25365(false);
            return true;
        }
        if (IntegratedCircuitScreen.matchesKey(DefaultConfig.config.getRotateKeybind(), keyCode, scanCode)) {
            this.rotateComponent(1);
            return true;
        }
        if (keyCode >= 48 && keyCode <= 57) {
            if (keyCode == 48) {
                this.deselectPalette();
            } else {
                this.selectPalette(keyCode - 49);
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    protected int getGridPosX(int gridX) {
        return this.x + 101 + gridX * 12;
    }

    protected int getGridPosY(int gridY) {
        return this.y + 36 + gridY * 12;
    }

    protected int getGridXAt(int pixelX) {
        return Math.floorDiv(pixelX - this.x - 101, 12);
    }

    protected int getGridYAt(int pixelY) {
        return Math.floorDiv(pixelY - this.y - 36, 12);
    }

    protected ComponentPos getComponentPosAt(int pixelX, int pixelY) {
        return new ComponentPos(this.getGridXAt(pixelX), this.getGridYAt(pixelY));
    }

    public static boolean matchesMouse(class_3675.class_306 key, int button) {
        return key.method_1442() == class_3675.class_307.field_1672 && key.method_1444() == button;
    }

    public static boolean matchesKey(class_3675.class_306 key, int keyCode, int scanCode) {
        if (keyCode == class_3675.field_16237.method_1444()) {
            return key.method_1442() == class_3675.class_307.field_1671 && key.method_1444() == scanCode;
        }
        return key.method_1442() == class_3675.class_307.field_1668 && key.method_1444() == keyCode;
    }
}

