/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit.components;

import net.minecraft.class_2457;
import net.minecraft.class_2561;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9848;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.components.AbstractConductingComponent;
import net.replaceitem.integratedcircuit.client.gui.IntegratedCircuitScreen;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class CrossoverComponent
extends AbstractConductingComponent {
    private static final class_2960 ITEM_TEXTURE = IntegratedCircuit.id("textures/integrated_circuit/crossover.png");
    private static final class_2960 TOOL_TEXTURE = IntegratedCircuit.id("toolbox/icons/crossover");
    private static final class_2960 TEXTURE_BRIDGE = IntegratedCircuit.id("textures/integrated_circuit/wire_bridge.png");
    public static final class_2758 POWER_X = class_2758.method_11867((String)"power_x", (int)0, (int)15);
    public static final class_2758 POWER_Y = class_2758.method_11867((String)"power_y", (int)0, (int)15);

    public CrossoverComponent(Component.Settings settings) {
        super(settings);
        this.setDefaultState((ComponentState)((Object)((ComponentState)((Object)((ComponentState)this.getStateManager().method_11664()).method_11657((class_2769)POWER_X, Integer.valueOf(0)))).method_11657((class_2769)POWER_Y, Integer.valueOf(0))));
    }

    @Override
    @Nullable
    public class_2960 getItemTexture() {
        return ITEM_TEXTURE;
    }

    @Override
    @Nullable
    public class_2960 getToolTexture() {
        return TOOL_TEXTURE;
    }

    @Override
    public class_2561 getHoverInfoText(ComponentState state) {
        return class_2561.method_43470((String)"\u2500 ").method_10852(IntegratedCircuitScreen.getSignalStrengthText((Integer)state.method_11654((class_2769)POWER_X))).method_27693(" \u2502 ").method_10852(IntegratedCircuitScreen.getSignalStrengthText((Integer)state.method_11654((class_2769)POWER_Y)));
    }

    @Override
    public void render(class_332 drawContext, int x, int y, float a, ComponentState state) {
        int colorX = class_2457.method_10487((int)((Integer)state.method_11654((class_2769)POWER_X)));
        int colorY = class_2457.method_10487((int)((Integer)state.method_11654((class_2769)POWER_Y)));
        IntegratedCircuitScreen.renderComponentTexture(drawContext, TEXTURE_X, x, y, 0, class_9848.method_61330((int)class_9848.method_61326((float)a), (int)colorX));
        IntegratedCircuitScreen.renderComponentTexture(drawContext, TEXTURE_BRIDGE, x, y, 0, a);
        IntegratedCircuitScreen.renderComponentTexture(drawContext, TEXTURE_Y, x, y, 0, class_9848.method_61330((int)class_9848.method_61326((float)a), (int)colorY));
    }

    @Override
    public void onBlockAdded(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState oldState) {
        if (oldState.getComponent() == state.getComponent() || circuit.isClient) {
            return;
        }
        this.update(circuit, pos, state);
        this.updateOffsetNeighbors(circuit, pos);
    }

    @Override
    public void neighborUpdate(ComponentState state, Circuit circuit, ComponentPos pos, Component sourceBlock, ComponentPos sourcePos, boolean notify) {
        if (circuit.isClient) {
            return;
        }
        this.update(circuit, pos, state);
    }

    @Override
    public int getStrongRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        return this.getWeakRedstonePower(state, circuit, pos, direction);
    }

    @Override
    protected void update(Circuit circuit, ComponentPos pos, ComponentState state) {
        int powerX = this.getReceivedRedstonePower(circuit, pos, FlatDirection.Axis.X);
        int powerY = this.getReceivedRedstonePower(circuit, pos, FlatDirection.Axis.Y);
        if ((Integer)state.method_11654((class_2769)POWER_X) != powerX || (Integer)state.method_11654((class_2769)POWER_Y) != powerY) {
            if (circuit.getComponentState(pos) == state) {
                circuit.setComponentState(pos, (ComponentState)((Object)((ComponentState)((Object)state.method_11657((class_2769)POWER_X, Integer.valueOf(powerX)))).method_11657((class_2769)POWER_Y, Integer.valueOf(powerY))), 2);
            }
            this.updateAfterSignalStrengthChange(circuit, pos);
        }
    }

    protected int getReceivedRedstonePower(Circuit circuit, ComponentPos pos, FlatDirection.Axis axis) {
        wiresGivePower = false;
        int i = 0;
        for (FlatDirection direction : FlatDirection.forAxis(axis)) {
            int power = circuit.getEmittedRedstonePower(pos.offset(direction), direction);
            if (power <= i) continue;
            i = power;
        }
        wiresGivePower = true;
        int j = 0;
        if (i < 15) {
            for (FlatDirection direction : FlatDirection.forAxis(axis)) {
                ComponentPos blockPos = pos.offset(direction);
                ComponentState blockState = circuit.getComponentState(blockPos);
                j = Math.max(j, blockState.increasePower(direction.getOpposite()));
            }
        }
        return Math.max(i, j - 1);
    }

    @Override
    public int getWeakRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        if (!wiresGivePower) {
            return 0;
        }
        return direction.getAxis() == FlatDirection.Axis.X ? ((Integer)state.method_11654((class_2769)POWER_X)).intValue() : ((Integer)state.method_11654((class_2769)POWER_Y)).intValue();
    }

    @Override
    public int increasePower(ComponentState state, FlatDirection side) {
        return side.getAxis() == FlatDirection.Axis.X ? ((Integer)state.method_11654((class_2769)POWER_X)).intValue() : ((Integer)state.method_11654((class_2769)POWER_Y)).intValue();
    }

    @Override
    public void appendProperties(class_2689.class_2690<Component, ComponentState> builder) {
        super.appendProperties(builder);
        builder.method_11667(new class_2769[]{POWER_X});
        builder.method_11667(new class_2769[]{POWER_Y});
    }
}

