/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit.components;

import net.minecraft.class_1657;
import net.minecraft.class_1953;
import net.minecraft.class_2561;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2747;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.ServerCircuit;
import net.replaceitem.integratedcircuit.circuit.components.AbstractRedstoneGateComponent;
import net.replaceitem.integratedcircuit.client.gui.IntegratedCircuitScreen;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class ComparatorComponent
extends AbstractRedstoneGateComponent {
    private static final class_2960 ITEM_TEXTURE = class_2960.method_60656((String)"textures/item/comparator.png");
    private static final class_2960 TOOL_TEXTURE = IntegratedCircuit.id("toolbox/icons/comparator");
    private static final class_2960 TEXTURE = IntegratedCircuit.id("textures/integrated_circuit/comparator.png");
    private static final class_2960 TEXTURE_ON = IntegratedCircuit.id("textures/integrated_circuit/comparator_on.png");
    private static final class_2960 TEXTURE_TORCH_OFF = IntegratedCircuit.id("textures/integrated_circuit/torch_top_off.png");
    private static final class_2960 TEXTURE_TORCH_ON = IntegratedCircuit.id("textures/integrated_circuit/torch_top_on.png");
    public static final class_2754<class_2747> MODE = class_2741.field_12534;
    public static final class_2758 OUTPUT_POWER = class_2741.field_12511;

    public ComparatorComponent(Component.Settings settings) {
        super(settings);
        this.setDefaultState((ComponentState)((Object)((ComponentState)((Object)((ComponentState)((Object)((ComponentState)((Object)((ComponentState)this.getStateManager().method_11664()).method_11657((class_2769)FACING, (Comparable)((Object)FlatDirection.NORTH)))).method_11657((class_2769)POWERED, Boolean.valueOf(false)))).method_11657((class_2769)MODE, (Comparable)class_2747.field_12576))).method_11657((class_2769)OUTPUT_POWER, Integer.valueOf(0))));
    }

    @Override
    @Nullable
    public class_2960 getItemTexture() {
        return ITEM_TEXTURE;
    }

    @Override
    @Nullable
    public class_2960 getToolTexture() {
        return TOOL_TEXTURE;
    }

    @Override
    public class_2561 getHoverInfoText(ComponentState state) {
        int signalStrength = (Integer)state.method_11654((class_2769)OUTPUT_POWER);
        return IntegratedCircuitScreen.getSignalStrengthText(signalStrength);
    }

    @Override
    public void render(class_332 drawContext, int x, int y, float a, ComponentState state) {
        boolean powered = (Boolean)state.method_11654((class_2769)POWERED);
        int rot = ((FlatDirection)((Object)state.method_11654((class_2769)FACING))).getOpposite().getIndex();
        IntegratedCircuitScreen.renderComponentTexture(drawContext, powered ? TEXTURE_ON : TEXTURE, x, y, rot, a);
        class_2960 torchTexture = powered ? TEXTURE_TORCH_ON : TEXTURE_TORCH_OFF;
        IntegratedCircuitScreen.renderPartialTexture(drawContext, torchTexture, x, y, 3, 10, 4, 4, rot, a);
        IntegratedCircuitScreen.renderPartialTexture(drawContext, torchTexture, x, y, 9, 10, 4, 4, rot, a);
        class_2960 modeTorchTexture = state.method_11654((class_2769)MODE) == class_2747.field_12578 ? TEXTURE_TORCH_ON : TEXTURE_TORCH_OFF;
        IntegratedCircuitScreen.renderPartialTexture(drawContext, modeTorchTexture, x, y, 6, 1, 4, 4, rot, a);
    }

    @Override
    protected int getUpdateDelayInternal(ComponentState state) {
        return 2;
    }

    @Override
    protected int getOutputLevel(Circuit circuit, ComponentPos pos, ComponentState state) {
        return (Integer)state.method_11654((class_2769)OUTPUT_POWER);
    }

    private int calculateOutputSignal(Circuit world, ComponentPos pos, ComponentState state) {
        int i = this.getPower(world, pos, state);
        if (i == 0) {
            return 0;
        }
        int j = this.getMaxInputLevelSides(world, pos, state);
        if (j > i) {
            return 0;
        }
        if (state.method_11654((class_2769)MODE) == class_2747.field_12578) {
            return i - j;
        }
        return i;
    }

    @Override
    protected boolean hasPower(Circuit circuit, ComponentPos pos, ComponentState state) {
        int i = this.getPower(circuit, pos, state);
        if (i == 0) {
            return false;
        }
        int j = this.getMaxInputLevelSides(circuit, pos, state);
        if (i > j) {
            return true;
        }
        return i == j && state.method_11654((class_2769)MODE) == class_2747.field_12576;
    }

    @Override
    protected int getPower(Circuit circuit, ComponentPos pos, ComponentState state) {
        int power = super.getPower(circuit, pos, state);
        FlatDirection direction = (FlatDirection)((Object)state.method_11654((class_2769)FACING));
        ComponentPos offsetPos = pos.offset(direction);
        ComponentState offsetState = circuit.getComponentState(offsetPos);
        if (offsetState.hasComparatorOutput()) {
            power = offsetState.getComparatorOutput(circuit, offsetPos);
        } else if (power < 15 && offsetState.isSolidBlock(circuit, offsetPos) && (offsetState = circuit.getComponentState(offsetPos = offsetPos.offset(direction))).hasComparatorOutput()) {
            power = offsetState.getComparatorOutput(circuit, offsetPos);
        }
        return power;
    }

    @Override
    public void onUse(ComponentState state, Circuit circuit, ComponentPos pos, class_1657 player) {
        state = (ComponentState)((Object)state.method_28493((class_2769)MODE));
        circuit.setComponentState(pos, state, 2);
        this.update(circuit, pos, state);
        float f = state.method_11654((class_2769)MODE) == class_2747.field_12578 ? 0.55f : 0.5f;
        circuit.playSound(player, class_3417.field_14762, class_3419.field_15245, 1.0f, f);
    }

    @Override
    protected void updatePowered(Circuit circuit, ComponentPos pos, ComponentState state) {
        int outputSignal;
        if (circuit.getCircuitTickScheduler().isTicking(pos, this)) {
            return;
        }
        int calculatedOutputSignal = this.calculateOutputSignal(circuit, pos, state);
        if (calculatedOutputSignal != (outputSignal = ((Integer)state.method_11654((class_2769)OUTPUT_POWER)).intValue()) || ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue() != this.hasPower(circuit, pos, state)) {
            class_1953 tickPriority = this.isTargetNotAligned(circuit, pos, state) ? class_1953.field_9310 : class_1953.field_9314;
            circuit.scheduleBlockTick(pos, this, 2, tickPriority);
        }
    }

    private void update(Circuit world, ComponentPos pos, ComponentState state) {
        int i = this.calculateOutputSignal(world, pos, state);
        int j = (Integer)state.method_11654((class_2769)OUTPUT_POWER);
        state = (ComponentState)((Object)state.method_11657((class_2769)OUTPUT_POWER, Integer.valueOf(i)));
        if (j != i || state.method_11654((class_2769)MODE) == class_2747.field_12576) {
            boolean hasPower = this.hasPower(world, pos, state);
            boolean powered = (Boolean)state.method_11654((class_2769)POWERED);
            if (powered && !hasPower) {
                world.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)POWERED, Boolean.valueOf(false))), 2);
            } else if (!powered && hasPower) {
                world.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)POWERED, Boolean.valueOf(true))), 2);
            } else if (j != i) {
                world.setComponentState(pos, state, 2);
            }
            this.updateTarget(world, pos, state);
        }
    }

    @Override
    public void scheduledTick(ComponentState state, ServerCircuit circuit, ComponentPos pos, class_5819 random) {
        this.update(circuit, pos, state);
    }

    @Override
    public void appendProperties(class_2689.class_2690<Component, ComponentState> builder) {
        super.appendProperties(builder);
        builder.method_11667(new class_2769[]{MODE});
        builder.method_11667(new class_2769[]{OUTPUT_POWER});
    }
}

