/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_2361;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.CircuitAccess;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.ServerCircuit;
import net.replaceitem.integratedcircuit.circuit.components.FacingComponent;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public abstract class Component {
    public static final class_9139<class_9129, Component> PACKET_CODEC = class_9135.method_56365(IntegratedCircuit.COMPONENTS_REGISTRY_KEY);
    private final class_6880.class_6883<Component> registryEntry = IntegratedCircuit.COMPONENTS_REGISTRY.method_40269((Object)this);
    public static final class_2361<ComponentState> STATE_IDS = new class_2361();
    public static final int NOTIFY_NEIGHBORS = 1;
    public static final int NOTIFY_LISTENERS = 2;
    public static final int NO_REDRAW = 4;
    public static final int REDRAW_ON_MAIN_THREAD = 8;
    public static final int FORCE_STATE = 16;
    public static final int SKIP_DROPS = 32;
    public static final int MOVED = 64;
    public static final int SKIP_LIGHTING_UPDATES = 128;
    public static final int NOTIFY_ALL = 3;
    private final Settings settings;
    private ComponentState defaultState;
    private final class_2689<Component, ComponentState> stateManager;
    public static final FlatDirection[] DIRECTIONS = new FlatDirection[]{FlatDirection.WEST, FlatDirection.EAST, FlatDirection.NORTH, FlatDirection.SOUTH};

    public Component(Settings settings) {
        this.settings = settings;
        class_2689.class_2690 builder = new class_2689.class_2690((Object)this);
        this.appendProperties((class_2689.class_2690<Component, ComponentState>)builder);
        this.stateManager = builder.method_11668(Component::getDefaultState, ComponentState::new);
        this.setDefaultState((ComponentState)this.stateManager.method_11664());
    }

    public Settings getSettings() {
        return this.settings;
    }

    public class_2561 getName() {
        return class_2561.method_43471((String)IntegratedCircuit.COMPONENTS_REGISTRY.method_10221((Object)this).method_42093("integrated_circuit.component"));
    }

    public void appendProperties(class_2689.class_2690<Component, ComponentState> builder) {
    }

    public void setDefaultState(ComponentState defaultState) {
        this.defaultState = defaultState;
    }

    public final ComponentState getDefaultState() {
        return this.defaultState;
    }

    public ComponentState getPlacementState(Circuit circuit, ComponentPos pos, FlatDirection rotation) {
        ComponentState defaultState = this.getDefaultState();
        if (this.stateManager.method_11659().contains(FacingComponent.FACING)) {
            return (ComponentState)((Object)defaultState.method_11657((class_2769)FacingComponent.FACING, (Comparable)((Object)rotation)));
        }
        return defaultState;
    }

    @Nullable
    public abstract class_2960 getItemTexture();

    @Nullable
    public abstract class_2960 getToolTexture();

    public abstract void render(class_332 var1, int var2, int var3, float var4, ComponentState var5);

    public static void replace(ComponentState state, ComponentState newState, Circuit world, ComponentPos pos, int flags) {
        Component.replace(state, newState, world, pos, flags, 512);
    }

    public static void replace(ComponentState state, ComponentState newState, Circuit world, ComponentPos pos, int flags, int maxUpdateDepth) {
        if (newState != state) {
            if (newState.isAir()) {
                if (!world.isClient) {
                    world.breakBlock(pos, maxUpdateDepth);
                }
            } else {
                world.setComponentState(pos, newState, flags & 0xFFFFFFDF, maxUpdateDepth);
            }
        }
    }

    public void neighborUpdate(ComponentState state, Circuit circuit, ComponentPos pos, Component sourceBlock, ComponentPos sourcePos, boolean notify) {
    }

    public void onBlockAdded(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState oldState) {
    }

    public void onStateReplaced(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState newState) {
    }

    public void onUse(ComponentState state, Circuit circuit, ComponentPos pos, class_1657 player) {
    }

    public void onPlaced(ServerCircuit circuit, ComponentPos pos, ComponentState state) {
    }

    public void scheduledTick(ComponentState state, ServerCircuit circuit, ComponentPos pos, class_5819 random) {
    }

    public ComponentState getStateForNeighborUpdate(ComponentState state, FlatDirection direction, ComponentState neighborState, Circuit circuit, ComponentPos pos, ComponentPos neighborPos) {
        return state;
    }

    public void prepare(ComponentState state, CircuitAccess circuit, ComponentPos pos, int flags, int maxUpdateDepth) {
    }

    public abstract boolean isSolidBlock(Circuit var1, ComponentPos var2);

    public boolean isSideSolidFullSquare(Circuit circuit, ComponentPos blockPos, FlatDirection direction) {
        return this.isSolidBlock(circuit, blockPos);
    }

    public int getWeakRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        return 0;
    }

    public int getStrongRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        return 0;
    }

    public boolean hasComparatorOutput(ComponentState componentState) {
        return false;
    }

    public int getComparatorOutput(ComponentState state, Circuit circuit, ComponentPos pos) {
        return 0;
    }

    public int increasePower(ComponentState state, FlatDirection side) {
        return 0;
    }

    public boolean canPlaceAt(ComponentState state, Circuit circuit, ComponentPos pos) {
        return true;
    }

    public String toString() {
        return IntegratedCircuit.COMPONENTS_REGISTRY.method_10221((Object)this).toString();
    }

    protected static <C extends Component> RecordCodecBuilder<C, Settings> createSettingsCodec() {
        return Settings.CODEC.fieldOf("properties").forGetter(Component::getSettings);
    }

    public static <C extends Component> MapCodec<C> createCodec(Function<Settings, C> componentFromSetting) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(Component.createSettingsCodec()).apply((Applicative)instance, componentFromSetting));
    }

    public boolean emitsRedstonePower(ComponentState state) {
        return false;
    }

    public class_2561 getHoverInfoText(ComponentState state) {
        return class_2561.method_43473();
    }

    public class_2689<Component, ComponentState> getStateManager() {
        return this.stateManager;
    }

    public static class Settings {
        public static final Codec<Settings> CODEC = Codec.unit(Settings::new);
        public class_2498 soundGroup = class_2498.field_11544;

        public Settings sounds(class_2498 soundGroup) {
            this.soundGroup = soundGroup;
            return this;
        }
    }
}

