/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit;

import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1275;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.CircuitSerializer;
import net.replaceitem.integratedcircuit.circuit.ServerCircuit;
import net.replaceitem.integratedcircuit.circuit.components.PortComponent;
import net.replaceitem.integratedcircuit.circuit.context.BlockEntityServerCircuitContext;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class IntegratedCircuitBlockEntity
extends class_2586
implements class_1275 {
    private static final Object DUMMY = new Object();
    protected WeakHashMap<class_3222, Object> editors;
    @Nullable
    protected class_2561 customName;
    @Nullable
    private ServerCircuit circuit = null;
    @Nullable
    private class_2487 circuitNbt;
    protected byte[] renderSignalStrengths = new byte[]{0, 0, 0, 0};

    public IntegratedCircuitBlockEntity(class_2338 pos, class_2680 state) {
        super(IntegratedCircuit.INTEGRATED_CIRCUIT_BLOCK_ENTITY, pos, state);
        this.editors = new WeakHashMap(4);
    }

    private void tryCreateCircuit() {
        class_1937 world = this.method_10997();
        if (world != null && !world.field_9236) {
            BlockEntityServerCircuitContext context = new BlockEntityServerCircuitContext(this);
            if (this.circuitNbt != null) {
                this.circuit = new CircuitSerializer(this.circuitNbt).readServerCircuit(context);
                this.circuitNbt = null;
                for (int i = 0; i < Circuit.PORT_COUNT; ++i) {
                    this.renderSignalStrengths[i] = ((Integer)this.circuit.getPorts()[i].method_11654((class_2769)PortComponent.POWER)).byteValue();
                }
            } else {
                this.circuit = new ServerCircuit(context);
            }
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(class_9334.field_49631, (Object)this.customName);
        Optional.ofNullable(this.circuit).map(CircuitSerializer::writeCircuit).or(() -> Optional.ofNullable(this.circuitNbt).map(DataResult::success)).orElseGet(() -> DataResult.error(() -> "No circuit or circuitNbt to serialize")).ifSuccess(nbtElement -> {
            if (nbtElement instanceof class_2487) {
                class_2487 compound = (class_2487)nbtElement;
                componentMapBuilder.method_57840(IntegratedCircuit.CIRCUIT_DATA, (Object)class_9279.method_57456((class_2487)compound));
            }
        });
    }

    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        this.customName = (class_2561)components.method_58694(class_9334.field_49631);
        class_9279 circuitComponent = (class_9279)components.method_58694(IntegratedCircuit.CIRCUIT_DATA);
        if (circuitComponent != null) {
            this.circuitNbt = circuitComponent.method_57461();
        }
        this.tryCreateCircuit();
    }

    public void method_57569(class_11372 view) {
        super.method_57569(view);
        view.method_71478("CustomName");
        view.method_71478("circuit");
    }

    protected void method_11014(class_11368 view) {
        this.customName = IntegratedCircuitBlockEntity.method_59894((class_11368)view, (String)"CustomName");
        this.circuitNbt = view.method_71426("circuit", class_2487.field_25128).orElse(null);
        this.tryCreateCircuit();
        view.method_71426("outputStrengths", class_5699.field_60980).flatMap(nbtElement -> {
            Optional<Object> optional;
            if (nbtElement instanceof class_2479) {
                class_2479 byteArray = (class_2479)nbtElement;
                optional = Optional.of(byteArray);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }).ifPresent(bytes -> {
            this.renderSignalStrengths = bytes.method_10521();
        });
    }

    protected void method_11007(class_11372 view) {
        view.method_71477("CustomName", class_8824.field_46597, (Object)this.customName);
        if (this.circuit != null) {
            view.method_71477("circuit", ServerCircuit.CODEC.withContext(this.circuit.getContext()), (Object)this.circuit);
        } else if (this.circuitNbt != null) {
            view.method_71468("circuit", class_2487.field_25128, (Object)this.circuitNbt);
        }
    }

    public void setCustomName(@Nullable class_2561 name) {
        this.customName = name;
        this.method_5431();
        if (this.field_11863 != null) {
            class_2338 pos = this.method_11016();
            class_2680 state = this.field_11863.method_8320(pos);
            this.field_11863.method_8413(pos, this.method_11010(), state, 2);
        }
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public class_2561 method_5477() {
        if (this.method_16914()) {
            return this.customName;
        }
        return class_2561.method_43471((String)"block.integrated_circuit.integrated_circuit");
    }

    public Set<class_3222> getEditingPlayers() {
        return this.editors.keySet();
    }

    public boolean isEditing(class_3222 player) {
        return this.editors.containsKey(player);
    }

    public void addEditor(class_3222 player) {
        for (class_3222 serverPlayerEntity : this.editors.keySet()) {
            if (serverPlayerEntity.method_35049() == null) continue;
            this.editors.remove(serverPlayerEntity);
        }
        this.editors.put(player, DUMMY);
    }

    public void removeEditor(class_3222 player) {
        this.editors.remove(player);
    }

    public void setRenderSignalStrength(FlatDirection direction, int power) {
        this.renderSignalStrengths[direction.getIndex()] = (byte)power;
    }

    public int getPortRenderStrength(FlatDirection direction) {
        return this.renderSignalStrengths[direction.getIndex()];
    }

    @Nullable
    public ServerCircuit getCircuit() {
        return this.circuit;
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        this.tryCreateCircuit();
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        nbt.method_10570("outputStrengths", (byte[])this.renderSignalStrengths.clone());
        if (this.method_16914()) {
            nbt.method_67494("CustomName", class_8824.field_46597, (Object)this.customName);
        }
        return nbt;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

