/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2457;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8235;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.minecraft.class_9902;
import net.minecraft.class_9904;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.IntegratedCircuitBlockEntity;
import net.replaceitem.integratedcircuit.circuit.CircuitSerializer;
import net.replaceitem.integratedcircuit.circuit.ServerCircuit;
import net.replaceitem.integratedcircuit.network.packet.EditIntegratedCircuitS2CPacket;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class IntegratedCircuitBlock
extends class_2383
implements class_2343 {
    public static final MapCodec<IntegratedCircuitBlock> CODEC = IntegratedCircuitBlock.method_54094(IntegratedCircuitBlock::new);
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public IntegratedCircuitBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{class_2741.field_12481});
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return class_2248.method_16361((class_1922)world, (class_2338)pos.method_10074());
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)ctx.method_8042());
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        IntegratedCircuitBlockEntity integratedCircuitBlockEntity;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof IntegratedCircuitBlockEntity && (integratedCircuitBlockEntity = (IntegratedCircuitBlockEntity)class_25862).getCircuit() != null) {
            integratedCircuitBlockEntity.getCircuit().tick();
        }
        world.method_64310(pos, state.method_26204(), 1);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (direction == class_2350.field_11033 && !this.method_9558(state, world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        IntegratedCircuitBlockEntity integratedCircuitBlockEntity;
        super.method_9612(state, world, pos, sourceBlock, wireOrientation, notify);
        if (world.field_9236) {
            return;
        }
        FlatDirection[] flatDirectionArray = world.method_8321(pos);
        if (flatDirectionArray instanceof IntegratedCircuitBlockEntity && (integratedCircuitBlockEntity = (IntegratedCircuitBlockEntity)flatDirectionArray).getCircuit() != null) {
            for (FlatDirection direction : FlatDirection.VALUES) {
                integratedCircuitBlockEntity.getCircuit().getContext().readExternalPower(direction);
            }
        }
        this.ensureTicking(world, pos);
    }

    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        this.updateTargets(world, pos);
        this.ensureTicking(world, pos);
    }

    protected void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
        if (moved) {
            return;
        }
        this.updateTargets((class_1937)world, pos);
    }

    private void ensureTicking(class_1937 world, class_2338 pos) {
        if (!world.method_8397().method_8674(pos, (Object)this)) {
            world.method_64310(pos, (class_2248)this, 0);
        }
    }

    public void updateTarget(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction);
        class_9904 wireOrientation = class_9902.method_61826((class_1937)world, (class_2350)direction, (class_2350)class_2350.field_11036);
        world.method_8492(blockPos, (class_2248)this, wireOrientation);
        world.method_8508(blockPos, (class_2248)this, direction.method_10153(), wireOrientation);
    }

    protected void updateTargets(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            this.updateTarget(world, pos, direction);
        }
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.method_8608() && player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof IntegratedCircuitBlockEntity) {
                IntegratedCircuitBlockEntity integratedCircuitBlockEntity = (IntegratedCircuitBlockEntity)class_25862;
                ServerCircuit circuit = integratedCircuitBlockEntity.getCircuit();
                if (circuit == null) {
                    return class_1269.field_5814;
                }
                DataResult<class_2520> circuitNbt = CircuitSerializer.writeCircuit(circuit);
                if (circuitNbt.error().isPresent()) {
                    IntegratedCircuit.LOGGER.error(((DataResult.Error)circuitNbt.error().get()).message());
                    return class_1269.field_5814;
                }
                class_2520 nbtElement = (class_2520)circuitNbt.result().orElseThrow();
                if (!(nbtElement instanceof class_2487)) {
                    return class_1269.field_5814;
                }
                class_2487 compound = (class_2487)nbtElement;
                integratedCircuitBlockEntity.addEditor(serverPlayerEntity);
                class_2561 customName = integratedCircuitBlockEntity.method_5797();
                if (customName == null) {
                    customName = class_2561.method_43473();
                }
                ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new EditIntegratedCircuitS2CPacket(pos, customName, compound));
            }
        }
        return class_1269.field_5812;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 class_25862;
        if (itemStack.method_57826(class_9334.field_49631) && (class_25862 = world.method_8321(pos)) instanceof IntegratedCircuitBlockEntity) {
            IntegratedCircuitBlockEntity integratedCircuitBlockEntity = (IntegratedCircuitBlockEntity)class_25862;
            integratedCircuitBlockEntity.setCustomName(itemStack.method_7964());
        }
        this.updateTargets(world, pos);
        world.method_8492(pos, (class_2248)this, null);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new IntegratedCircuitBlockEntity(pos, state);
    }

    public int getInputPower(class_8235 view, class_2338 pos, class_2680 state, FlatDirection dir) {
        class_2350 direction = dir.toVanillaDirection(state);
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = view.method_8320(blockPos);
        int i = view.method_49808(blockPos, direction);
        if (i >= 15) {
            return i;
        }
        return Math.max(i, blockState.method_27852(class_2246.field_10091) ? (Integer)blockState.method_11654((class_2769)class_2457.field_11432) : 0);
    }

    protected boolean method_9506(class_2680 state) {
        return true;
    }

    protected int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return state.method_26195(world, pos, direction);
    }

    protected int method_9524(class_2680 state, class_1922 view, class_2338 pos, class_2350 direction) {
        IntegratedCircuitBlockEntity integratedCircuitBlockEntity;
        if (direction.method_10166().method_10178()) {
            return 0;
        }
        FlatDirection circuitDirection = FlatDirection.fromVanillaDirection(state, direction.method_10153());
        class_2586 class_25862 = view.method_8321(pos);
        if (class_25862 instanceof IntegratedCircuitBlockEntity && (integratedCircuitBlockEntity = (IntegratedCircuitBlockEntity)class_25862).getCircuit() != null) {
            return integratedCircuitBlockEntity.getCircuit().getPortOutputStrength(circuitDirection);
        }
        return 0;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof IntegratedCircuitBlockEntity) {
            IntegratedCircuitBlockEntity integratedCircuitBlockEntity = (IntegratedCircuitBlockEntity)blockEntity;
            ServerCircuit circuit = integratedCircuitBlockEntity.getCircuit();
            if (!world.field_9236 && player.method_68878() && circuit != null && !circuit.isEmpty()) {
                IntegratedCircuitBlock.method_9511((class_2680)state, (class_1937)world, (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)player.method_6047());
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        IntegratedCircuitBlockEntity integratedCircuitBlockEntity;
        ServerCircuit circuit;
        List list = super.method_9560(state, builder);
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof IntegratedCircuitBlockEntity && ((circuit = (integratedCircuitBlockEntity = (IntegratedCircuitBlockEntity)blockEntity).getCircuit()) == null || circuit.isEmpty())) {
            for (class_1799 stack : list) {
                stack.method_57381(class_9334.field_49611);
            }
        }
        return list;
    }

    public int getPortRenderStrength(class_1920 view, class_2338 pos, FlatDirection circuitDirection) {
        class_2586 class_25862 = view.method_8321(pos);
        if (class_25862 instanceof IntegratedCircuitBlockEntity) {
            IntegratedCircuitBlockEntity integratedCircuitBlockEntity = (IntegratedCircuitBlockEntity)class_25862;
            return integratedCircuitBlockEntity.getPortRenderStrength(circuitDirection);
        }
        return 0;
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return CODEC;
    }

    public static IntegratedCircuitBlock fromColor(class_1767 color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case class_1767.field_7952 -> IntegratedCircuit.Blocks.WHITE_INTEGRATED_CIRCUIT;
            case class_1767.field_7946 -> IntegratedCircuit.Blocks.ORANGE_INTEGRATED_CIRCUIT;
            case class_1767.field_7958 -> IntegratedCircuit.Blocks.MAGENTA_INTEGRATED_CIRCUIT;
            case class_1767.field_7951 -> IntegratedCircuit.Blocks.LIGHT_BLUE_INTEGRATED_CIRCUIT;
            case class_1767.field_7947 -> IntegratedCircuit.Blocks.YELLOW_INTEGRATED_CIRCUIT;
            case class_1767.field_7961 -> IntegratedCircuit.Blocks.LIME_INTEGRATED_CIRCUIT;
            case class_1767.field_7954 -> IntegratedCircuit.Blocks.PINK_INTEGRATED_CIRCUIT;
            case class_1767.field_7944 -> IntegratedCircuit.Blocks.GRAY_INTEGRATED_CIRCUIT;
            case class_1767.field_7967 -> IntegratedCircuit.Blocks.LIGHT_GRAY_INTEGRATED_CIRCUIT;
            case class_1767.field_7955 -> IntegratedCircuit.Blocks.CYAN_INTEGRATED_CIRCUIT;
            case class_1767.field_7945 -> IntegratedCircuit.Blocks.PURPLE_INTEGRATED_CIRCUIT;
            case class_1767.field_7966 -> IntegratedCircuit.Blocks.BLUE_INTEGRATED_CIRCUIT;
            case class_1767.field_7957 -> IntegratedCircuit.Blocks.BROWN_INTEGRATED_CIRCUIT;
            case class_1767.field_7942 -> IntegratedCircuit.Blocks.GREEN_INTEGRATED_CIRCUIT;
            case class_1767.field_7964 -> IntegratedCircuit.Blocks.RED_INTEGRATED_CIRCUIT;
            case class_1767.field_7963 -> IntegratedCircuit.Blocks.BLACK_INTEGRATED_CIRCUIT;
        };
    }
}

