/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.StateManager;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.config.ModConfig;

public class ConfigScreens {
    private static class_437 screenToOpen;
    private static String lastScreenInitialized;

    public static void regenerateScreen(YACLScreen thisScreen, Supplier<class_437> generator) {
        String key = ((class_2588)thisScreen.method_25440().method_10851()).method_11022();
        if (!lastScreenInitialized.equals(key)) {
            lastScreenInitialized = key;
            if (generator != null) {
                class_310.method_1551().method_1507(generator.get());
            }
        }
    }

    public static class_437 generateScreen(String titleKey, Collection<OptionGroup> groups, Collection<Option<?>> options, Supplier<class_437> generator, class_437 parent) {
        ConfigCategory.Builder categoryBuilder = ConfigCategory.createBuilder();
        if (groups != null) {
            categoryBuilder.groups(groups);
        }
        if (options != null) {
            categoryBuilder.options(options);
        }
        return YetAnotherConfigLib.createBuilder().title(ConfigScreens.getComponent(titleKey)).category(categoryBuilder.name(ConfigScreens.getComponent(titleKey)).build()).save(ModConfig::saveConfig).screenInit(thisScreen -> ConfigScreens.regenerateScreen(thisScreen, generator)).build().generateScreen(parent);
    }

    public static class_437 generateMainConfigScreen(class_437 prevScreen) {
        List<OptionGroup> groups = ConfigScreens.collectGroups(ModConfig.DEFAULT, ModConfig.CONFIG);
        groups.add(1, ConfigScreens.getParticleToggles());
        return ConfigScreens.generateScreen("title", groups, ConfigScreens.collectOptions(ModConfig.DEFAULT, ModConfig.CONFIG), () -> ConfigScreens.generateMainConfigScreen(prevScreen), prevScreen);
    }

    public static class_437 generateParticleListScreen(class_437 prevScreen) {
        ArrayList options = new ArrayList();
        options.add((Option<?>)ConfigScreens.getScreenButtonOption(ConfigScreens.getComponent("button.add"), "", () -> {
            ModConfig.ParticleOptions particle = new ModConfig.ParticleOptions();
            ModConfig.CONFIG.customParticles.add(particle);
            ModConfig.saveConfig();
            screenToOpen = ConfigScreens.generateEditScreen(ConfigScreens.generateParticleListScreen(prevScreen), particle, particle);
        }));
        for (ModConfig.ParticleOptions opts : ModConfig.CONFIG.customParticles) {
            ModConfig.ParticleOptions defaultParticle = new ModConfig.ParticleOptions();
            for (ModConfig.ParticleOptions defaultParticle1 : ModConfig.DEFAULT.customParticles) {
                if (!opts.id.equals(defaultParticle1.id)) continue;
                defaultParticle = defaultParticle1;
            }
            ModConfig.ParticleOptions finalDefaultParticle = defaultParticle;
            options.add((Option<?>)LabelOption.create((class_2561)class_2561.method_43470((String)"")));
            ButtonOption editButton = ConfigScreens.getScreenButtonOption((class_2561)class_2561.method_43470((String)opts.id), "", () -> {
                screenToOpen = ConfigScreens.generateEditScreen(class_310.method_1551().field_1755, opts, finalDefaultParticle);
            });
            if (opts.id.equals("rain_splashing") || opts.id.equals("rain_ripples") || opts.id.equals("rain_smoke") || opts.id.equals("shrubs")) {
                editButton.setAvailable(false);
            }
            options.add((Option<?>)editButton);
            options.add((Option<?>)ConfigScreens.getScreenButtonOption((class_2561)class_2561.method_43471((String)"selectWorld.delete").method_27692(class_124.field_1061), "", () -> {
                ModConfig.CONFIG.customParticles.remove(opts);
                ModConfig.saveConfig();
                screenToOpen = ConfigScreens.generateParticleListScreen(prevScreen);
            }));
        }
        return ConfigScreens.generateScreen("editParticles", null, options, () -> ConfigScreens.generateParticleListScreen(prevScreen), prevScreen);
    }

    public static class_437 generateEditScreen(class_437 prevScreen, Object configObject, Object defaultObject) {
        return ConfigScreens.generateScreen("category.edit", null, ConfigScreens.collectOptions(defaultObject, configObject), () -> ConfigScreens.generateEditScreen(prevScreen, configObject, defaultObject), prevScreen);
    }

    private static ButtonOption getScreenButtonOption(class_2561 name, String text, Runnable runnable) {
        return ButtonOption.createBuilder().name(name).text((class_2561)class_2561.method_43470((String)text)).action((yaclScreen, buttonOption) -> {
            runnable.run();
            class_310.method_1551().method_1507(screenToOpen);
        }).build();
    }

    static <T> ButtonOption getListButtonOption(Object instance, Field field, ListOption<T> listOption) {
        Object listText = "";
        try {
            listText = field.get(instance).toString();
        }
        catch (IllegalAccessException e) {
            ParticleRain.LOGGER.error(e.getMessage());
        }
        if (((String)listText).length() > 42) {
            listText = ((String)listText).substring(0, 42) + "...";
        }
        return ConfigScreens.getScreenButtonOption(ConfigScreens.getComponent(instance.getClass().getSimpleName() + "." + field.getName()), (String)listText, () -> {
            screenToOpen = ConfigScreens.generateScreen("editList", List.of(listOption), null, null, class_310.method_1551().field_1755);
        });
    }

    static OptionGroup getParticleToggles() {
        ArrayList<Object> options = new ArrayList<Object>();
        options.add(ConfigScreens.getScreenButtonOption(ConfigScreens.getComponent("editParticles"), "", () -> {
            screenToOpen = ConfigScreens.generateParticleListScreen(class_310.method_1551().field_1755);
        }));
        for (ModConfig.ParticleOptions particle : ModConfig.CONFIG.customParticles) {
            try {
                options.add(ConfigScreens.getBoolOption(new ModConfig.ParticleOptions(), particle, particle.getClass().getField("enabled")).name(ConfigScreens.getComponent(particle.id)).build());
            }
            catch (NoSuchFieldException e) {
                ParticleRain.LOGGER.error(e.getMessage());
            }
        }
        return OptionGroup.createBuilder().name(ConfigScreens.getComponent("particleToggles")).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigScreens.getComponentWithFallback("particles.description")})).options(options).build();
    }

    static List<OptionGroup> collectGroups(Object defaultInstance, Object instance) {
        Field[] fields;
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        for (Field field : fields = instance.getClass().getFields()) {
            if (!field.isAnnotationPresent(ModConfig.Group.class)) continue;
            field.setAccessible(true);
            try {
                groups.add(OptionGroup.createBuilder().name(ConfigScreens.getComponent(field.getType().getSimpleName())).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigScreens.getComponentWithFallback(field.getName() + ".description")})).options(ConfigScreens.collectOptions(field.get(defaultInstance), field.get(instance))).build());
            }
            catch (IllegalAccessException e) {
                ParticleRain.LOGGER.error(e.toString());
            }
        }
        return groups;
    }

    static List<Option<?>> collectOptions(Object defaultInstance, Object instance) {
        Field[] fields;
        ArrayList options = new ArrayList();
        for (Field field : fields = instance.getClass().getFields()) {
            if (field.isAnnotationPresent(ModConfig.NoGUI.class) || field.isAnnotationPresent(ModConfig.Group.class)) continue;
            if (field.isAnnotationPresent(ModConfig.Label.class)) {
                options.add((Option<?>)LabelOption.create((class_2561)ConfigScreens.getComponent(instance.getClass().getSimpleName() + "." + field.getDeclaredAnnotation(ModConfig.Label.class).key())));
            }
            field.setAccessible(true);
            Class<?> type = field.getType();
            if (type.equals(Boolean.TYPE)) {
                options.add(ConfigScreens.getBoolOption(defaultInstance, instance, field).build());
                continue;
            }
            if (type.equals(Float.TYPE)) {
                if (field.getDeclaredAnnotation(ModConfig.Percentage.class) != null) {
                    options.add(ConfigScreens.getPercentOption(defaultInstance, instance, field));
                    continue;
                }
                options.add(ConfigScreens.getFloatOption(defaultInstance, instance, field));
                continue;
            }
            if (type.equals(Integer.TYPE)) {
                options.add(ConfigScreens.getIntOption(defaultInstance, instance, field));
                continue;
            }
            if (type.equals(String.class)) {
                options.add(ConfigScreens.getStringOption(defaultInstance, instance, field));
                continue;
            }
            if (type.isEnum()) {
                options.add(ConfigScreens.getEnumOption(defaultInstance, instance, field, type));
                continue;
            }
            if (type.equals(URI.class)) {
                options.add((Option<?>)ConfigScreens.getLinkButtonOption(instance, field));
                continue;
            }
            if (type.equals(Color.class)) {
                options.add(ConfigScreens.getColorOption(defaultInstance, instance, field));
                continue;
            }
            if (type.equals(List.class)) {
                Object listOption;
                Class listType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                if (listType.equals(String.class)) {
                    listOption = ConfigScreens.getStringListOption(defaultInstance, instance, field);
                } else if (listType.isEnum()) {
                    listOption = ConfigScreens.getEnumListOption(defaultInstance, instance, field, listType);
                } else {
                    listOption = null;
                    ParticleRain.LOGGER.error("Unable to create list for field {}", (Object)field.getName());
                }
                if (listOption == null) continue;
                options.add((Option<?>)ConfigScreens.getListButtonOption(instance, field, listOption));
                continue;
            }
            ParticleRain.LOGGER.error("Unable to create option for field {}", (Object)field.getName());
        }
        options.add((Option<?>)LabelOption.create((class_2561)class_5244.field_39003));
        return options;
    }

    private static ButtonOption getLinkButtonOption(Object instance, Field field) {
        String groupName = instance.getClass().getSimpleName();
        if (instance.getClass().isAnnotationPresent(ModConfig.OverrideName.class)) {
            groupName = instance.getClass().getAnnotation(ModConfig.OverrideName.class).newName();
        }
        String fieldName = field.getName();
        try {
            return ButtonOption.createBuilder().name(ConfigScreens.getComponent(groupName + "." + fieldName)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)field.get(instance).toString())})).text((class_2561)class_2561.method_43470((String)"")).action((yaclScreen, buttonOption) -> {
                class_310 minecraft = class_310.method_1551();
                try {
                    minecraft.method_1507((class_437)new class_407(result -> {
                        try {
                            if (result) {
                                class_156.method_668().method_673((URI)field.get(instance));
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                        minecraft.method_1507((class_437)yaclScreen);
                    }, field.get(instance).toString(), true));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }).build();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Option<Color> getColorOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(ColorControllerBuilder::create).build();
    }

    private static <T extends Enum<T>> Option<T> getEnumOption(Object defaultInstance, Object instance, Field field, Class<?> eClass) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(eClass)).build();
    }

    private static <T extends Enum<T>> ListOption<T> getEnumListOption(Object defaultInstance, Object instance, Field field, Class<?> eClass) {
        return ConfigScreens.getListOptionBuilder(defaultInstance, instance, field).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(eClass)).build();
    }

    private static ListOption<String> getStringListOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getListOptionBuilder(defaultInstance, instance, field).controller(StringControllerBuilder::create).initial((Object)"").build();
    }

    private static Option.Builder<Boolean> getBoolOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(opt -> {
            if (field.isAnnotationPresent(ModConfig.BooleanFormat.class)) {
                return BooleanControllerBuilder.create((Option)opt).formatValue(val -> ConfigScreens.getComponent(val != false ? field.getAnnotation(ModConfig.BooleanFormat.class).t() : field.getAnnotation(ModConfig.BooleanFormat.class).f()));
            }
            return BooleanControllerBuilder.create((Option)opt).coloured(true);
        });
    }

    private static Option<Float> getFloatOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(opt -> FloatFieldControllerBuilder.create((Option)opt).formatValue(val -> class_2561.method_43470((String)val.toString()))).build();
    }

    private static Option<Float> getPercentOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.01f))).formatValue(val -> class_2561.method_43470((String)NumberFormat.getPercentInstance().format(val)))).build();
    }

    private static Option<Integer> getIntOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(IntegerFieldControllerBuilder::create).build();
    }

    private static Option<String> getStringOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(StringControllerBuilder::create).build();
    }

    private static <T> Option.Builder<T> getOptionBuilder(Object defaultInstance, Object instance, Field field) {
        String groupName = instance.getClass().getSimpleName();
        if (instance.getClass().isAnnotationPresent(ModConfig.OverrideName.class)) {
            groupName = instance.getClass().getAnnotation(ModConfig.OverrideName.class).newName();
        }
        String fieldName = field.getName();
        Binding<T> binding = ConfigScreens.getBinding(defaultInstance, instance, field);
        Option.Builder optionBuilder = Option.createBuilder().name(ConfigScreens.getComponent(groupName + "." + fieldName)).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigScreens.getComponentWithFallback(groupName + "." + fieldName + ".description")}));
        if (field.getDeclaredAnnotation(ModConfig.ReloadsResources.class) != null) {
            optionBuilder.flag(new OptionFlag[]{OptionFlag.ASSET_RELOAD}).binding(binding);
        } else {
            optionBuilder.stateManager(StateManager.createInstant(binding));
        }
        return optionBuilder;
    }

    private static <T> ListOption.Builder<T> getListOptionBuilder(Object defaultGroup, Object group, Field field) {
        String groupName = group.getClass().getSimpleName();
        String fieldName = field.getName();
        return ListOption.createBuilder().name(ConfigScreens.getComponent(groupName + "." + fieldName)).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigScreens.getComponentWithFallback(groupName + "." + fieldName + ".description")})).binding(ConfigScreens.getBinding(defaultGroup, group, field)).initial(() -> {
            try {
                Field defaultField = defaultGroup.getClass().getField(field.getName());
                defaultField.setAccessible(true);
                return ((List)defaultField.get(defaultGroup)).get(0);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static <T> Binding<T> getBinding(Object defaultGroup, Object group, Field field) {
        Object defaultValue;
        try {
            Field defaultField = defaultGroup.getClass().getField(field.getName());
            defaultField.setAccessible(true);
            defaultValue = defaultField.get(defaultGroup);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return Binding.generic((Object)defaultValue, () -> {
            try {
                return field.get(group);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }, newVal -> {
            try {
                field.set(group, newVal);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected static class_2561 getComponent(String translationKey) {
        return class_2561.method_43471((String)("particlerain." + translationKey));
    }

    private static class_2561 getComponentWithFallback(String translationKey) {
        return class_2561.method_48321((String)("particlerain." + translationKey), (String)"");
    }

    static {
        lastScreenInitialized = "";
    }
}

