/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.other;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public record FloatSelector<T>(List<Entry<T>> entries) {
    public T select(float value) {
        float diff = Float.POSITIVE_INFINITY;
        Entry<T> curr = this.entries.getLast();
        for (Entry<T> entry : this.entries) {
            float d = Math.abs(entry.valueForPass - value);
            if (!(d < diff)) continue;
            curr = entry;
            diff = d;
        }
        return curr.result();
    }

    public static <T> FloatSelector<T> of(T result) {
        return new FloatSelector<T>(List.of(Entry.of(result)));
    }

    public static <T> FloatSelector<T> of(float min, float max, T ... results) {
        ArrayList<Entry<T>> list = new ArrayList<Entry<T>>(results.length);
        for (int i = 0; i < results.length; ++i) {
            list.add(new Entry<T>(min + (max - min) * (float)i / (float)(results.length - 1), results[i]));
        }
        return new FloatSelector<T>(list);
    }

    public static <T> Codec<FloatSelector<T>> createSingularCodec(Codec<T> codec) {
        return codec.xmap(FloatSelector::of, x -> x.entries.getFirst().result);
    }

    public static <T> Codec<FloatSelector<T>> createQualityCodec(Codec<T> codec, T defaultValue) {
        return FloatSelector.createCodec(0.0f, 10.0f, codec, defaultValue);
    }

    public static <T> Codec<FloatSelector<T>> createCodec(final float min, final float max, final Codec<T> codec, final T defaultValue) {
        Codec entryFull = RecordCodecBuilder.create(instaince -> instaince.group((App)Codec.FLOAT.optionalFieldOf("for", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(Entry::valueForPass), (App)codec.fieldOf("result").forGetter(Entry::result)).apply((Applicative)instaince, Entry::new));
        final Codec entryFullList = entryFull.listOf();
        final Codec entryList = Codec.either((Codec)entryFull, codec).listOf();
        return new Codec<FloatSelector<T>>(){

            public <D> DataResult<Pair<FloatSelector<T>, D>> decode(DynamicOps<D> ops, D input) {
                DataResult value = codec.decode(ops, input);
                if (value.isSuccess()) {
                    return value.map(x -> x.mapFirst(FloatSelector::of));
                }
                DataResult result = entryList.decode(ops, input);
                if (result.isError() && defaultValue != null) {
                    return DataResult.success((Object)new Pair(FloatSelector.of(defaultValue), input));
                }
                return result.map(x -> x.mapFirst(list -> {
                    ArrayList out = new ArrayList();
                    for (int i = 0; i < list.size(); ++i) {
                        Either next;
                        Either either = (Either)list.get(i);
                        if (either.left().isPresent()) {
                            out.add((Entry)either.left().get());
                            continue;
                        }
                        if (i == 0) {
                            out.add(new Entry(min, either.right().get()));
                            continue;
                        }
                        if (i == list.size() - 1) {
                            out.add(new Entry(max, either.right().get()));
                            continue;
                        }
                        float previous = out.get((int)(i - 1)).valueForPass;
                        float nextValue = max;
                        int nextPos = list.size() - 1;
                        for (int b = i + 1; b < list.size(); ++b) {
                            next = (Either)list.get(b);
                            if (!next.left().isPresent()) continue;
                            nextValue = ((Entry)next.left().get()).valueForPass;
                            nextPos = b;
                        }
                        float val = (nextValue - previous) / (float)(nextPos - i + 1);
                        while (i < nextPos) {
                            next = (Either)list.get(i);
                            out.add(new Entry(previous + val * (float)i, next.right().get()));
                            ++i;
                        }
                        --i;
                    }
                    out.sort(Comparator.comparing(Entry::valueForPass));
                    return new FloatSelector(out);
                }));
            }

            public <D> DataResult<D> encode(FloatSelector<T> input, DynamicOps<D> ops, D prefix) {
                if (input.entries.size() == 1) {
                    return codec.encode(input.entries.getFirst().result, ops, prefix);
                }
                return entryFullList.encode(input.entries(), ops, prefix);
            }
        };
    }

    public record Entry<T>(float valueForPass, T result) {
        public static <T> Entry<T> of(T result) {
            return new Entry<T>(Float.NEGATIVE_INFINITY, result);
        }
    }
}

