/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.mixin;

import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.item.BrewComponents;
import eu.pb4.brewery.item.BrewItems;
import eu.pb4.brewery.item.IngredientMixtureItem;
import eu.pb4.brewery.item.comp.BrewData;
import eu.pb4.brewery.item.comp.CookingData;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1845;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2589;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2589.class})
public abstract class BrewingStandBlockEntityMixin
implements class_1263 {
    @Inject(method={"canCraft"}, at={@At(value="HEAD")}, cancellable=true)
    private static void brewery$canCraft(class_1845 brewingRecipeRegistry, class_2371<class_1799> slots, CallbackInfoReturnable<Boolean> cir) {
        if (((class_1799)slots.get(3)).method_7960()) {
            for (int i = 0; i < 3; ++i) {
                if (!DrinkUtils.canBeDistillated((class_1799)slots.get(i))) continue;
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"craft"}, at={@At(value="HEAD")}, cancellable=true)
    private static void brewery$craft(class_1937 world, class_2338 pos, class_2371<class_1799> slots, CallbackInfo ci) {
        if (((class_1799)slots.get(3)).method_7960()) {
            for (int i = 0; i < 3; ++i) {
                class_1799 stack = (class_1799)slots.get(i);
                if (!DrinkUtils.canBeDistillated(stack)) continue;
                if (stack.method_31574(BrewItems.INGREDIENT_MIXTURE)) {
                    List<class_1799> ingredients = IngredientMixtureItem.getIngredients(stack);
                    List<DrinkType> types = DrinkUtils.findTypes(ingredients, null, DrinkUtils.getHeatSource(stack), DrinkUtils.getContainer(stack));
                    if (types.isEmpty()) {
                        slots.set(i, (Object)stack.method_56701((class_1935)BrewItems.FAILED_DRINK_ITEM, stack.method_7947()));
                        continue;
                    }
                    double quality = Double.MIN_VALUE;
                    DrinkType match = null;
                    for (DrinkType type : types) {
                        double q;
                        if (!type.requireDistillation() || !((q = type.cookingQualityMult().expression().setVariable("age", ((CookingData)stack.method_58695(BrewComponents.COOKING_DATA, (Object)CookingData.DEFAULT)).time() / 20.0).evaluate()) > quality)) continue;
                        quality = q;
                        match = type;
                    }
                    if (match == null || quality < 0.0) {
                        slots.set(i, (Object)stack.method_56701((class_1935)BrewItems.FAILED_DRINK_ITEM, stack.method_7947()));
                        continue;
                    }
                    class_1799 drink = new class_1799((class_1935)BrewItems.DRINK_ITEM);
                    drink.method_57379(BrewComponents.COOKING_DATA, (Object)((CookingData)stack.method_58694(BrewComponents.COOKING_DATA)));
                    drink.method_57379(BrewComponents.BREW_DATA, (Object)new BrewData(Optional.of(BreweryInit.DRINK_TYPE_ID.get(match)), quality * 10.0, "", 1, 0.0));
                    slots.set(i, (Object)drink);
                    continue;
                }
                stack.method_57368(BrewComponents.BREW_DATA, (Object)BrewData.DEFAULT, BrewData::distillate);
            }
            world.method_20290(1035, pos, 0);
            ci.cancel();
        }
    }

    @Inject(method={"isValid"}, at={@At(value="TAIL")}, cancellable=true)
    private void brewery$isValid(int slot, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (DrinkUtils.canBeDistillated(stack)) {
            cir.setReturnValue((Object)this.method_5438(slot).method_7960());
        }
    }
}

