/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.item;

import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.item.BrewComponents;
import eu.pb4.brewery.item.comp.CookingData;
import eu.pb4.brewery.other.BrewGameRules;
import eu.pb4.brewery.other.BrewUtils;
import eu.pb4.polymer.core.api.item.PolymerItem;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class IngredientMixtureItem
extends class_1792
implements PolymerItem {
    public IngredientMixtureItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static List<class_1799> getIngredients(class_1799 stack) {
        if (stack.method_57826(BrewComponents.COOKING_DATA)) {
            return Objects.requireNonNull((CookingData)stack.method_58694(BrewComponents.COOKING_DATA)).ingredients();
        }
        return List.of();
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        class_3218 world = BreweryInit.getOverworld();
        if (stack.method_57826(BrewComponents.COOKING_DATA) && world != null && world.method_64395().method_8355(BrewGameRules.SHOW_AGE)) {
            double time = Objects.requireNonNull((CookingData)stack.method_58694(BrewComponents.COOKING_DATA)).time();
            double mult = ((DoubleRule)world.method_64395().method_20746(BrewGameRules.CAULDRON_COOKING_TIME_MULTIPLIER)).get();
            double age = DrinkUtils.getAgeInSeconds(stack) / mult;
            if (age > 0.0) {
                textConsumer.accept((class_2561)class_2561.method_43469((String)"text.brewery.age", (Object[])new Object[]{BrewUtils.fromTimeShort(age).method_27692(class_124.field_1080)}));
            }
            textConsumer.accept((class_2561)class_2561.method_43469((String)"text.brewery.cooked_for", (Object[])new Object[]{BrewUtils.fromTimeShort(time / 20.0 / mult).method_27692(class_124.field_1080)}));
            for (class_1799 ingredient : IngredientMixtureItem.getIngredients(stack)) {
                textConsumer.accept((class_2561)class_2561.method_43473().method_27693("" + ingredient.method_7947()).method_27693(" \u00d7 ").method_10852(ingredient.method_7964()).method_27692(class_124.field_1080));
            }
        }
    }

    public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
        return class_1802.field_47315;
    }

    @Nullable
    public class_2960 getPolymerItemModel(class_1799 stack, PacketContext context) {
        class_2960 model = BreweryInit.CONTAINER_TO_INGMIX_MODEL.get(DrinkUtils.getContainer(stack).method_7909());
        if (model != null) {
            return model;
        }
        return (class_2960)class_1802.field_8574.method_57347().method_58694(class_9334.field_54199);
    }

    public void modifyBasePolymerItemStack(class_1799 out, class_1799 stack, PacketContext context) {
        out.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.of(3694022), List.of(), Optional.empty()));
        out.method_57379(class_9334.field_49637, (Object)new class_9280((List)FloatList.of((float[])new float[]{(float)DrinkUtils.getQuality(stack), (float)DrinkUtils.getAgeInSeconds(stack), (float)DrinkUtils.getCookingAgeInSeconds(stack), DrinkUtils.getDistillationCount(stack)}), (List)BooleanList.of((boolean)false, (boolean)DrinkUtils.getDistillationStatus(stack)), List.of("", DrinkUtils.getBarrelType(stack), "mixture"), (List)IntList.of((int)3694022, (int)3694022)));
    }
}

