/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.item;

import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.drink.AlcoholManager;
import eu.pb4.brewery.drink.ConsumptionEffect;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.item.BrewComponents;
import eu.pb4.brewery.item.comp.BrewData;
import eu.pb4.brewery.item.comp.CookingData;
import eu.pb4.brewery.other.BrewGameRules;
import eu.pb4.brewery.other.BrewUtils;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_10124;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class DrinkItem
extends class_1792
implements PolymerItem {
    public DrinkItem(class_1792.class_1793 settings) {
        super(settings.method_7889(1).method_57349(class_9334.field_53964, (Object)new class_10124(1.6f, class_1839.field_8946, (class_6880)class_3417.field_20613, false, List.of())));
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        DrinkType type = DrinkUtils.getType(stack);
        if (type == null) {
            return 96;
        }
        return (int)(type.drinkingTime(stack, user) * 20.0);
    }

    public class_1839 method_7853(class_1799 stack) {
        DrinkType type = DrinkUtils.getType(stack);
        if (type == null) {
            return class_1839.field_8946;
        }
        return type.visuals(stack).animation();
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_1657 playerEntity;
        class_1657 class_16572 = playerEntity = user instanceof class_1657 ? (class_1657)user : null;
        if (playerEntity instanceof class_3222) {
            class_174.field_1198.method_8821((class_3222)playerEntity, stack);
        }
        if (!world.field_9236) {
            try {
                DrinkType type = DrinkUtils.getType(stack);
                if (type != null) {
                    double age = DrinkUtils.getAgeInSeconds(stack);
                    double quality = DrinkUtils.getQuality(stack);
                    double alcoholicValue = type.alcoholicValue().expression().setVariable("age", age).setVariable("quality", quality).evaluate();
                    AlcoholManager.of(user).drink(type, quality, alcoholicValue);
                    for (ConsumptionEffect effect : type.isFinished(stack) ? type.consumptionEffects() : type.unfinishedEffects()) {
                        effect.apply(user, age, quality);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (playerEntity != null) {
            playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
        user.method_32876((class_6880)class_5712.field_28734);
        CookingData cookingData = (CookingData)stack.method_58694(BrewComponents.COOKING_DATA);
        stack.method_57008(1, (class_1309)playerEntity);
        if (!(playerEntity != null && playerEntity.method_68878() || cookingData == null)) {
            if (stack.method_7960()) {
                return cookingData.container().method_7972();
            }
            if (playerEntity != null) {
                playerEntity.method_31548().method_7394(cookingData.container().method_7972());
            }
        }
        return stack;
    }

    public class_2561 method_7864(class_1799 stack) {
        DrinkType type = DrinkUtils.getType(stack);
        if (type != null) {
            if (type.isFinished(stack)) {
                return type.name(stack).text();
            }
            return class_2561.method_43469((String)"item.brewery.ingredient_mixture_specific", (Object[])new Object[]{type.name(stack).text()});
        }
        DrinkType id = DrinkUtils.getType(stack);
        Object text = id != null ? id.name(stack).text() : class_2561.method_43470((String)"<Unknown>");
        return class_2561.method_43469((String)this.method_7876(), (Object[])new Object[]{text});
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 typex) {
        class_3218 world = BreweryInit.getOverworld();
        if (world != null) {
            DrinkType type = DrinkUtils.getType(stack);
            if (type != null && type.showQuality() && world.method_64395().method_8355(BrewGameRules.SHOW_QUALITY)) {
                double starCount;
                double quality = DrinkUtils.getQuality(stack);
                StringBuilder stars = new StringBuilder();
                StringBuilder antistars = new StringBuilder();
                for (starCount = (double)Math.round(quality / 2.0 * 10.0) / 10.0; starCount >= 1.0; starCount -= 1.0) {
                    stars.append("\u2b50");
                }
                if (starCount > 0.0) {
                    stars.append("\u2606");
                }
                int starsLeft = 5 - stars.length();
                for (int i = 0; i < starsLeft; ++i) {
                    antistars.append("\u2606");
                }
                textConsumer.accept((class_2561)class_2561.method_43469((String)"text.brewery.quality", (Object[])new Object[]{class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)stars.toString()).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)antistars.toString()).method_27692(class_124.field_1063))}));
            }
            if (world.method_64395().method_8355(BrewGameRules.SHOW_AGE)) {
                double mult = world != null ? ((DoubleRule)world.method_64395().method_20746(BrewGameRules.BARREL_AGING_MULTIPLIER)).get() : 1.0;
                double age = DrinkUtils.getAgeInSeconds(stack) / mult;
                if (age > 0.0) {
                    textConsumer.accept((class_2561)class_2561.method_43469((String)"text.brewery.age", (Object[])new Object[]{BrewUtils.fromTimeShort(age).method_27692(class_124.field_1080)}));
                }
            }
            if (BreweryInit.DISPLAY_DEV) {
                textConsumer.accept((class_2561)class_2561.method_43470((String)"== DEV ==").method_27692(class_124.field_1075));
                textConsumer.accept((class_2561)class_2561.method_43470((String)"BrewType: ").method_27693(((BrewData)stack.method_58695(BrewComponents.BREW_DATA, (Object)BrewData.DEFAULT)).type().toString()).method_27692(class_124.field_1080));
                textConsumer.accept((class_2561)class_2561.method_43470((String)"BrewQuality: ").method_27693("" + DrinkUtils.getQuality(stack)).method_27692(class_124.field_1080));
                textConsumer.accept((class_2561)class_2561.method_43470((String)"BrewAge: ").method_27693("" + DrinkUtils.getAgeInTicks(stack)).method_27692(class_124.field_1080));
                textConsumer.accept((class_2561)class_2561.method_43470((String)"BrewDistillated: ").method_27693("" + DrinkUtils.getDistillationStatus(stack)).method_27692(class_124.field_1080));
            }
        }
    }

    public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
        return class_1802.field_47315;
    }

    public void modifyBasePolymerItemStack(class_1799 out, class_1799 stack, PacketContext context) {
        DrinkType type = DrinkUtils.getType(stack);
        if (type != null) {
            int color = type.color(stack);
            DrinkType.ItemLookData visual = type.visuals(stack);
            out.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.of(color), List.of(), Optional.empty()));
            if (visual.components().isPresent()) {
                out.method_57365(visual.components().get());
            }
            out.method_57379(class_9334.field_49637, (Object)new class_9280((List)FloatList.of((float[])new float[]{(float)DrinkUtils.getQuality(stack), (float)DrinkUtils.getAgeInSeconds(stack), (float)DrinkUtils.getCookingAgeInSeconds(stack), DrinkUtils.getDistillationCount(stack)}), (List)BooleanList.of((boolean)type.isFinished(stack), (boolean)DrinkUtils.getDistillationStatus(stack)), List.of(DrinkUtils.getTypeId(stack).toString(), DrinkUtils.getBarrelType(stack), type.isFinished(stack) ? "finished_drink" : "unfinished_drink"), (List)IntList.of((int)color, (int)color)));
            out.method_57379(class_9334.field_53964, (Object)new class_10124((float)type.drinkingTime(stack, (class_1309)context.getPlayer()), visual.animation(), visual.soundEvent(), visual.particles(), List.of()));
        } else {
            out.method_57379(class_9334.field_49637, (Object)new class_9280((List)FloatList.of((float[])new float[]{(float)DrinkUtils.getQuality(stack), (float)DrinkUtils.getAgeInSeconds(stack), (float)DrinkUtils.getCookingAgeInSeconds(stack), DrinkUtils.getDistillationCount(stack)}), (List)BooleanList.of((boolean)false, (boolean)DrinkUtils.getDistillationStatus(stack)), List.of("", DrinkUtils.getBarrelType(stack), "unknown_drink"), (List)IntList.of((int)3694022, (int)3694022)));
        }
    }

    @Nullable
    public class_2960 getPolymerItemModel(class_1799 stack, PacketContext context) {
        DrinkType type = DrinkUtils.getType(stack);
        if (type != null) {
            DrinkType.ItemLookData visuals = type.visuals(stack);
            return visuals.resourcePackModel().isPresent() && PolymerResourcePackUtils.hasMainPack((PacketContext)context) ? visuals.resourcePackModel().get() : visuals.defaultModel();
        }
        return (class_2960)class_1802.field_8574.method_57347().method_58694(class_9334.field_54199);
    }
}

