/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.item;

import eu.pb4.brewery.GenericModInfo;
import eu.pb4.brewery.drink.DrinkInfo;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.item.BrewComponents;
import eu.pb4.brewery.other.BrewUtils;
import eu.pb4.brewery.other.WrappedText;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import eu.pb4.sgui.api.gui.BookGui;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class BookOfBreweryItem
extends class_1792
implements PolymerItem {
    public BookOfBreweryItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            new Gui(player, hand).open();
            return class_1269.field_52422;
        }
        return super.method_7836(world, user, hand);
    }

    public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
        return class_1802.field_8360;
    }

    @Nullable
    public class_2960 getPolymerItemModel(class_1799 stack, PacketContext context) {
        return null;
    }

    public static void build(Collection<Map.Entry<class_2960, DrinkType>> input, double barrelAgingMultiplier, double cookingTimeMultiplier) {
        BookElementBuilder builder = new BookElementBuilder();
        Gui.BOOKS.clear();
        List<Map.Entry> types = input.stream().filter(x -> ((DrinkType)x.getValue()).info().isPresent()).sorted(Comparator.comparing(x -> ((DrinkType)x.getValue()).looks().nameSelector().select(7.0f).text().getString())).toList();
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("brewery").get();
        ArrayList<String> contributors = new ArrayList<String>();
        contributors.addAll(container.getMetadata().getAuthors().stream().map(Person::getName).toList());
        contributors.addAll(container.getMetadata().getContributors().stream().map(Person::getName).toList());
        builder.addPage(new class_2561[]{class_2564.method_37112(List.of(GenericModInfo.getIconBook()), (class_2561)class_2561.method_43470((String)"\n")), class_2561.method_43473(), class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"item.brewery.book_of_brewery").method_10862(class_2583.field_24360.method_65302(class_9848.method_61321((int)class_124.field_1058.method_532(), (float)0.6f) | 0xFF000000)).method_27695(new class_124[]{class_124.field_1067, class_124.field_1073, class_124.field_1078})).method_10852((class_2561)class_2561.method_43470((String)" \ud83e\uddea").method_27692(class_124.field_1079)), class_2561.method_43473(), class_2561.method_43471((String)"text.brewery.about.version").method_27692(class_124.field_1077).method_10852((class_2561)class_2561.method_43470((String)container.getMetadata().getVersion().getFriendlyString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1063))), class_2561.method_43473(), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43469((String)"[%s]", (Object[])new Object[]{class_2561.method_43471((String)"text.brewery.about.contributors")}).method_10862(class_2583.field_24360.method_10977(class_124.field_1062).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)String.join((CharSequence)", ", contributors)))))).method_27693("").method_10862(class_2583.field_24360.method_10977(class_124.field_1063))});
        builder.addPage(new class_2561[]{class_2561.method_43471((String)"polydex.brewery.cooking_cauldron").method_27695(new class_124[]{class_124.field_1067, class_124.field_1073, class_124.field_1060}), class_2561.method_43473(), class_2561.method_43471((String)"polydex.brewery.cooking_cauldron.text")});
        builder.addPage(new class_2561[]{class_2561.method_43471((String)"polydex.brewery.aging_with_barrel").method_27695(new class_124[]{class_124.field_1067, class_124.field_1073, class_124.field_1079}), class_2561.method_43473(), class_2561.method_43471((String)"polydex.brewery.aging_with_barrel.text")});
        builder.addPage(new class_2561[]{class_2561.method_43471((String)"polydex.brewery.building_barrel").method_27695(new class_124[]{class_124.field_1067, class_124.field_1073, class_124.field_1065}), class_2561.method_43473(), class_2561.method_43470((String)"\u00a78 1\u00a7f\u23f9\u00a7a\u23f9\u00a7f\u23f9\u23f9\u00a7a\u23f9   \u00a78|   2\u00a7f\u23f9\u00a7b\u23f9\u23f9\u23f9\u23f9"), class_2561.method_43470((String)"\u00a7f \u23f9\u23f9\u23f9\u23f9\u23f9\u23f9   \u00a78|   \u00a7f\u23f9\u23f9\u00a7c\u23f9\u23f9\u23f9\u23f9"), class_2561.method_43470((String)"\u00a7f \u23f9\u23f9\u00a7a\u23f9\u00a7f\u23f9\u23f9\u00a7a\u23f9   \u00a78|   \u00a7f\u23f9\u23f9\u00a7b\u23f9\u23f9\u23f9\u23f9"), class_2561.method_43470((String)"\u00a78 -----------------"), class_2561.method_43470((String)"\u00a78 3\u00a7f\u23f9\u00a7c\u23f9\u23f9\u23f9\u23f9   \u00a78|   4\u00a7f\u23f9\u00a7b\u23f9\u23f9\u23f9\u23f9"), class_2561.method_43470((String)"\u00a7f \u23f9\u00a7d\u23f9\u00a7c\u23f9\u00a7f\u23f9\u23f9\u00a7c\u23f9   \u00a78|   \u00a7f\u23f9\u23f9\u00a7c\u23f9\u23f9\u23f9\u23f9"), class_2561.method_43470((String)"\u00a7f \u23f9\u23f9\u00a7c\u23f9\u23f9\u23f9\u23f9   \u00a78|   \u00a7f\u23f9\u23f9\u00a7b\u23f9\u23f9\u23f9\u23f9"), class_2561.method_43471((String)"polydex.brewery.building_barrel.view"), class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00a7a\u23f9")).method_27693(" - ").method_10852((class_2561)class_2561.method_43471((String)"polydex.brewery.building_barrel.fence")), class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00a7b\u23f9")).method_27693(" - ").method_10852((class_2561)class_2561.method_43471((String)"polydex.brewery.building_barrel.stair")), class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00a7c\u23f9")).method_27693(" - ").method_10852((class_2561)class_2561.method_43471((String)"polydex.brewery.building_barrel.planks")), class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00a7d\u23f9")).method_27693(" - ").method_10852((class_2561)class_2561.method_43471((String)"block.brewery.barrel_spigot"))});
        builder.addPage(new class_2561[]{class_2561.method_43471((String)"polydex.brewery.distillation").method_27695(new class_124[]{class_124.field_1067, class_124.field_1073, class_124.field_1077}), class_2561.method_43473(), class_2561.method_43471((String)"polydex.brewery.distillation.text")});
        ArrayList<class_5250> indexEntries = new ArrayList<class_5250>();
        indexEntries.add(class_2561.method_43471((String)"polydex.brewery.recipes").method_27695(new class_124[]{class_124.field_1067, class_124.field_1073, class_124.field_1061}));
        indexEntries.add(class_2561.method_43473());
        for (Map.Entry e : types) {
            DrinkType type = (DrinkType)e.getValue();
            int index = -1;
            try {
                index = BookOfBreweryItem.buildInfo((class_2960)e.getKey(), (DrinkType)e.getValue(), barrelAgingMultiplier, cookingTimeMultiplier);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            if (index == -1) continue;
            int finalIndex = index;
            indexEntries.add(type.looks().nameSelector().select(7.0f).text().method_27661().method_27694(x -> x.method_10958((class_2558)new class_2558.class_10605(1001 + finalIndex)).method_30938(Boolean.valueOf(true))));
            if (indexEntries.size() != 12) continue;
            builder.addPage(indexEntries.toArray(new class_2561[0]));
            indexEntries.clear();
        }
        if (!indexEntries.isEmpty()) {
            builder.addPage(indexEntries.toArray(new class_2561[0]));
        }
        builder.setComponent(class_9334.field_49606, (Object)((class_9302)builder.getComponent(class_9334.field_49606)).method_57527());
        Gui.indexBook = builder.asStack();
    }

    private static int buildInfo(class_2960 id, DrinkType type, double barrelAgingMultiplier, double cookingTimeMultiplier) {
        BookElementBuilder builder = new BookElementBuilder();
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        list.add(class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\ud83e\uddea ").method_27694(x -> x.method_27703(type.looks().colorSelector().select(7.0f)))).method_10852((class_2561)type.looks().nameSelector().select(7.0f).text().method_27661().method_27694(x -> x.method_10982(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)))));
        list.add(class_2561.method_43473());
        DrinkInfo info = type.info().get();
        if (!type.ingredients().isEmpty()) {
            list.add(class_2561.method_43471((String)"polydex.brewery.ingredients").method_27694(x -> x.method_10982(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1065)));
            list.add(class_2561.method_43473());
            for (DrinkType.BrewIngredient i : type.ingredients()) {
                if (i.items().size() == 1) {
                    list.add(class_2561.method_43470((String)(i.count() + " \u00d7 ")).method_10852(i.items().get(0).method_63680()));
                    continue;
                }
                class_5250 class_52502 = class_2561.method_43471((String)"polydex.brewery.any_of").method_27693("\n");
                for (class_1792 item : i.items()) {
                    class_52502.method_10852(item.method_63680()).method_27693("\n");
                }
                list.add(class_2561.method_43470((String)(i.count() + " \u00d7 ")).method_10852((class_2561)class_2561.method_43471((String)"polydex.brewery.any_of_the_list").method_27692(class_124.field_1056)).method_10862(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10613((class_2561)class_52502))));
            }
            if (info.bestCookingTime() > 0.0) {
                list.add(class_2561.method_43473());
                list.add(class_2561.method_43469((String)"polydex.brewery.cook_for", (Object[])new Object[]{BrewUtils.fromTimeShort(info.bestCookingTime() / cookingTimeMultiplier)}));
            }
            list.add(class_2561.method_43473());
        }
        if (!type.barrelInfo().isEmpty() && !info.bestBarrelType().isEmpty()) {
            list.add(class_2561.method_43471((String)"polydex.brewery.aging").method_27695(new class_124[]{class_124.field_1073, class_124.field_1077, class_124.field_1067}));
            list.add(class_2561.method_43473());
            if (info.bestBarrelType().contains("*")) {
                list.add(class_2561.method_43471((String)"polydex.brewery.any_barrel"));
            } else if (info.bestBarrelType().size() == 1) {
                list.add(class_2561.method_43471((String)("container.brewery." + info.bestBarrelType().get(0) + "_barrel")));
            } else {
                list.add(class_2561.method_43471((String)"polydex.brewery.one_of_barrel"));
                for (String b : info.bestBarrelType()) {
                    list.add(class_2561.method_43471((String)("container.brewery." + b + "_barrel")));
                }
            }
            if (info.bestBarrelAge() > 0.0) {
                list.add(class_2561.method_43469((String)"polydex.brewery.age_in_barrel_for", (Object[])new Object[]{BrewUtils.fromTimeShort(info.bestBarrelAge() / barrelAgingMultiplier)}));
            }
            list.add(class_2561.method_43473());
        }
        if (type.requireDistillation()) {
            list.add(class_2561.method_43471((String)"polydex.brewery.require_distillation"));
            list.add(class_2561.method_43473());
        }
        ArrayList<class_2561> x2 = new ArrayList<class_2561>();
        for (class_2561 class_25612 : list) {
            x2.add(class_25612);
            if (x2.size() != 10) continue;
            builder.addPage(x2.toArray(new class_2561[0]));
            x2.clear();
        }
        if (!x2.isEmpty()) {
            builder.addPage(x2.toArray(new class_2561[0]));
            x2.clear();
        }
        for (WrappedText wrappedText : info.additionalInfo()) {
            builder.addPage((class_2561)wrappedText.text().method_27661());
        }
        builder.setTitle(id.toString());
        builder.setAuthor("Brewery");
        Gui.BOOKS.add(builder.asStack());
        return Gui.BOOKS.size() - 1;
    }

    public static final class Gui
    extends BookGui {
        public static final List<class_1799> BOOKS = new ArrayList<class_1799>();
        public static class_1799 indexBook;
        private final class_1799 stack;
        private final class_1268 hand;

        public Gui(class_3222 player, class_1268 hand) {
            super(player, indexBook);
            this.stack = player.method_5998(hand);
            this.hand = hand;
            this.setPage(Math.min((Integer)this.stack.method_58695(BrewComponents.BOOK_PAGE, (Object)0), ((class_9302)indexBook.method_58694(class_9334.field_49606)).method_57525(false).size()));
        }

        public void onTakeBookButton() {
            if (this.book != indexBook) {
                this.player.method_17356(class_3417.field_17481, class_3419.field_15245, 1.0f, 1.0f);
                Integer page = (Integer)this.stack.method_58695(BrewComponents.BOOK_PAGE, (Object)0);
                this.book = indexBook;
                this.screenHandler.method_7623();
                this.setPage(page);
            } else {
                this.close();
            }
        }

        public void setPage(int page) {
            this.player.method_17356(class_3417.field_17481, class_3419.field_15245, 1.0f, 1.0f);
            if (page >= 1000 && BOOKS.size() > page - 1000) {
                this.book = BOOKS.get(page - 1000);
                this.screenHandler.method_7623();
                super.setPage(0);
                return;
            }
            super.setPage(page);
            if (this.book == indexBook && this.stack == this.player.method_5998(this.hand)) {
                this.stack.method_57379(BrewComponents.BOOK_PAGE, (Object)page);
            }
        }
    }
}

