/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.drink;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import eu.pb4.brewery.drink.WrappedExpression;
import net.objecthunter.exp4j.function.Function;

public class ExpressionUtil {
    public static final String AGE_KEY = "age";
    public static final String QUALITY_KEY = "quality";
    public static final String USER_ALCOHOL_LEVEL_KEY = "userAlcoholLevel";
    public static final Codec<WrappedExpression> COMMON_EXPRESSION = ExpressionUtil.createCodec("age", "quality");
    public static final Codec<WrappedExpression> COMMON_CE_EXPRESSION = ExpressionUtil.createCodec("age", "quality", "userAlcoholLevel");
    public static final Function[] FUNCTIONS = new Function[]{new Function("max", 2){

        public double apply(double ... args) {
            return Math.max(args[0], args[1]);
        }
    }, new Function("min", 2){

        public double apply(double ... args) {
            return Math.min(args[0], args[1]);
        }
    }, new Function("closesTo", 3){

        public double apply(double ... args) {
            return Math.abs(args[0] - args[1]) < Math.abs(args[0] - args[2]) ? args[1] : args[2];
        }
    }, new Function("clamp", 3){

        public double apply(double ... args) {
            if (args[0] < args[1]) {
                return args[1];
            }
            if (args[0] > args[2]) {
                return args[2];
            }
            return args[0];
        }
    }, new Function("random", 0){

        public double apply(double ... args) {
            return Math.random();
        }
    }, ExpressionUtil.getQualFunc("defaultQualityFunction", 1200.0, 10.0), ExpressionUtil.getQualFunc("smooth_value_days", 1200.0, 1.0), ExpressionUtil.getQualFunc("smooth_value_minutes", 60.0, 1.0), ExpressionUtil.getQualFunc("smooth_value_seconds", 1.0, 1.0)};
    public static final WrappedExpression DEFAULT_DRINKING_TIME = WrappedExpression.createDefault("clamp(1.6 * (7 / (max(quality, 0.1))), 1.6, 4.8)");
    public static final WrappedExpression LEGACY_DRINKING_TIME = WrappedExpression.createDefault("1.6");

    private static Function getQualFunc(String name, final double timeScale, final double valueScale) {
        return new Function(name, 4){

            public double apply(double ... args) {
                double day = args[3] / timeScale;
                if (day <= 0.0) {
                    return 0.0;
                }
                if (day >= args[0] + args[1] + args[2]) {
                    return -1.0;
                }
                if (day >= args[0] && day <= args[0] + args[1]) {
                    return valueScale;
                }
                double x = day < args[0] ? day / Math.max(args[0], 0.001) : (args[2] + args[0] + args[1] - day) / Math.max(args[2], 0.001);
                return (3.0 * x * x - 2.0 * x * x * x) * valueScale;
            }
        };
    }

    public static String defaultQuality(double mcDaysIdeal, double lockedTime, double qualityFalloff) {
        return "smooth_value_days(" + mcDaysIdeal + ", " + lockedTime + ", " + qualityFalloff + ", age) * 10";
    }

    public static String defaultQuality(double mcDaysIdeal, double lockedTime) {
        return "smooth_value_days(" + mcDaysIdeal + ", " + lockedTime + ", " + mcDaysIdeal + ", age) * 10";
    }

    public static String defaultBoilingVodka(double minutesIdeal, double lockedTime) {
        return "smooth_value_minutes(" + minutesIdeal + ", " + lockedTime + ", " + minutesIdeal + ", age)";
    }

    public static String defaultBoiling(double minutes, double percent) {
        return "cos(clamp((age / 60 - " + minutes + ") * " + percent + ", -2, 2))";
    }

    public static Codec<WrappedExpression> createCodec(String ... args) {
        return Codec.STRING.comapFlatMap(string -> DataResult.success((Object)WrappedExpression.create(string, args)), x -> x.input());
    }
}

