/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.drink;

import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.item.BrewComponents;
import eu.pb4.brewery.item.BrewItems;
import eu.pb4.brewery.item.comp.BrewData;
import eu.pb4.brewery.item.comp.CookingData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DrinkUtils {
    @Nullable
    public static DrinkType getType(class_1799 stack) {
        if (stack.method_57826(BrewComponents.BREW_DATA) && Objects.requireNonNull((BrewData)stack.method_58694(BrewComponents.BREW_DATA)).type().isPresent()) {
            return BreweryInit.DRINK_TYPES.get(Objects.requireNonNull((BrewData)stack.method_58694(BrewComponents.BREW_DATA)).type().get());
        }
        return null;
    }

    @Nullable
    public static class_2960 getTypeId(class_1799 stack) {
        if (stack.method_57826(BrewComponents.BREW_DATA) && Objects.requireNonNull((BrewData)stack.method_58694(BrewComponents.BREW_DATA)).type().isPresent()) {
            return Objects.requireNonNull((BrewData)stack.method_58694(BrewComponents.BREW_DATA)).type().get();
        }
        return null;
    }

    public static double getQuality(class_1799 stack) {
        if (stack.method_57826(BrewComponents.BREW_DATA)) {
            return Objects.requireNonNull((BrewData)stack.method_58694(BrewComponents.BREW_DATA)).quality();
        }
        return -1.0;
    }

    public static String getBarrelType(class_1799 stack) {
        if (stack.method_57826(BrewComponents.BREW_DATA)) {
            return Objects.requireNonNull((BrewData)stack.method_58694(BrewComponents.BREW_DATA)).barrelType();
        }
        return "";
    }

    public static boolean getDistillationStatus(class_1799 stack) {
        DrinkType type;
        if (stack.method_57826(BrewComponents.BREW_DATA) && (type = DrinkUtils.getType(stack)) != null) {
            return Objects.requireNonNull((BrewData)stack.method_58694(BrewComponents.BREW_DATA)).distillations() >= type.distillationRuns();
        }
        return false;
    }

    public static int getDistillationCount(class_1799 stack) {
        if (stack.method_57826(BrewComponents.BREW_DATA)) {
            return Objects.requireNonNull((BrewData)stack.method_58694(BrewComponents.BREW_DATA)).distillations();
        }
        return 0;
    }

    public static class_2248 getHeatSource(class_1799 stack) {
        if (stack.method_57826(BrewComponents.COOKING_DATA)) {
            return Objects.requireNonNull((CookingData)stack.method_58694(BrewComponents.COOKING_DATA)).heatSource();
        }
        return class_2246.field_10036;
    }

    public static class_1799 getContainer(class_1799 stack) {
        if (stack.method_57826(BrewComponents.COOKING_DATA)) {
            return Objects.requireNonNull((CookingData)stack.method_58694(BrewComponents.COOKING_DATA)).container();
        }
        return new class_1799((class_1935)class_1802.field_8469);
    }

    public static boolean canBeDistillated(class_1799 stack) {
        DrinkType type = DrinkUtils.getType(stack);
        boolean already = DrinkUtils.getDistillationStatus(stack);
        return !already && (type != null && type.requireDistillation() || stack.method_31574(BrewItems.INGREDIENT_MIXTURE));
    }

    public static double getAgeInTicks(class_1799 stack) {
        return DrinkUtils.getAgeInTicks(stack, Double.MIN_VALUE);
    }

    public static double getAgeInTicks(class_1799 stack, double defaultValue) {
        if (stack.method_57826(BrewComponents.BREW_DATA)) {
            return Objects.requireNonNull((BrewData)stack.method_58694(BrewComponents.BREW_DATA)).age();
        }
        return defaultValue;
    }

    public static double getCookingAgeInTicks(class_1799 stack) {
        return DrinkUtils.getCookingInTicks(stack, Double.MIN_VALUE);
    }

    public static double getCookingInTicks(class_1799 stack, double defaultValue) {
        if (stack.method_57826(BrewComponents.COOKING_DATA)) {
            return Objects.requireNonNull((CookingData)stack.method_58694(BrewComponents.COOKING_DATA)).time();
        }
        return defaultValue;
    }

    public static double getAgeInSeconds(class_1799 stack) {
        return DrinkUtils.getAgeInTicks(stack) / 20.0;
    }

    public static double getCookingAgeInSeconds(class_1799 stack) {
        return DrinkUtils.getCookingAgeInTicks(stack) / 20.0;
    }

    public static class_1799 createDrink(class_2960 type, int age, double quality, int distillated, class_2248 heatingSource) {
        return DrinkUtils.createDrink(type, age, quality, distillated, new CookingData(0.0, List.of(), heatingSource, class_1799.field_8037));
    }

    public static class_1799 createDrink(class_2960 type, int age, double quality, int distillated, CookingData cookingData) {
        class_1799 stack = new class_1799((class_1935)BrewItems.DRINK_ITEM);
        stack.method_57379(BrewComponents.BREW_DATA, (Object)new BrewData(Optional.of(type), quality, "", distillated, age));
        stack.method_57379(BrewComponents.COOKING_DATA, (Object)cookingData);
        return stack;
    }

    public static List<DrinkType> findTypes(List<class_1799> ingredients, class_2960 barrelType, class_2248 heatSource, class_1799 container) {
        if (ingredients.isEmpty()) {
            return List.of();
        }
        ArrayList<DrinkType> list = new ArrayList<DrinkType>();
        block0: for (DrinkType type : BreweryInit.DRINK_TYPES.values()) {
            if ((barrelType != null || !type.barrelInfo().isEmpty()) && (barrelType == null || type.getBarrelInfo(barrelType) == null) || type.ingredients().isEmpty() || !type.heatSource().isEmpty() && !type.heatSource().get().method_40241(class_7923.field_41175.method_47983((Object)heatSource)) || !type.requiredContainer().method_8093(container)) continue;
            ArrayList<class_1799> ing = new ArrayList<class_1799>(ingredients.size());
            for (class_1799 i : ingredients) {
                ing.add(new class_1799((class_1935)i.method_7909(), i.method_7947()));
            }
            for (DrinkType.BrewIngredient ingredient : type.ingredients()) {
                int count = ingredient.count();
                for (class_1799 stack : ing) {
                    if (stack.method_7960() || !ingredient.items().contains(stack.method_7909())) continue;
                    if ((count -= stack.method_7947()) < 0) continue block0;
                    stack.method_7939(0);
                }
                if (count == 0) continue;
                continue block0;
            }
            list.add(type);
        }
        return list;
    }
}

