/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.drink;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.drink.AlcoholManager;
import eu.pb4.brewery.drink.ConsumptionEffect;
import eu.pb4.brewery.drink.DrinkInfo;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.drink.ExpressionUtil;
import eu.pb4.brewery.drink.WrappedExpression;
import eu.pb4.brewery.other.BrewUtils;
import eu.pb4.brewery.other.FloatSelector;
import eu.pb4.brewery.other.WrappedText;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7876;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public record DrinkType(Looks looks, class_1856 requiredContainer, List<BarrelInfo> barrelInfo, WrappedExpression baseQuality, WrappedExpression drinkingTime, WrappedExpression alcoholicValue, List<ConsumptionEffect> consumptionEffects, WrappedExpression cookingQualityMult, List<BrewIngredient> ingredients, int distillationRuns, List<ConsumptionEffect> unfinishedEffects, Optional<DrinkInfo> info, boolean showQuality, Optional<class_6885<class_2248>> heatSource) {
    public static MapCodec<DrinkType> CODEC_V4 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecordCodecBuilder.mapCodec(instance2 -> instance2.group((App)FloatSelector.createQualityCodec(WrappedText.CODEC, null).fieldOf("name").forGetter(Looks::nameSelector), (App)FloatSelector.createQualityCodec(class_5251.field_39242, null).fieldOf("color").forGetter(Looks::colorSelector), (App)FloatSelector.createQualityCodec(ItemLookData.CODEC, ItemLookData.DEFAULT).optionalFieldOf("visual", FloatSelector.of(ItemLookData.DEFAULT)).forGetter(Looks::visualsSelector), (App)FloatSelector.createQualityCodec(class_5251.field_39242, null).optionalFieldOf("unfinished_color").forGetter(Looks::unfinishedColorSelector), (App)FloatSelector.createQualityCodec(ItemLookData.CODEC, null).optionalFieldOf("unfinished_visual").forGetter(Looks::unfinishedVisualsSelector), (App)class_5251.field_39242.optionalFieldOf("failed_color").forGetter(Looks::failedColorSelector), (App)ItemLookData.CODEC.optionalFieldOf("failed_visual").forGetter(Looks::failedVisualsSelector)).apply((Applicative)instance2, Looks::new)).forGetter(DrinkType::looks), (App)class_1856.field_46095.optionalFieldOf("required_container", (Object)class_1856.method_8101((class_1935)class_1802.field_8469)).forGetter(DrinkType::requiredContainer), (App)Codec.list(BarrelInfo.CODEC_V1).optionalFieldOf("barrel_definitions", List.of()).forGetter(DrinkType::barrelInfo), (App)ExpressionUtil.createCodec("age").fieldOf("base_quality_value").forGetter(DrinkType::baseQuality), (App)ExpressionUtil.COMMON_EXPRESSION.optionalFieldOf("drinking_time").xmap(x -> x.orElse(ExpressionUtil.DEFAULT_DRINKING_TIME), Optional::of).forGetter(DrinkType::drinkingTime), (App)ExpressionUtil.COMMON_EXPRESSION.fieldOf("alcoholic_value").forGetter(DrinkType::alcoholicValue), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("effects", new ArrayList()).forGetter(DrinkType::consumptionEffects), (App)ExpressionUtil.createCodec("age").fieldOf("cooking_quality_multiplier").forGetter(DrinkType::cookingQualityMult), (App)Codec.list(BrewIngredient.CODEC_V1).optionalFieldOf("ingredients", new ArrayList()).forGetter(DrinkType::ingredients), (App)Codec.INT.optionalFieldOf("distillation_runs", (Object)0).forGetter(DrinkType::distillationRuns), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("unfinished_brew_effects", new ArrayList()).forGetter(DrinkType::unfinishedEffects), (App)DrinkInfo.CODEC.optionalFieldOf("book_information").forGetter(DrinkType::info), (App)Codec.BOOL.optionalFieldOf("show_quality", (Object)true).forGetter(DrinkType::showQuality), (App)class_6895.method_40340((class_5321)class_7924.field_41254).optionalFieldOf("required_heat_source").forGetter(DrinkType::heatSource)).apply((Applicative)instance, DrinkType::new));
    public static MapCodec<DrinkType> CODEC_V3 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecordCodecBuilder.mapCodec(instance2 -> instance2.group((App)FloatSelector.createSingularCodec(WrappedText.CODEC).fieldOf("name").forGetter(Looks::nameSelector), (App)FloatSelector.createSingularCodec(class_5251.field_39242).fieldOf("color").forGetter(Looks::colorSelector), (App)FloatSelector.createSingularCodec(ItemLookData.CODEC_LEGACY).optionalFieldOf("visual", FloatSelector.of(ItemLookData.DEFAULT)).forGetter(Looks::visualsSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::unfinishedColorSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::unfinishedVisualsSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::failedColorSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::failedVisualsSelector)).apply((Applicative)instance2, Looks::new)).forGetter(DrinkType::looks), (App)MapCodec.unit((Object)class_1856.method_8101((class_1935)class_1802.field_8469)).forGetter(DrinkType::requiredContainer), (App)Codec.list(BarrelInfo.CODEC_V1).optionalFieldOf("barrel_definitions", List.of()).forGetter(DrinkType::barrelInfo), (App)ExpressionUtil.createCodec("age").fieldOf("base_quality_value").forGetter(DrinkType::baseQuality), (App)MapCodec.unit((Object)ExpressionUtil.LEGACY_DRINKING_TIME).forGetter(DrinkType::drinkingTime), (App)ExpressionUtil.COMMON_EXPRESSION.fieldOf("alcoholic_value").forGetter(DrinkType::alcoholicValue), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("effects", new ArrayList()).forGetter(DrinkType::consumptionEffects), (App)ExpressionUtil.createCodec("age").fieldOf("cooking_quality_multiplier").forGetter(DrinkType::cookingQualityMult), (App)Codec.list(BrewIngredient.CODEC_V1).optionalFieldOf("ingredients", new ArrayList()).forGetter(DrinkType::ingredients), (App)Codec.INT.optionalFieldOf("distillation_runs", (Object)0).forGetter(DrinkType::distillationRuns), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("unfinished_brew_effects", new ArrayList()).forGetter(DrinkType::unfinishedEffects), (App)DrinkInfo.CODEC.optionalFieldOf("book_information").forGetter(DrinkType::info), (App)Codec.BOOL.optionalFieldOf("show_quality", (Object)true).forGetter(DrinkType::showQuality), (App)class_6895.method_40340((class_5321)class_7924.field_41254).optionalFieldOf("required_heat_source").forGetter(DrinkType::heatSource)).apply((Applicative)instance, DrinkType::new));
    public static MapCodec<DrinkType> CODEC_V2 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecordCodecBuilder.mapCodec(instance2 -> instance2.group((App)FloatSelector.createSingularCodec(WrappedText.CODEC).fieldOf("name").forGetter(Looks::nameSelector), (App)FloatSelector.createSingularCodec(class_5251.field_39242).fieldOf("color").forGetter(Looks::colorSelector), (App)FloatSelector.createSingularCodec(ItemLookData.CODEC_LEGACY).optionalFieldOf("visual", FloatSelector.of(ItemLookData.DEFAULT)).forGetter(Looks::visualsSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::unfinishedColorSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::unfinishedVisualsSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::failedColorSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::failedVisualsSelector)).apply((Applicative)instance2, Looks::new)).forGetter(DrinkType::looks), (App)MapCodec.unit((Object)class_1856.method_8101((class_1935)class_1802.field_8469)).forGetter(DrinkType::requiredContainer), (App)Codec.list(BarrelInfo.CODEC_V1).optionalFieldOf("barrel_definitions", List.of()).forGetter(DrinkType::barrelInfo), (App)ExpressionUtil.createCodec("age").fieldOf("base_quality_value").forGetter(DrinkType::baseQuality), (App)MapCodec.unit((Object)ExpressionUtil.LEGACY_DRINKING_TIME).forGetter(DrinkType::drinkingTime), (App)ExpressionUtil.COMMON_EXPRESSION.fieldOf("alcoholic_value").forGetter(DrinkType::alcoholicValue), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("entries", new ArrayList()).forGetter(DrinkType::consumptionEffects), (App)ExpressionUtil.createCodec("age").fieldOf("cooking_quality_multiplier").forGetter(DrinkType::cookingQualityMult), (App)Codec.list(BrewIngredient.CODEC_V1).optionalFieldOf("ingredients", new ArrayList()).forGetter(DrinkType::ingredients), (App)Codec.INT.optionalFieldOf("distillation_runs", (Object)0).forGetter(DrinkType::distillationRuns), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("unfinished_brew_effects", new ArrayList()).forGetter(DrinkType::unfinishedEffects), (App)DrinkInfo.CODEC.optionalFieldOf("book_information").forGetter(DrinkType::info), (App)Codec.BOOL.optionalFieldOf("show_quality", (Object)true).forGetter(DrinkType::showQuality), (App)class_6895.method_40340((class_5321)class_7924.field_41254).optionalFieldOf("required_heat_source").forGetter(DrinkType::heatSource)).apply((Applicative)instance, DrinkType::new));
    public static MapCodec<DrinkType> CODEC_V1 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecordCodecBuilder.mapCodec(instance2 -> instance2.group((App)FloatSelector.createSingularCodec(WrappedText.CODEC).fieldOf("name").forGetter(Looks::nameSelector), (App)FloatSelector.createSingularCodec(class_5251.field_39242).fieldOf("color").forGetter(Looks::colorSelector), (App)FloatSelector.createSingularCodec(ItemLookData.CODEC_LEGACY).optionalFieldOf("visual", FloatSelector.of(ItemLookData.DEFAULT)).forGetter(Looks::visualsSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::unfinishedColorSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::unfinishedVisualsSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::failedColorSelector), (App)MapCodec.unit(Optional.empty()).forGetter(Looks::failedVisualsSelector)).apply((Applicative)instance2, Looks::new)).forGetter(DrinkType::looks), (App)MapCodec.unit((Object)class_1856.method_8101((class_1935)class_1802.field_8469)).forGetter(DrinkType::requiredContainer), (App)Codec.list(BarrelInfo.CODEC_V1).optionalFieldOf("barrel_definitions", List.of()).forGetter(DrinkType::barrelInfo), (App)ExpressionUtil.createCodec("age").fieldOf("base_quality_value").forGetter(DrinkType::baseQuality), (App)MapCodec.unit((Object)ExpressionUtil.LEGACY_DRINKING_TIME).forGetter(DrinkType::drinkingTime), (App)ExpressionUtil.COMMON_EXPRESSION.fieldOf("alcoholic_value").forGetter(DrinkType::alcoholicValue), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("entries", new ArrayList()).forGetter(DrinkType::consumptionEffects), (App)ExpressionUtil.createCodec("age").fieldOf("cooking_quality_multiplier").forGetter(DrinkType::cookingQualityMult), (App)Codec.list(BrewIngredient.CODEC_V1).optionalFieldOf("ingredients", new ArrayList()).forGetter(DrinkType::ingredients), (App)Codec.BOOL.xmap(x -> x != false ? 1 : 0, i -> i == 1).optionalFieldOf("require_distillation", (Object)0).forGetter(DrinkType::distillationRuns), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("unfinished_brew_effects", new ArrayList()).forGetter(DrinkType::unfinishedEffects), (App)DrinkInfo.CODEC.optionalFieldOf("book_information").forGetter(DrinkType::info), (App)Codec.BOOL.optionalFieldOf("show_quality", (Object)true).forGetter(DrinkType::showQuality), (App)class_6895.method_40340((class_5321)class_7924.field_41254).optionalFieldOf("required_heat_source").forGetter(DrinkType::heatSource)).apply((Applicative)instance, DrinkType::new));
    public static final Codec<DrinkType> CODEC = new MapCodec.MapCodecCodec((MapCodec)new MapCodec<DrinkType>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString("version"));
        }

        public <T> DataResult<DrinkType> decode(DynamicOps<T> ops, MapLike<T> input) {
            int version = ops.getNumberValue(input.get("version"), (Number)0).intValue();
            return switch (version) {
                case 1 -> CODEC_V1.decode(ops, input);
                case 2 -> CODEC_V2.decode(ops, input);
                case 3 -> CODEC_V3.decode(ops, input);
                default -> CODEC_V4.decode(ops, input);
            };
        }

        public <T> RecordBuilder<T> encode(DrinkType input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return CODEC_V4.encode((Object)input, ops, prefix.add("version", ops.createInt(4)));
        }
    });

    public static DrinkType create(class_2960 identifier, class_5251 color, List<BarrelInfo> barrelInfo, String quality, String alcoholicValue, List<ConsumptionEffect> consumptionEffects, String cookingTime, List<BrewIngredient> ingredients, DrinkInfo info) {
        return DrinkType.create(identifier, color, barrelInfo, quality, alcoholicValue, consumptionEffects, cookingTime, ingredients, false, List.of(), info);
    }

    public static DrinkType create(class_2960 identifier, class_5251 color, List<BarrelInfo> barrelInfo, String quality, String alcoholicValue, List<ConsumptionEffect> consumptionEffects, String cookingTime, List<BrewIngredient> ingredients, boolean requireDistillation, List<ConsumptionEffect> unfinishedEffects, DrinkInfo info) {
        return DrinkType.create(identifier, color, barrelInfo, quality, alcoholicValue, consumptionEffects, cookingTime, ingredients, requireDistillation ? 1 : 0, unfinishedEffects, info);
    }

    public static DrinkType create(class_2960 identifier, class_5251 color, List<BarrelInfo> barrelInfo, String quality, String alcoholicValue, List<ConsumptionEffect> consumptionEffects, String cookingTime, List<BrewIngredient> ingredients, int distillationRuns, List<ConsumptionEffect> unfinishedEffects, DrinkInfo info) {
        return DrinkType.create(identifier, color, barrelInfo, quality, alcoholicValue, consumptionEffects, cookingTime, ingredients, distillationRuns, unfinishedEffects, info, Optional.empty());
    }

    public static DrinkType create(class_2960 identifier, class_5251 color, List<BarrelInfo> barrelInfo, String quality, String alcoholicValue, List<ConsumptionEffect> consumptionEffects, String cookingTime, List<BrewIngredient> ingredients, int distillationRuns, List<ConsumptionEffect> unfinishedEffects, DrinkInfo info, class_6862<class_2248> heatSource) {
        return DrinkType.create(identifier, color, barrelInfo, quality, alcoholicValue, consumptionEffects, cookingTime, ingredients, distillationRuns, unfinishedEffects, info, Optional.of(class_6885.method_45924((class_7876)class_7923.field_41175, heatSource)));
    }

    public static DrinkType create(class_2960 identifier, class_5251 color, List<BarrelInfo> barrelInfo, String quality, String alcoholicValue, List<ConsumptionEffect> consumptionEffects, String cookingTime, List<BrewIngredient> ingredients, int distillationRuns, List<ConsumptionEffect> unfinishedEffects, DrinkInfo info, Optional<class_6885<class_2248>> heatSource) {
        return new DrinkType(new Looks(FloatSelector.of(WrappedText.of((class_2561)class_2561.method_43471((String)class_156.method_646((String)"drinktype", (class_2960)identifier)))), FloatSelector.of(color), FloatSelector.of(ItemLookData.DEFAULT.withResourcePackModel(identifier.method_45138("brewery_drink/"))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()), class_1856.method_8101((class_1935)class_1802.field_8469), barrelInfo, WrappedExpression.create(quality, "age"), ExpressionUtil.DEFAULT_DRINKING_TIME, WrappedExpression.createDefault(alcoholicValue), consumptionEffects, WrappedExpression.create(cookingTime, "age"), ingredients, distillationRuns, unfinishedEffects, Optional.of(info), true, heatSource);
    }

    public WrappedText name(class_1799 stack) {
        return this.looks.nameSelector.select((float)DrinkUtils.getQuality(stack));
    }

    public int color(class_1799 stack) {
        float quality = (float)DrinkUtils.getQuality(stack);
        if (!this.isFinished(stack)) {
            return this.looks.unfinishedColorSelector.map(textColorFloatSelector -> ((class_5251)textColorFloatSelector.select(quality)).method_27716()).orElseGet(() -> class_9848.method_61319((float)0.5f, (int)this.looks.colorSelector.select(quality).method_27716(), (int)3694022));
        }
        return this.looks.colorSelector.select(quality).method_27716();
    }

    public ItemLookData visuals(class_1799 stack) {
        float quality = (float)DrinkUtils.getQuality(stack);
        if (!this.isFinished(stack) && this.looks.unfinishedVisualsSelector.isPresent()) {
            return this.looks.unfinishedVisualsSelector.get().select(quality);
        }
        return this.looks.visualsSelector.select(quality);
    }

    public int failedColor() {
        return this.looks.failedColorSelector.orElseGet(() -> class_5251.method_27717((int)334346)).method_27716();
    }

    public ItemLookData failedVisuals() {
        return this.looks.failedVisualsSelector.orElseGet(() -> this.looks.visualsSelector.select(0.0f));
    }

    public boolean requireDistillation() {
        return this.distillationRuns > 0;
    }

    @Nullable
    public BarrelInfo getBarrelInfo(class_2960 barrelType) {
        BarrelInfo def = null;
        for (BarrelInfo info : this.barrelInfo) {
            if (info.type.equals((Object)barrelType)) {
                return info;
            }
            if (!info.type.equals((Object)BarrelInfo.ANY)) continue;
            def = info;
        }
        return def;
    }

    public boolean isFinished(class_1799 itemStack) {
        return DrinkUtils.getAgeInSeconds(itemStack) >= 0.0 && (!this.requireDistillation() || DrinkUtils.getDistillationStatus(itemStack));
    }

    public double drinkingTime(class_1799 stack, class_1309 entity) {
        return this.drinkingTime.expression().setVariable("age", DrinkUtils.getAgeInSeconds(stack)).setVariable("quality", DrinkUtils.getQuality(stack)).setVariable("userAlcoholLevel", AlcoholManager.of(entity).getModifiedAlcoholLevel()).evaluate();
    }

    public record Looks(FloatSelector<WrappedText> nameSelector, FloatSelector<class_5251> colorSelector, FloatSelector<ItemLookData> visualsSelector, Optional<FloatSelector<class_5251>> unfinishedColorSelector, Optional<FloatSelector<ItemLookData>> unfinishedVisualsSelector, Optional<class_5251> failedColorSelector, Optional<ItemLookData> failedVisualsSelector) {
    }

    public record ItemLookData(class_2960 defaultModel, Optional<class_2960> resourcePackModel, Optional<class_9323> components, boolean particles, class_6880<class_3414> soundEvent, class_1839 animation) {
        public static final ItemLookData DEFAULT = new ItemLookData(class_2960.method_60656((String)"potion"), Optional.empty(), Optional.empty(), false, (class_6880<class_3414>)class_3417.field_20613, class_1839.field_8946);
        public static Codec<ItemLookData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("model", (Object)ItemLookData.DEFAULT.defaultModel).forGetter(ItemLookData::defaultModel), (App)class_2960.field_25139.optionalFieldOf("resource_pack_model").forGetter(ItemLookData::resourcePackModel), (App)class_9323.field_50234.optionalFieldOf("components").forGetter(ItemLookData::components), (App)Codec.BOOL.optionalFieldOf("particles", (Object)ItemLookData.DEFAULT.particles).forGetter(ItemLookData::particles), (App)class_3414.field_41699.optionalFieldOf("sound_event", ItemLookData.DEFAULT.soundEvent).forGetter(ItemLookData::soundEvent), (App)class_1839.field_53764.optionalFieldOf("animation", (Object)ItemLookData.DEFAULT.animation).forGetter(ItemLookData::animation)).apply((Applicative)instance, ItemLookData::new));
        public static Codec<ItemLookData> CODEC_LEGACY = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("item", (Object)ItemLookData.DEFAULT.defaultModel).forGetter(ItemLookData::defaultModel), (App)class_2960.field_25139.optionalFieldOf("model").forGetter(ItemLookData::resourcePackModel), (App)class_9323.field_50234.optionalFieldOf("components").forGetter(ItemLookData::components), (App)Codec.BOOL.optionalFieldOf("particles", (Object)ItemLookData.DEFAULT.particles).forGetter(ItemLookData::particles), (App)class_3414.field_41699.optionalFieldOf("sound_event", ItemLookData.DEFAULT.soundEvent).forGetter(ItemLookData::soundEvent), (App)class_1839.field_53764.optionalFieldOf("animation", (Object)ItemLookData.DEFAULT.animation).forGetter(ItemLookData::animation)).apply((Applicative)instance, ItemLookData::new));

        public ItemLookData withModel(class_2960 identifier) {
            return new ItemLookData(identifier, this.resourcePackModel, this.components, this.particles, this.soundEvent, this.animation);
        }

        public ItemLookData withResourcePackModel(class_2960 identifier) {
            return new ItemLookData(this.defaultModel, Optional.ofNullable(identifier), this.components, this.particles, this.soundEvent, this.animation);
        }
    }

    public record BarrelInfo(class_2960 type, WrappedExpression qualityChange, int baseTime) {
        public static final class_2960 ANY = BreweryInit.id("any_barrel");
        public static final class_2960 NONE = BreweryInit.id("none");
        protected static Codec<class_2960> TYPE_CODEC = Codec.STRING.xmap(x -> x.equals("*") ? ANY : BrewUtils.tryParsingId(x, NONE), x -> x.equals((Object)ANY) ? "*" : x.toString());
        public static Codec<BarrelInfo> CODEC_V1 = RecordCodecBuilder.create(instance -> instance.group((App)TYPE_CODEC.fieldOf("type").forGetter(BarrelInfo::type), (App)ExpressionUtil.COMMON_EXPRESSION.fieldOf("quality_value").forGetter(BarrelInfo::qualityChange), (App)class_5699.field_33442.fieldOf("reveal_time").forGetter(BarrelInfo::baseTime)).apply((Applicative)instance, BarrelInfo::new));

        public static BarrelInfo of(String type, String qualityChange, int baseTime) {
            return BarrelInfo.of(type.equals("*") ? ANY : class_2960.method_60654((String)type), qualityChange, baseTime);
        }

        public static BarrelInfo of(class_2960 type, String qualityChange, int baseTime) {
            return new BarrelInfo(type, WrappedExpression.createDefault(qualityChange), baseTime);
        }
    }

    public record BrewIngredient(List<class_1792> items, int count, class_1799 returnedItemStack) {
        public static Codec<BrewIngredient> CODEC_V1 = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)class_7923.field_41178.method_39673()).fieldOf("items").forGetter(BrewIngredient::items), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(BrewIngredient::count), (App)class_1799.field_24671.optionalFieldOf("dropped_stack", (Object)class_1799.field_8037).forGetter(BrewIngredient::returnedItemStack)).apply((Applicative)instance, BrewIngredient::new));

        public static BrewIngredient of(int count, class_1792 ... items) {
            return new BrewIngredient(List.of(items), count, class_1799.field_8037);
        }

        public static BrewIngredient of(int count, class_1799 stack, class_1792 ... items) {
            return new BrewIngredient(List.of(items), count, stack);
        }

        public static BrewIngredient of(class_1792 ... items) {
            return new BrewIngredient(List.of(items), 1, class_1799.field_8037);
        }
    }
}

